/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit;

import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class TextFormatterTools {
    private static final String ipAddressRegex = TextFormatterTools.makePartialIPRegex();

    public static TextFormatter<String> ipAddressTextFormatter() {
        return TextFormatterTools.ipAddressTextFormatter(null);
    }

    public static TextFormatter<String> ipAddressTextFormatter(String defaultValue) {
        UnaryOperator ipAddressFilter = change -> change.getControlNewText().matches(ipAddressRegex) ? change : null;
        return new TextFormatter((StringConverter)new DefaultStringConverter(), (Object)defaultValue, ipAddressFilter);
    }

    private static String makePartialIPRegex() {
        String partialBlock = "(([01]?[0-9]{0,2})|(2[0-4][0-9])|(25[0-5]))";
        String subsequentPartialBlock = "(\\." + partialBlock + ")";
        String ipAddress = partialBlock + "?" + subsequentPartialBlock + "{0,3}";
        return "^" + ipAddress;
    }

    public static TextFormatter<String> maxLengthTextFormatter(int maxCharacters) {
        UnaryOperator lengthFilter = change -> change.getControlNewText().length() <= maxCharacters ? change : null;
        return new TextFormatter(lengthFilter);
    }
}

