/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit;

import java.text.DecimalFormat;
import javafx.util.StringConverter;

public abstract class StringConverterTools {
    public static StringConverter<Double> metersToRoundedCentimeters() {
        return StringConverterTools.rounding(100.0, 0);
    }

    public static StringConverter<Double> metersToRoundedMillimeters() {
        return StringConverterTools.rounding(1000.0, 0);
    }

    public static StringConverter<Double> radiansToRoundedDegrees() {
        return StringConverterTools.rounding(57.29577951308232, 0);
    }

    public static StringConverter<Double> thousandRounding(boolean appendK) {
        return StringConverterTools.rounding(0.001, 0, "k");
    }

    public static StringConverter<Double> rounding(double toStringScale, int numberOfDecimals) {
        return StringConverterTools.rounding(toStringScale, numberOfDecimals, "");
    }

    public static StringConverter<Double> rounding(final double toStringScale, int numberOfDecimals, String suffix) {
        DecimalFormat formatter;
        if (numberOfDecimals == 0) {
            formatter = new DecimalFormat("0" + suffix + ";-0" + suffix);
        } else {
            String decimalPart = StringConverterTools.repeatString("0", numberOfDecimals);
            formatter = new DecimalFormat("0." + decimalPart + suffix + ";-0." + decimalPart + suffix);
        }
        return new StringConverter<Double>(){

            public String toString(Double object) {
                return formatter.format(object * toStringScale);
            }

            public Double fromString(String string) {
                return Double.parseDouble(string) / toStringScale;
            }
        };
    }

    private static String repeatString(String s, int n) {
        return new String(new char[n]).replace("\u0000", s);
    }
}

