/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.text;

import javafx.geometry.Bounds;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.fxyz3d.shapes.primitives.Text3DMesh;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class Text3D {
    private Text3DMesh text3dMesh;
    private Point3DBasics positionDecoupled;
    private Point3D rotationAxisDecoupled;
    private double rotationAngleDecoupled;
    private double fontHeightDecoupled;
    private double fontThicknessDecoupled;

    public Text3D(String text) {
        this.text3dMesh = new Text3DMesh(text);
        this.positionDecoupled = new us.ihmc.euclid.tuple3D.Point3D();
        this.rotationAxisDecoupled = new Point3D(0.0, 0.0, 1.0);
        this.fontThicknessDecoupled = 0.1;
        this.setFontHeight(1.0);
    }

    public void setFontColor(Color color) {
        this.text3dMesh.setTextureModeNone(color);
    }

    public void setFontHeight(double fontHeight) {
        this.fontHeightDecoupled = fontHeight;
        this.text3dMesh.setScaleX(this.fontHeightDecoupled / (double)this.text3dMesh.getFontSize());
        this.text3dMesh.setScaleY(this.fontHeightDecoupled / (double)this.text3dMesh.getFontSize());
        this.text3dMesh.setScaleZ(this.fontHeightDecoupled / (double)this.text3dMesh.getFontSize());
        this.setFontThickness(this.fontThicknessDecoupled);
    }

    public void setFontThickness(double fontThickness) {
        this.fontThicknessDecoupled = fontThickness;
        this.text3dMesh.setHeight(this.fontThicknessDecoupled / (this.fontHeightDecoupled / (double)this.text3dMesh.getFontSize()));
        this.setPosition((Point3DReadOnly)this.positionDecoupled);
        this.setOrientation(this.rotationAxisDecoupled, this.rotationAngleDecoupled);
    }

    public void setPosition(Point3DReadOnly position) {
        this.positionDecoupled.set((Tuple3DReadOnly)position);
        Bounds boundsInLocal = this.text3dMesh.getBoundsInLocal();
        this.text3dMesh.setTranslateX((boundsInLocal.getMinX() - boundsInLocal.getMaxX()) / 2.0 - boundsInLocal.getMinX() + this.positionDecoupled.getX());
        this.text3dMesh.setTranslateY((boundsInLocal.getMaxY() - boundsInLocal.getMinY()) / 2.0 - boundsInLocal.getMaxY() + this.positionDecoupled.getY());
        this.text3dMesh.setTranslateZ((boundsInLocal.getMinZ() - boundsInLocal.getMaxZ()) / 2.0 - boundsInLocal.getMinZ() + this.positionDecoupled.getZ());
    }

    public void setOrientation(AxisAngle orientation) {
        this.rotationAngleDecoupled = orientation.getAngle();
        this.rotationAxisDecoupled = new Point3D(orientation.getX(), orientation.getY(), orientation.getZ());
        this.setOrientation(this.rotationAxisDecoupled, this.rotationAngleDecoupled);
    }

    private void setOrientation(Point3D axis, double angle) {
        this.text3dMesh.setRotationAxis(this.rotationAxisDecoupled);
        this.text3dMesh.setRotate(this.rotationAngleDecoupled);
    }

    public Node getNode() {
        return this.text3dMesh;
    }
}

