/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.shapes;

import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import us.ihmc.commons.MathTools;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;

public class TextureColorPalette1D
implements TextureColorPalette {
    private static final boolean PRINT_PALETTE = false;
    private static final int DEFAULT_RESOLUTION = 256;
    private int hueResolution = -1;
    private int saturationResolution = -1;
    private int brightnessResolution = -1;
    private double hueConstant = Double.NaN;
    private double saturationConstant = Double.NaN;
    private double brightnessConstant = Double.NaN;
    private Image colorPalette;

    public TextureColorPalette1D() {
        this.setHueBased(1.0, 1.0);
    }

    public void setHueBased(double saturationConstant, double brightnessConstant) {
        this.setHueBased(256, saturationConstant, brightnessConstant);
    }

    public void setHueBased(int hueResolution, double saturationConstant, double brightnessConstant) {
        MathTools.checkGreaterThanOrEquals((double)hueResolution, (double)1.0);
        MathTools.checkIntervalContains((double)saturationConstant, (double)0.0, (double)1.0);
        MathTools.checkIntervalContains((double)brightnessConstant, (double)0.0, (double)1.0);
        this.hueResolution = hueResolution;
        this.saturationResolution = -1;
        this.brightnessResolution = -1;
        this.hueConstant = Double.NaN;
        this.saturationConstant = saturationConstant;
        this.brightnessConstant = brightnessConstant;
        this.updateColorPalette();
    }

    public void setSaturationBased(double hueConstant, double brightnessConstant) {
        this.setSaturationBased(256, hueConstant, brightnessConstant);
    }

    public void setSaturationBased(int saturationResolution, double hueConstant, double brightnessConstant) {
        MathTools.checkGreaterThanOrEquals((double)saturationResolution, (double)1.0);
        MathTools.checkIntervalContains((double)brightnessConstant, (double)0.0, (double)1.0);
        this.hueResolution = -1;
        this.saturationResolution = saturationResolution;
        this.brightnessResolution = -1;
        this.hueConstant = hueConstant;
        this.saturationConstant = brightnessConstant;
        this.brightnessConstant = Double.NaN;
        this.updateColorPalette();
    }

    public void setBrightnessBased(double hueConstant, double saturationConstant) {
        this.setBrightnessBased(256, hueConstant, saturationConstant);
    }

    public void setBrightnessBased(int brightnessResolution, double hueConstant, double saturationConstant) {
        MathTools.checkGreaterThanOrEquals((double)brightnessResolution, (double)1.0);
        MathTools.checkIntervalContains((double)saturationConstant, (double)0.0, (double)1.0);
        this.hueResolution = -1;
        this.saturationResolution = -1;
        this.brightnessResolution = brightnessResolution;
        this.hueConstant = hueConstant;
        this.saturationConstant = saturationConstant;
        this.brightnessConstant = Double.NaN;
        this.updateColorPalette();
    }

    private void updateColorPalette() {
        int resolution = this.hueResolution != -1 ? this.hueResolution : (this.saturationResolution != -1 ? this.saturationResolution : this.brightnessResolution);
        int width = resolution;
        int height = 50;
        WritableImage image = new WritableImage(width, height);
        PixelWriter pw = image.getPixelWriter();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                pw.setColor(x, y, this.getColorAtIndex(x));
            }
        }
        this.colorPalette = image;
    }

    private Color getColorAtIndex(int x) {
        double hue = this.hueResolution != -1 ? 360.0 * (double)x / (double)this.hueResolution : 360.0 * this.hueConstant;
        double saturation = this.saturationResolution != -1 ? (double)x / (double)this.saturationResolution : this.saturationConstant;
        double brightness = this.brightnessResolution != -1 ? (double)x / (double)this.brightnessResolution : this.brightnessConstant;
        return Color.hsb((double)hue, (double)saturation, (double)brightness);
    }

    @Override
    public float[] getTextureLocation(Color color) {
        float x = this.hueResolution != -1 ? (float)(color.getHue() / 360.0) : (this.saturationResolution != -1 ? (float)color.getSaturation() : (float)color.getBrightness());
        float y = 0.5f;
        return new float[]{x, y};
    }

    @Override
    public Image getColorPalette() {
        return this.colorPalette;
    }
}

