/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.shapes;

import java.util.Arrays;
import java.util.List;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette2D;

public class JavaFXMultiColorMeshBuilder {
    private static final int DEFAULT_RES = 32;
    private final JavaFXMeshBuilder meshBuilder = new JavaFXMeshBuilder();
    private TextureColorPalette colorPalette;

    public JavaFXMultiColorMeshBuilder() {
        this.colorPalette = new TextureColorPalette2D();
    }

    public JavaFXMultiColorMeshBuilder(TextureColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void addBox(double lx, double ly, double lz, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cube((double)lx, (double)ly, (double)lz, (boolean)true, null), offset, color);
    }

    public void addBox(float lx, float ly, float lz, Color color) {
        this.addMesh(MeshDataGenerator.Cube((float)lx, (float)ly, (float)lz, (boolean)true, null), color);
    }

    public void addBox(float lx, float ly, float lz, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cube((float)lx, (float)ly, (float)lz, (boolean)true, null), offset, color);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.addMesh(MeshDataGenerator.Cone((double)height, (double)radius, (int)32), offset, orientation, color);
    }

    public void addCone(double height, double radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cone((double)height, (double)radius, (int)32), offset, color);
    }

    public void addCube(double size, double xOffset, double yOffset, double zOffset, Color color) {
        this.addBox(size, size, size, (Tuple3DReadOnly)new Point3D(xOffset, yOffset, zOffset), color);
    }

    public void addCube(double size, Tuple3DReadOnly pointsOffset, Color color) {
        this.addBox(size, size, size, pointsOffset, color);
    }

    public void addCube(float size, Tuple3DReadOnly pointsOffset, Color color) {
        this.addBox(size, size, size, pointsOffset, color);
    }

    public void addCylinder(double height, double radius, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.addMesh(MeshDataGenerator.Cylinder((double)radius, (double)height, (int)32), offset, orientation, color);
    }

    public void addCylinder(double height, double radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Cylinder((double)radius, (double)height, (int)32), offset, color);
    }

    public void addLine(double x0, double y0, double z0, double xf, double yf, double zf, double lineWidth, Color color) {
        this.addMesh(MeshDataGenerator.Line((double)x0, (double)y0, (double)z0, (double)xf, (double)yf, (double)zf, (double)lineWidth), color);
    }

    public void addLine(double x0, double y0, double z0, double xf, double yf, double zf, double lineWidth, Color startColor, Color endColor) {
        this.addLine((float)x0, (float)y0, (float)z0, (float)xf, (float)yf, (float)zf, (float)lineWidth, startColor, endColor);
    }

    public void addLine(float x0, float y0, float z0, float xf, float yf, float zf, float lineWidth, Color color) {
        this.addMesh(MeshDataGenerator.Line((float)x0, (float)y0, (float)z0, (float)xf, (float)yf, (float)zf, (float)lineWidth), color);
    }

    public void addLine(float x0, float y0, float z0, float xf, float yf, float zf, float lineWidth, Color startColor, Color endColor) {
        MeshDataHolder lineMeshData = MeshDataGenerator.Line((float)x0, (float)y0, (float)z0, (float)xf, (float)yf, (float)zf, (float)lineWidth);
        Point3D32[] vertices = lineMeshData.getVertices();
        TexCoord2f[] texturePoints = lineMeshData.getTexturePoints();
        Point3D32 start = new Point3D32(x0, y0, z0);
        Point3D32 end = new Point3D32(xf, yf, zf);
        for (int i = 0; i < vertices.length; ++i) {
            if (vertices[i].distanceSquared((Point3DReadOnly)start) < vertices[i].distanceSquared((Point3DReadOnly)end)) {
                texturePoints[i].set(this.colorPalette.getTextureLocation(startColor));
                continue;
            }
            texturePoints[i].set(this.colorPalette.getTextureLocation(endColor));
        }
        this.meshBuilder.addMesh(lineMeshData);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth, Color color) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), lineWidth, color);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, double lineWidth, Color startColor, Color endColor) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), lineWidth, startColor, endColor);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, float lineWidth, Color color) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), (double)lineWidth, color);
    }

    public void addLine(Tuple3DReadOnly start, Tuple3DReadOnly end, float lineWidth, Color startColor, Color endColor) {
        this.addLine(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), (double)lineWidth, startColor, endColor);
    }

    public void addMesh(MeshDataHolder meshDataHolder, Color color) {
        this.meshBuilder.addMesh(this.setColor(meshDataHolder, color));
    }

    public void addMesh(MeshDataHolder meshDataHolder, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, Color color) {
        this.meshBuilder.addMesh(this.setColor(meshDataHolder, color), offset, orientation);
    }

    public void addMesh(MeshDataHolder meshDataHolder, Tuple3DReadOnly offset, Color color) {
        this.meshBuilder.addMesh(this.setColor(meshDataHolder, color), offset);
    }

    public void addMultiLine(List<? extends Point3DReadOnly> points, double lineWidth, Color color, boolean close) {
        if (points.size() < 2) {
            return;
        }
        for (int i = 1; i < points.size(); ++i) {
            Point3DReadOnly start = points.get(i - 1);
            Point3DReadOnly end = points.get(i);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point3DReadOnly start = points.get(points.size() - 1);
            Point3DReadOnly end = points.get(0);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addMultiLine(Point3DReadOnly[] points, double lineWidth, Color color, boolean close) {
        if (points.length < 2) {
            return;
        }
        for (int i = 1; i < points.length; ++i) {
            Point3DReadOnly start = points[i - 1];
            Point3DReadOnly end = points[i];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point3DReadOnly start = points[points.length - 1];
            Point3DReadOnly end = points[0];
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addMultiLine(RigidBodyTransformReadOnly transformToWorld, List<? extends Point2DReadOnly> points, double lineWidth, Color color, boolean close) {
        if (points.size() < 2) {
            return;
        }
        Point3D start = new Point3D();
        Point3D end = new Point3D();
        for (int i = 1; i < points.size(); ++i) {
            Point2DReadOnly start2d = points.get(i - 1);
            Point2DReadOnly end2d = points.get(i);
            start.set(start2d.getX(), start2d.getY(), 0.0);
            end.set(end2d.getX(), end2d.getY(), 0.0);
            transformToWorld.transform((Point3DBasics)start);
            transformToWorld.transform((Point3DBasics)end);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
        if (close) {
            Point2DReadOnly start2d = points.get(points.size() - 1);
            Point2DReadOnly end2d = points.get(0);
            start.set(start2d.getX(), start2d.getY(), 0.0);
            end.set(end2d.getX(), end2d.getY(), 0.0);
            transformToWorld.transform((Point3DBasics)start);
            transformToWorld.transform((Point3DBasics)end);
            this.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color);
        }
    }

    public void addMultiLine(RigidBodyTransformReadOnly transformToWorld, Point2DReadOnly[] points, double lineWidth, Color color, boolean close) {
        this.addMultiLine(transformToWorld, Arrays.asList(points), lineWidth, color, close);
    }

    public void addPolygon(RigidBodyTransformReadOnly transformToWorld, ConvexPolygon2DReadOnly polygon, Color color) {
        this.addMesh(MeshDataGenerator.Polygon((RigidBodyTransformReadOnly)transformToWorld, (ConvexPolygon2DReadOnly)polygon), color);
    }

    @Deprecated
    public void addPolyon(List<Point3D> polygon, Color color) {
        this.addPolygon(polygon, color);
    }

    public void addPolygon(List<? extends Point3DReadOnly> polygon, Color color) {
        this.addMesh(MeshDataGenerator.Polygon(polygon), color);
    }

    public void addSphere(double radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Sphere((double)radius, (int)32, (int)32), offset, color);
    }

    public void addSphere(float radius, Color color) {
        this.addMesh(MeshDataGenerator.Sphere((float)radius, (int)32, (int)32), color);
    }

    public void addSphere(float radius, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Sphere((float)radius, (int)32, (int)32), offset, color);
    }

    public void addTetrahedron(double edgeLength, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Tetrahedron((double)edgeLength), offset, color);
    }

    public void addTetrahedron(float edgeLength, Tuple3DReadOnly offset, Color color) {
        this.addMesh(MeshDataGenerator.Tetrahedron((float)edgeLength), offset, color);
    }

    public void changeColorPalette(TextureColorPalette newColorPalette) {
        this.colorPalette = newColorPalette;
    }

    public void clear() {
        this.meshBuilder.clear();
    }

    public Material generateMaterial() {
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseMap(this.colorPalette.getColorPalette());
        return material;
    }

    public Mesh generateMesh() {
        return this.meshBuilder.generateMesh();
    }

    public MeshDataHolder generateMeshDataHolder() {
        return this.meshBuilder.generateMeshDataHolder();
    }

    private MeshDataHolder setColor(MeshDataHolder input, Color color) {
        if (input == null) {
            return null;
        }
        Point3D32[] vertices = input.getVertices();
        int[] triangleIndices = input.getTriangleIndices();
        Vector3D32[] vertexNormals = input.getVertexNormals();
        TexCoord2f[] inputTexturePoints = input.getTexturePoints();
        TexCoord2f[] outputTexturePoints = new TexCoord2f[inputTexturePoints.length];
        float[] textureLocation = this.colorPalette.getTextureLocation(color);
        for (int i = 0; i < inputTexturePoints.length; ++i) {
            outputTexturePoints[i] = new TexCoord2f(textureLocation);
        }
        return new MeshDataHolder(vertices, outputTexturePoints, triangleIndices, vertexNormals);
    }
}

