/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.scenes;

import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.cameraControllers.FocusBasedCameraMouseEventHandler;
import us.ihmc.javaFXToolkit.shapes.JavaFXCoordinateSystem;

public class View3DFactory {
    private final Group root = new Group();
    private final Scene scene;
    private final SubScene subScene;

    public View3DFactory(double width, double height) {
        this(width, height, true);
    }

    public View3DFactory(double width, double height, boolean depthBuffer) {
        this(width, height, depthBuffer, SceneAntialiasing.BALANCED, SceneType.MAIN_SCENE);
    }

    public View3DFactory(double width, double height, boolean depthBuffer, SceneAntialiasing antiAliasing, SceneType sceneType) {
        switch (sceneType) {
            case MAIN_SCENE: {
                this.scene = new Scene((Parent)this.root, width, height, depthBuffer, antiAliasing);
                this.scene.setFill((Paint)Color.GRAY);
                this.subScene = null;
                break;
            }
            case SUB_SCENE: {
                this.subScene = new SubScene((Parent)this.root, width, height, depthBuffer, antiAliasing);
                this.subScene.setFill((Paint)Color.GRAY);
                this.scene = null;
                break;
            }
            default: {
                throw new RuntimeException("Unknown sceneType: " + String.valueOf((Object)sceneType));
            }
        }
    }

    public static View3DFactory createSubscene() {
        return View3DFactory.createSubscene(true, SceneAntialiasing.BALANCED);
    }

    public static View3DFactory createSubscene(boolean depthBuffer, SceneAntialiasing antiAliasing) {
        return new View3DFactory(-1.0, -1.0, depthBuffer, antiAliasing, SceneType.SUB_SCENE);
    }

    public void addDefaultLighting() {
        double ambientValue = 0.7;
        double pointValue = 0.2;
        double pointDistance = 1000.0;
        Color ambientColor = Color.color((double)ambientValue, (double)ambientValue, (double)ambientValue);
        this.addNodeToView((Node)new AmbientLight(ambientColor));
        Color indoorColor = Color.color((double)pointValue, (double)pointValue, (double)pointValue);
        this.addPointLight(pointDistance, pointDistance, pointDistance, indoorColor);
        this.addPointLight(-pointDistance, pointDistance, pointDistance, indoorColor);
        this.addPointLight(-pointDistance, -pointDistance, pointDistance, indoorColor);
        this.addPointLight(pointDistance, -pointDistance, pointDistance, indoorColor);
    }

    public void addPointLight(double x, double y, double z) {
        this.addPointLight(x, y, z, Color.WHITE);
    }

    public void addPointLight(double x, double y, double z, Color color) {
        PointLight light = new PointLight(color);
        light.setTranslateX(x);
        light.setTranslateY(y);
        light.setTranslateZ(z);
        this.addNodeToView((Node)light);
    }

    public FocusBasedCameraMouseEventHandler addCameraController() {
        return this.addCameraController(0.05, 50.0, false);
    }

    public FocusBasedCameraMouseEventHandler addCameraController(boolean enableShiftClickFocusTranslation) {
        return this.addCameraController(0.05, 50.0, enableShiftClickFocusTranslation);
    }

    public FocusBasedCameraMouseEventHandler addCameraController(double nearClip, double farClip, boolean enableShiftClickFocusTranslation) {
        PerspectiveCamera camera = new PerspectiveCamera(true);
        camera.setNearClip(nearClip);
        camera.setFarClip(farClip);
        this.setCamera(camera);
        Vector3D up = new Vector3D(0.0, 0.0, 1.0);
        Vector3D forward = new Vector3D(1.0, 0.0, 0.0);
        ReadOnlyDoubleProperty widthProperty = this.widthProperty();
        ReadOnlyDoubleProperty heightProperty = this.heightProperty();
        FocusBasedCameraMouseEventHandler cameraController = new FocusBasedCameraMouseEventHandler(widthProperty, heightProperty, camera, (Vector3DReadOnly)up, (Vector3DReadOnly)forward);
        if (enableShiftClickFocusTranslation) {
            cameraController.enableShiftClickFocusTranslation();
        }
        this.addEventHandler(Event.ANY, cameraController);
        this.addNodeToView((Node)cameraController.getFocusPointViz());
        if (this.subScene != null) {
            this.subScene.setOnMouseClicked(event -> this.subScene.requestFocus());
        }
        return cameraController;
    }

    public <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        if (this.scene != null) {
            this.scene.addEventHandler(eventType, eventHandler);
        } else {
            this.subScene.addEventHandler(eventType, eventHandler);
        }
    }

    private void setCamera(PerspectiveCamera camera) {
        if (this.scene != null) {
            this.scene.setCamera((Camera)camera);
        } else {
            this.subScene.setCamera((Camera)camera);
        }
    }

    private ReadOnlyDoubleProperty widthProperty() {
        return this.scene != null ? this.scene.widthProperty() : this.subScene.widthProperty();
    }

    private ReadOnlyDoubleProperty heightProperty() {
        return this.scene != null ? this.scene.heightProperty() : this.subScene.heightProperty();
    }

    public void addWorldCoordinateSystem(double arrowLength) {
        JavaFXCoordinateSystem worldCoordinateSystem = new JavaFXCoordinateSystem(arrowLength);
        worldCoordinateSystem.setMouseTransparent(true);
        this.addNodeToView((Node)worldCoordinateSystem);
    }

    public void addNodesToView(Iterable<? extends Node> nodes) {
        nodes.forEach(this::addNodeToView);
    }

    public void addNodeToView(Node node) {
        this.root.getChildren().add((Object)node);
    }

    public void setRootMouseTransparent(boolean value) {
        this.root.setMouseTransparent(value);
    }

    public Group getRoot() {
        return this.root;
    }

    public Scene getScene() {
        return this.scene;
    }

    public SubScene getSubScene() {
        return this.subScene;
    }

    public Pane getSubSceneWrappedInsidePane() {
        Pane pane = new Pane(new Node[]{this.subScene});
        this.bindSubSceneSizeToPaneSize(pane);
        return pane;
    }

    public void attachSubSceneTo(Pane pane) {
        if (this.subScene == null) {
            return;
        }
        pane.getChildren().add((Object)this.subScene);
        this.bindSubSceneSizeToPaneSize(pane);
    }

    public void bindSubSceneSizeToPaneSize(Pane pane) {
        if (this.subScene == null) {
            return;
        }
        this.subScene.heightProperty().bind((ObservableValue)pane.heightProperty());
        this.subScene.widthProperty().bind((ObservableValue)pane.widthProperty());
    }

    public void setBackgroundColor(Color color) {
        if (this.scene != null) {
            this.scene.setFill((Paint)color);
        } else {
            this.subScene.setFill((Paint)color);
        }
    }

    public static enum SceneType {
        MAIN_SCENE,
        SUB_SCENE;

    }
}

