/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.graphing;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Optional;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.ParallelCamera;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.imageio.ImageIO;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.graphicsDescription.color.Gradient;
import us.ihmc.graphicsDescription.graphInterfaces.GraphIndicesHolder;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.graphing.JavaFXGraphColors;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryHolder;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;
import us.ihmc.yoVariables.buffer.interfaces.YoTimeBufferHolder;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class JavaFXHeatmapGraph {
    private final JFXPanel javaFXPanel;
    private Group rootGroup;
    private final GraphIndicesHolder graphIndicesHolder;
    private final YoBufferVariableEntryHolder dataEntryHolder;
    private final Point2D focusPoint;
    private final AffineTransform transformToCanvasSpace;
    private TObjectIntHashMap<Point2D> heatmap;
    private YoDouble x;
    private YoDouble y;
    private GraphicsContext graphicsContext;
    private Scene scene;
    private Optional<Point2D> adjustingViewRangeMax;
    private Optional<Point2D> adjustingViewRangeMin;
    private JavaFXGraphColors colors;
    private Canvas canvas;
    private ParallelCamera parallelCamera;
    private Point2D gridCenter;
    private Point2D plotPencil;
    private Point2D viewRange;
    private final java.awt.Color[] rainbow = Gradient.createRainbow((int)500);

    public JavaFXHeatmapGraph(YoRegistry registry, GraphIndicesHolder graphIndicesHolder, SelectedVariableHolder selectedVariableHolder, YoBufferVariableEntryHolder dataEntryHolder, YoTimeBufferHolder dataBuffer) {
        this.javaFXPanel = new JFXPanel();
        this.graphIndicesHolder = graphIndicesHolder;
        this.dataEntryHolder = dataEntryHolder;
        this.heatmap = new TObjectIntHashMap(dataBuffer.getTimeBuffer().length);
        this.adjustingViewRangeMax = Optional.empty();
        this.adjustingViewRangeMin = Optional.empty();
        this.focusPoint = new Point2D(1.0, 1.0);
        this.transformToCanvasSpace = new AffineTransform();
        this.transformToCanvasSpace.appendScale(50.0, 50.0, 1.0);
        this.gridCenter = new Point2D();
        this.plotPencil = new Point2D();
        this.viewRange = new Point2D();
        this.colors = JavaFXGraphColors.javaFXStyle();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JavaFXHeatmapGraph.this.rootGroup = new Group();
                JavaFXHeatmapGraph.this.canvas = new Canvas();
                JavaFXHeatmapGraph.this.graphicsContext = JavaFXHeatmapGraph.this.canvas.getGraphicsContext2D();
                JavaFXHeatmapGraph.this.rootGroup.getChildren().add((Object)JavaFXHeatmapGraph.this.canvas);
                JavaFXHeatmapGraph.this.scene = new Scene((Parent)JavaFXHeatmapGraph.this.rootGroup);
                JavaFXHeatmapGraph.this.javaFXPanel.setScene(JavaFXHeatmapGraph.this.scene);
                JavaFXHeatmapGraph.this.parallelCamera = new ParallelCamera();
                JavaFXHeatmapGraph.this.scene.setCamera((Camera)JavaFXHeatmapGraph.this.parallelCamera);
            }
        });
    }

    public void update() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JavaFXHeatmapGraph.this.canvas.setWidth((double)JavaFXHeatmapGraph.this.javaFXPanel.getWidth());
                JavaFXHeatmapGraph.this.canvas.setHeight((double)JavaFXHeatmapGraph.this.javaFXPanel.getHeight());
                JavaFXHeatmapGraph.this.transformToCanvasSpace.setTranslationX((double)JavaFXHeatmapGraph.this.javaFXPanel.getWidth() / 2.0 - JavaFXHeatmapGraph.this.focusPoint.getX() * JavaFXHeatmapGraph.this.transformToCanvasSpace.getLinearTransform().getScaleX());
                JavaFXHeatmapGraph.this.transformToCanvasSpace.setTranslationY((double)JavaFXHeatmapGraph.this.javaFXPanel.getHeight() / 2.0 - JavaFXHeatmapGraph.this.focusPoint.getY() * JavaFXHeatmapGraph.this.transformToCanvasSpace.getLinearTransform().getScaleY());
                JavaFXHeatmapGraph.this.graphicsContext.save();
                JavaFXHeatmapGraph.this.graphicsContext.setFill((Paint)JavaFXHeatmapGraph.this.colors.getBackgroundColor());
                JavaFXHeatmapGraph.this.graphicsContext.fillRect(0.0, 0.0, (double)JavaFXHeatmapGraph.this.javaFXPanel.getWidth(), (double)JavaFXHeatmapGraph.this.javaFXPanel.getHeight());
                JavaFXHeatmapGraph.this.graphicsContext.setStroke((Paint)JavaFXHeatmapGraph.this.colors.getGridAxisColor());
                JavaFXHeatmapGraph.this.gridCenter.set(0.0, 0.0);
                JavaFXHeatmapGraph.this.transformToCanvasSpace.transform((Point2DBasics)JavaFXHeatmapGraph.this.gridCenter);
                JavaFXHeatmapGraph.this.graphicsContext.strokeLine(0.0, JavaFXHeatmapGraph.this.gridCenter.getY(), (double)JavaFXHeatmapGraph.this.javaFXPanel.getWidth(), JavaFXHeatmapGraph.this.gridCenter.getY());
                JavaFXHeatmapGraph.this.graphicsContext.strokeLine(JavaFXHeatmapGraph.this.gridCenter.getX(), 0.0, JavaFXHeatmapGraph.this.gridCenter.getX(), (double)JavaFXHeatmapGraph.this.javaFXPanel.getHeight());
                JavaFXHeatmapGraph.this.plotXYHeatmap();
                JavaFXHeatmapGraph.this.drawGridLines();
                JavaFXHeatmapGraph.this.graphicsContext.setStroke((Paint)JavaFXHeatmapGraph.this.colors.getLabelColor());
                JavaFXHeatmapGraph.this.graphicsContext.strokeText(JavaFXHeatmapGraph.this.x.getName(), JavaFXHeatmapGraph.this.canvas.getWidth() / 2.0, JavaFXHeatmapGraph.this.canvas.getHeight() - 5.0);
                JavaFXHeatmapGraph.this.graphicsContext.rotate(-90.0);
                JavaFXHeatmapGraph.this.graphicsContext.strokeText(JavaFXHeatmapGraph.this.y.getName(), -JavaFXHeatmapGraph.this.canvas.getHeight() / 2.0, 10.0);
                JavaFXHeatmapGraph.this.graphicsContext.rotate(90.0);
                JavaFXHeatmapGraph.this.graphicsContext.restore();
            }
        });
    }

    private void drawGridLines() {
    }

    private double calculateGridSizePixels(double pixelsPerMeter) {
        double decimalPlace;
        double orderOfMagnitude;
        double nextOrderOfMagnitude;
        double medianGridWidthInPixels = Toolkit.getDefaultToolkit().getScreenResolution();
        double desiredMeters = medianGridWidthInPixels / pixelsPerMeter;
        double percentageToNextOrderOfMagnitude = desiredMeters / (nextOrderOfMagnitude = Math.pow(10.0, (orderOfMagnitude = Math.floor(decimalPlace = Math.log10(desiredMeters))) + 1.0));
        double remainder = percentageToNextOrderOfMagnitude % 0.5;
        double roundToNearestPoint5 = remainder >= 0.25 ? percentageToNextOrderOfMagnitude + (0.5 - remainder) : percentageToNextOrderOfMagnitude - remainder;
        double gridSizeMeters = roundToNearestPoint5 > 0.0 ? nextOrderOfMagnitude * roundToNearestPoint5 : Math.pow(10.0, orderOfMagnitude);
        double gridSizePixels = gridSizeMeters * pixelsPerMeter;
        return gridSizePixels;
    }

    private void plotXYHeatmap() {
        YoBufferVariableEntryReader xDataEntry = this.dataEntryHolder.getEntry((YoVariable)this.x);
        YoBufferVariableEntryReader yDataEntry = this.dataEntryHolder.getEntry((YoVariable)this.y);
        double discreteX = 0.09;
        double discreteY = 0.3;
        for (int i = this.graphIndicesHolder.getInPoint(); i < this.graphIndicesHolder.getIndex(); ++i) {
            double roundedX = MathTools.roundToPrecision((double)xDataEntry.getBuffer()[i], (double)discreteX);
            double roundedY = MathTools.roundToPrecision((double)yDataEntry.getBuffer()[i], (double)discreteY);
            this.plotPencil.set(roundedX, roundedY);
            this.heatmap.adjustOrPutValue((Object)this.plotPencil, 1, 1);
            int heat = this.heatmap.get((Object)this.plotPencil);
            this.adjustViewRange(this.plotPencil.getX(), this.plotPencil.getY());
            this.transformToCanvasSpace.transform((Point2DBasics)this.plotPencil);
            this.graphicsContext.setFill((Paint)this.getHeatColor(heat));
            this.fillRect(this.plotPencil.getX(), this.plotPencil.getY(), discreteX * this.transformToCanvasSpace.getLinearTransform().getScaleX(), discreteY * this.transformToCanvasSpace.getLinearTransform().getScaleY());
        }
        this.heatmap.clear();
    }

    private Color getHeatColor(int heat) {
        double maxHeat = 30.0;
        int heatIndex = (int)MathTools.roundToPrecision((double)MathTools.clamp((double)((double)heat / maxHeat * 500.0), (double)0.0, (double)499.0), (double)1.0);
        return JavaFXTools.awtToJfx(this.rainbow[heatIndex]);
    }

    private void fillRect(double x, double y, double width, double height) {
        double upperLeftX = x - width / 2.0;
        double upperLeftY = y + height / 2.0;
        this.graphicsContext.fillRect(upperLeftX, upperLeftY, width, height);
    }

    public void setXVariable(YoDouble x) {
        this.x = x;
    }

    public void setYVariable(YoDouble y) {
        this.y = y;
    }

    public Scene getScene() {
        return new Scene((Parent)this.rootGroup);
    }

    public JFXPanel getPanel() {
        return this.javaFXPanel;
    }

    private void setViewRange(double viewRangeXMeters, double viewRangeYMeters) {
        this.transformToCanvasSpace.getLinearTransform().setScale((double)this.javaFXPanel.getWidth() / viewRangeXMeters, (double)this.javaFXPanel.getHeight() / viewRangeYMeters, 1.0);
    }

    public BufferedImage snapshot() {
        WritableImage snapshot = this.scene.snapshot(null);
        BufferedImage fromFXImage = SwingFXUtils.fromFXImage((Image)snapshot, null);
        BufferedImage pngImage = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)fromFXImage, "png", byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] imageInByte = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            ByteArrayInputStream in = new ByteArrayInputStream(imageInByte);
            pngImage = ImageIO.read(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pngImage;
    }

    private void adjustViewRange(double xInMeters, double yInMeters) {
        this.viewRange.set(xInMeters, yInMeters);
        if (!this.adjustingViewRangeMax.isPresent()) {
            this.adjustingViewRangeMax = Optional.of(new Point2D(this.viewRange.getX() + 0.001, this.viewRange.getY() + 0.001));
            this.adjustingViewRangeMin = Optional.of(new Point2D(this.viewRange.getX() - 0.001, this.viewRange.getY() - 0.001));
            this.focusPoint.setX(xInMeters);
            this.focusPoint.setY(yInMeters);
            return;
        }
        if (xInMeters > this.adjustingViewRangeMax.get().getX()) {
            this.adjustingViewRangeMax.get().setX(xInMeters);
        }
        if (yInMeters > this.adjustingViewRangeMax.get().getY()) {
            this.adjustingViewRangeMax.get().setY(yInMeters);
        }
        if (xInMeters < this.adjustingViewRangeMin.get().getX()) {
            this.adjustingViewRangeMin.get().setX(xInMeters);
        }
        if (yInMeters < this.adjustingViewRangeMin.get().getY()) {
            this.adjustingViewRangeMin.get().setY(yInMeters);
        }
        this.focusPoint.setX(this.adjustingViewRangeMin.get().getX() + (this.adjustingViewRangeMax.get().getX() - this.adjustingViewRangeMin.get().getX()) / 2.0);
        this.focusPoint.setY(this.adjustingViewRangeMin.get().getY() + (this.adjustingViewRangeMax.get().getY() - this.adjustingViewRangeMin.get().getY()) / 2.0);
        this.setViewRange((this.adjustingViewRangeMax.get().getX() - this.adjustingViewRangeMin.get().getX()) * 1.1, (this.adjustingViewRangeMax.get().getY() - this.adjustingViewRangeMin.get().getY()) * 1.1);
    }
}

