/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.graphics;

import java.util.function.DoubleConsumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.shape.DrawMode;
import javafx.scene.transform.Scale;
import org.fxyz3d.shapes.primitives.Text3DMesh;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.javaFXToolkit.JavaFXGraphicTools;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JavaFXLabelGraphic {
    public static boolean TUNING_MODE = false;
    public static TunedDouble textMeshHeight = new TunedDouble(5.0E-4);
    public static TunedDouble textMeshScale = new TunedDouble(0.03);
    public static TunedDouble textOffsetX = new TunedDouble(0.06);
    public static TunedDouble textOffsetY = new TunedDouble(0.0);
    public static TunedDouble textOffsetYaw = new TunedDouble(4.71238898038469);
    public static TunedDouble textOffsetPitch = new TunedDouble(0.0);
    public static TunedDouble textOffsetRoll = new TunedDouble(Math.PI);
    private final Text3DMesh textMesh;
    private double currentHeight;
    private double currentScale;
    private Point3D currentPositionOffset;
    private YawPitchRoll currentOrientationOffset;
    private final FramePose3D pose = new FramePose3D();
    private final FramePose3D offestPose = new FramePose3D();

    public static void initializeYoVariables(YoRegistry registry) {
        if (TUNING_MODE) {
            JavaFXLabelGraphic.textMeshHeight.parameter = new DoubleParameter("textMeshHeight", registry, JavaFXLabelGraphic.textMeshHeight.primitive);
            JavaFXLabelGraphic.textMeshScale.parameter = new DoubleParameter("textMeshScale", registry, JavaFXLabelGraphic.textMeshScale.primitive);
            JavaFXLabelGraphic.textOffsetX.parameter = new DoubleParameter("textOffsetX", registry, JavaFXLabelGraphic.textOffsetX.primitive);
            JavaFXLabelGraphic.textOffsetY.parameter = new DoubleParameter("textOffsetY", registry, JavaFXLabelGraphic.textOffsetY.primitive);
            JavaFXLabelGraphic.textOffsetYaw.parameter = new DoubleParameter("textOffsetYaw", registry, JavaFXLabelGraphic.textOffsetYaw.primitive);
            JavaFXLabelGraphic.textOffsetPitch.parameter = new DoubleParameter("textOffsetPitch", registry, JavaFXLabelGraphic.textOffsetPitch.primitive);
            JavaFXLabelGraphic.textOffsetRoll.parameter = new DoubleParameter("textOffsetRoll", registry, JavaFXLabelGraphic.textOffsetRoll.primitive);
        }
    }

    public JavaFXLabelGraphic(String text) {
        this.textMesh = new Text3DMesh(text, textMeshHeight.getValue());
        this.textMesh.setTextureModeNone(Color.BLACK);
        this.textMesh.setDrawMode(DrawMode.FILL);
        this.currentScale = textMeshScale.getValue();
        this.currentPositionOffset = new Point3D(textOffsetX.getValue(), textOffsetY.getValue(), -textMeshHeight.getValue());
        this.currentOrientationOffset = new YawPitchRoll(textOffsetYaw.getValue(), textOffsetPitch.getValue(), textOffsetRoll.getValue());
        if (TUNING_MODE) {
            this.addParameterListener(JavaFXLabelGraphic.textMeshHeight.parameter, value -> {
                this.currentHeight = value;
                this.currentPositionOffset.setZ(-value);
            });
            this.addParameterListener(JavaFXLabelGraphic.textMeshScale.parameter, value -> {
                this.currentScale = value;
            });
            this.addParameterListener(JavaFXLabelGraphic.textOffsetX.parameter, value -> this.currentPositionOffset.setX(value));
            this.addParameterListener(JavaFXLabelGraphic.textOffsetY.parameter, value -> this.currentPositionOffset.setY(value));
            this.addParameterListener(JavaFXLabelGraphic.textOffsetYaw.parameter, value -> this.currentOrientationOffset.setYaw(value));
            this.addParameterListener(JavaFXLabelGraphic.textOffsetPitch.parameter, value -> this.currentOrientationOffset.setPitch(value));
            this.addParameterListener(JavaFXLabelGraphic.textOffsetRoll.parameter, value -> this.currentOrientationOffset.setRoll(value));
        }
        this.update();
    }

    public FramePose3DBasics getPose() {
        return this.pose;
    }

    public void update() {
        this.offestPose.set(this.pose);
        this.offestPose.appendRotation((Orientation3DReadOnly)this.currentOrientationOffset);
        this.offestPose.appendTranslation((Tuple3DReadOnly)this.currentPositionOffset);
        JavaFXGraphicTools.setNodeTransformFromPose((Node)this.textMesh, (Pose3DReadOnly)this.offestPose, this.currentScale);
        this.textMesh.getTransforms().add((Object)new Scale(textMeshScale.getValue(), this.currentScale));
        this.textMesh.setHeight(this.currentHeight);
        this.textMesh.setTextureModeNone(Color.BLACK);
    }

    public Node getNode() {
        return this.textMesh;
    }

    private void addParameterListener(DoubleParameter parameter, DoubleConsumer runnable) {
        parameter.addListener(changedParameter -> {
            double value = ((DoubleParameter)changedParameter).getValue();
            Platform.runLater(() -> {
                runnable.accept(value);
                this.update();
            });
        });
    }

    private static class TunedDouble {
        final double primitive;
        DoubleParameter parameter;

        public TunedDouble(double initialValue) {
            this.primitive = initialValue;
        }

        double getValue() {
            return TUNING_MODE ? this.parameter.getValue() : this.primitive;
        }
    }
}

