/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.cameraControllers;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

public class CameraNodeTracker {
    private final ObjectProperty<Node> nodeTracked = new SimpleObjectProperty((Object)this, "nodeTracked", null);
    private final Translate nodeTrackingTranslate = new Translate();
    private final ChangeListener<Transform> nodeTrackingListener = (o, oldTransform, newTransform) -> {
        this.nodeTrackingTranslate.setX(newTransform.getTx());
        this.nodeTrackingTranslate.setY(newTransform.getTy());
        this.nodeTrackingTranslate.setZ(newTransform.getTz());
    };

    public CameraNodeTracker(Translate cameraFocusTranslate) {
        this.nodeTracked.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.localToSceneTransformProperty().removeListener(this.nodeTrackingListener);
            }
            if (newValue != null) {
                cameraFocusTranslate.setX(0.0);
                cameraFocusTranslate.setY(0.0);
                cameraFocusTranslate.setZ(0.0);
                newValue.localToSceneTransformProperty().addListener(this.nodeTrackingListener);
                this.nodeTrackingListener.changed(null, null, (Object)newValue.getLocalToSceneTransform());
            }
        });
    }

    public ObjectProperty<Node> nodeToTrackProperty() {
        return this.nodeTracked;
    }

    public Node getNodeToTrack() {
        return (Node)this.nodeTracked.get();
    }

    public void setNodeToTrack(Node nodeToTrack) {
        this.nodeTracked.set((Object)nodeToTrack);
    }

    public void resetTranslate() {
        this.nodeTrackingTranslate.setX(0.0);
        this.nodeTrackingTranslate.setY(0.0);
        this.nodeTrackingTranslate.setZ(0.0);
    }

    public Translate getNodeTrackingTranslate() {
        return this.nodeTrackingTranslate;
    }
}

