/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.applicationCreator;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;

public class JavaFXApplicationCreator
extends Application {
    private static JavaFXApplicationCreator createdJavaFXApplicationSingleton;
    private static final CountDownLatch latch;
    private static JavaFXApplicationCreator startUpTest;
    private static ArrayList<Runnable> stopListeners;

    public JavaFXApplicationCreator() {
        this.setStartUpTest(this);
    }

    private void setStartUpTest(JavaFXApplicationCreator startUpTest0) {
        startUpTest = startUpTest0;
        latch.countDown();
    }

    private static JavaFXApplicationCreator waitForStartUpTest() {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return startUpTest;
    }

    public static void attachStopListener(Runnable stopListener) {
        stopListeners.add(stopListener);
    }

    public void start(Stage primaryStage) throws Exception {
    }

    public void stop() throws Exception {
        for (Runnable stopListener : stopListeners) {
            stopListener.run();
        }
    }

    public static void keepJavaFXAliveEvenAfterAllWindowsAreClosed() {
        Platform.setImplicitExit((boolean)false);
    }

    public static void buildJavaFXApplication(Runnable builder) {
        JavaFXApplicationCreator.createAJavaFXApplication();
        Platform.runLater((Runnable)builder);
    }

    public static void buildJavaFXApplication(Consumer<Stage> builder) {
        JavaFXApplicationCreator.createAJavaFXApplication();
        Platform.runLater(() -> {
            Stage primaryStage = new Stage();
            builder.accept(primaryStage);
        });
    }

    public static JavaFXApplicationCreator createAJavaFXApplication() {
        if (createdJavaFXApplicationSingleton != null) {
            return createdJavaFXApplicationSingleton;
        }
        new Thread(() -> Application.launch(JavaFXApplicationCreator.class, (String[])new String[0])).start();
        createdJavaFXApplicationSingleton = JavaFXApplicationCreator.waitForStartUpTest();
        return createdJavaFXApplicationSingleton;
    }

    static {
        latch = new CountDownLatch(1);
        startUpTest = null;
        stopListeners = new ArrayList();
    }
}

