/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Box3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;

public class JavaFXGraphicTools {
    public static void setNodeTransformFromPose(Node node, Pose3DReadOnly pose) {
        JavaFXGraphicTools.setNodeTransformFromPose(node, pose, 1.0);
    }

    public static void setNodeTransformFromPose(Node node, Pose3DReadOnly pose, double scale) {
        node.getTransforms().clear();
        RigidBodyTransform rigidBodyTransform = new RigidBodyTransform();
        rigidBodyTransform.set((Orientation3DReadOnly)pose.getOrientation(), (Tuple3DReadOnly)pose.getPosition());
        Affine affine = JavaFXTools.createRigidBodyTransformToAffine(rigidBodyTransform);
        if (scale != 1.0) {
            affine.appendScale(scale, scale);
        }
        node.getTransforms().add((Object)affine);
    }

    public static void setNodePosition(Node node, Tuple3DReadOnly position) {
        node.setTranslateX(position.getX());
        node.setTranslateY(position.getY());
        node.setTranslateZ(position.getZ());
    }

    public static void drawPlanarRegion(JavaFXMeshBuilder meshBuilder, RigidBodyTransformReadOnly transformToWorld, List<? extends Point2DReadOnly> concaveHull, List<? extends ConvexPolygon2DReadOnly> convexPolygons, double lineWidth) {
        meshBuilder.addMultiLine(transformToWorld, concaveHull, lineWidth, true);
        for (ConvexPolygon2DReadOnly convexPolygon2DReadOnly : convexPolygons) {
            meshBuilder.addPolygon(transformToWorld, convexPolygon2DReadOnly);
        }
    }

    public static void drawArrow(JavaFXMeshBuilder meshBuilder, Tuple3DReadOnly position, Orientation3DReadOnly orientation, double length, double radius, double cylinderToConeLengthRatio, double coneDiameterMultiplier) {
        double cylinderLength = cylinderToConeLengthRatio * length;
        double coneLength = (1.0 - cylinderToConeLengthRatio) * length;
        double coneRadius = coneDiameterMultiplier * radius;
        AxisAngle axisAngle = new AxisAngle(orientation);
        meshBuilder.addCylinder(cylinderLength, radius, position, (Orientation3DReadOnly)axisAngle);
        Vector3D coneBaseTranslation = new Vector3D(0.0, 0.0, 1.0);
        orientation.transform((Tuple3DBasics)coneBaseTranslation);
        coneBaseTranslation.scale(length);
        coneBaseTranslation.scale(cylinderToConeLengthRatio);
        Point3D coneBase = new Point3D(position);
        coneBase.add((Tuple3DReadOnly)coneBaseTranslation);
        meshBuilder.addCone(coneLength, coneRadius, (Tuple3DReadOnly)coneBase, (Orientation3DReadOnly)axisAngle);
    }

    public static void drawBoxEdges(JavaFXMeshBuilder meshBuilder, BoundingBox3DReadOnly boundingBox, double lineWidth) {
        JavaFXGraphicTools.drawBoxEdges(meshBuilder, (Box3DReadOnly)JavaFXGraphicTools.convertBoundingBox3DToBox3D(boundingBox), lineWidth);
    }

    public static Box3D convertBoundingBox3DToBox3D(BoundingBox3DReadOnly boundingBox) {
        Point3DReadOnly minPoint = boundingBox.getMinPoint();
        Point3DReadOnly maxPoint = boundingBox.getMaxPoint();
        Point3D boxCenter = new Point3D();
        boxCenter.interpolate((Tuple3DReadOnly)minPoint, (Tuple3DReadOnly)maxPoint, 0.5);
        Vector3D size = new Vector3D();
        size.sub((Tuple3DReadOnly)maxPoint, (Tuple3DReadOnly)minPoint);
        return new Box3D((Point3DReadOnly)boxCenter, (Orientation3DReadOnly)new Quaternion(), size.getX(), size.getY(), size.getZ());
    }

    public static void drawBoxEdges(JavaFXMeshBuilder meshBuilder, Box3DReadOnly box, double lineWidth) {
        ArrayList<Point3DBasics> orderedVertices = new ArrayList<Point3DBasics>();
        orderedVertices.add(box.getVertex(0));
        orderedVertices.add(box.getVertex(1));
        orderedVertices.add(box.getVertex(3));
        orderedVertices.add(box.getVertex(2));
        orderedVertices.add(box.getVertex(0));
        orderedVertices.add(box.getVertex(4));
        orderedVertices.add(box.getVertex(5));
        orderedVertices.add(box.getVertex(1));
        orderedVertices.add(box.getVertex(5));
        orderedVertices.add(box.getVertex(7));
        orderedVertices.add(box.getVertex(3));
        orderedVertices.add(box.getVertex(7));
        orderedVertices.add(box.getVertex(6));
        orderedVertices.add(box.getVertex(2));
        orderedVertices.add(box.getVertex(6));
        orderedVertices.add(box.getVertex(4));
        meshBuilder.addMultiLine(orderedVertices, lineWidth, false);
    }
}

