/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.node;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.MatrixType;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.instructions.ArcTorusGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CapsuleGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.CylinderGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.EllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.ExtrudedPolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddExtrusionInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddHeightMapInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddModelFileInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstructionExecutor;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.graphicsDescription.instructions.HemiEllipsoidGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PolygonGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PrimitiveGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.PyramidCubeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.SphereGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.TruncatedConeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.WedgeGraphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DRotateInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DScaleInstruction;
import us.ihmc.graphicsDescription.instructions.primitives.Graphics3DTranslateInstruction;
import us.ihmc.javaFXToolkit.graphics.JAssImpJavaFXTools;
import us.ihmc.javaFXToolkit.graphics.JavaFXMeshDataInterpreter;

public class JavaFXGraphicsObject
extends Graphics3DInstructionExecutor {
    private final Group parentGroup;
    private Group currentGroup;

    public JavaFXGraphicsObject(Graphics3DObject graphics3dObject) {
        this(graphics3dObject, null);
    }

    public JavaFXGraphicsObject(Graphics3DObject graphics3dObject, AppearanceDefinition appearance) {
        List graphics3dInstructions;
        this.currentGroup = this.parentGroup = new Group();
        if (graphics3dObject != null && (graphics3dInstructions = graphics3dObject.getGraphics3DInstructions()) != null) {
            for (Graphics3DPrimitiveInstruction instruction : graphics3dInstructions) {
                if (!(instruction instanceof Graphics3DInstruction)) continue;
                Graphics3DInstruction graphicsInstruction = (Graphics3DInstruction)instruction;
                if (appearance == null) continue;
                graphicsInstruction.setAppearance(appearance);
            }
            this.setUpGraphicsFromDefinition(graphics3dInstructions);
        }
    }

    protected void doAddMeshDataInstruction(Graphics3DAddMeshDataInstruction graphics3DAddMeshData) {
        graphics3DAddMeshData.getMeshData().getVertices();
        TriangleMesh outputMesh = JavaFXGraphicsObject.interpretMeshData(graphics3DAddMeshData.getMeshData());
        Material outputMaterial = JavaFXGraphicsObject.convertMaterial(graphics3DAddMeshData.getAppearance());
        MeshView meshView = new MeshView();
        meshView.setMesh((Mesh)outputMesh);
        meshView.setMaterial(outputMaterial);
        Group meshGroup = new Group(new Node[]{meshView});
        this.currentGroup.getChildren().add((Object)meshGroup);
        this.currentGroup = meshGroup;
    }

    protected void doAddHeightMapInstruction(Graphics3DAddHeightMapInstruction graphics3DAddHeightMap) {
    }

    protected void doAddExtrusionInstruction(Graphics3DAddExtrusionInstruction graphics3DAddText) {
    }

    protected void doAddModelFileInstruction(Graphics3DAddModelFileInstruction graphics3DAddModelFile) {
        MeshView[] outputModelMeshes = new MeshView[]{};
        try {
            outputModelMeshes = JAssImpJavaFXTools.getJavaFxMeshes(graphics3DAddModelFile.getFileName(), graphics3DAddModelFile.getResourceClassLoader());
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        if (graphics3DAddModelFile.getAppearance() != null) {
            Material outputMaterial = JavaFXGraphicsObject.convertMaterial(graphics3DAddModelFile.getAppearance());
            for (int i = 0; i < outputModelMeshes.length; ++i) {
                outputModelMeshes[i].setMaterial(outputMaterial);
            }
        }
        Group meshGroup = new Group((Node[])outputModelMeshes);
        this.currentGroup.getChildren().add((Object)meshGroup);
        this.currentGroup = meshGroup;
    }

    protected void doIdentityInstruction() {
        this.currentGroup = this.parentGroup;
    }

    protected void doRotateInstruction(Graphics3DRotateInstruction rot) {
        RotationMatrixReadOnly mat = rot.getRotationMatrix();
        Affine outputRotation = new Affine(new double[]{mat.getM00(), mat.getM01(), mat.getM02(), 0.0, mat.getM10(), mat.getM11(), mat.getM12(), 0.0, mat.getM20(), mat.getM21(), mat.getM22(), 0.0, 0.0, 0.0, 0.0, 1.0}, MatrixType.MT_3D_4x4, 0);
        Group rotationGroup = new Group();
        rotationGroup.getTransforms().add((Object)outputRotation);
        this.currentGroup.getChildren().add((Object)rotationGroup);
        this.currentGroup = rotationGroup;
    }

    protected void doScaleInstruction(Graphics3DScaleInstruction graphics3DScale) {
        Vector3D scale = graphics3DScale.getScaleFactor();
        Scale outputScale = new Scale(scale.getX(), scale.getY(), scale.getZ());
        Group scaleGroup = new Group();
        scaleGroup.getTransforms().add((Object)outputScale);
        this.currentGroup.getChildren().add((Object)scaleGroup);
        this.currentGroup = scaleGroup;
    }

    protected void doTranslateInstruction(Graphics3DTranslateInstruction graphics3DTranslate) {
        Vector3D t = graphics3DTranslate.getTranslation();
        Translate outputTranslation = new Translate(t.getX(), t.getY(), t.getZ());
        Group translationGroup = new Group();
        translationGroup.getTransforms().add((Object)outputTranslation);
        this.currentGroup.getChildren().add((Object)translationGroup);
        this.currentGroup = translationGroup;
    }

    public Group getGroup() {
        return this.parentGroup;
    }

    private static Material convertMaterial(AppearanceDefinition appearance) {
        float r = appearance.getColor().getX();
        float g = appearance.getColor().getY();
        float b = appearance.getColor().getZ();
        double transparency = appearance.getTransparency();
        if (appearance instanceof YoAppearanceRGBColor) {
            transparency = 1.0 - transparency;
        }
        Color color = new Color((double)r, (double)g, (double)b, transparency);
        PhongMaterial res = new PhongMaterial(color);
        res.setSpecularColor(Color.WHITE);
        return res;
    }

    private static TriangleMesh interpretMeshData(MeshDataHolder meshData) {
        return JavaFXMeshDataInterpreter.interpretMeshData(meshData);
    }

    protected void doAddPrimitiveInstruction(PrimitiveGraphics3DInstruction primitiveInstruction) {
        if (primitiveInstruction instanceof CubeGraphics3DInstruction) {
            CubeGraphics3DInstruction cubeInstruction = (CubeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cube((double)cubeInstruction.getLength(), (double)cubeInstruction.getWidth(), (double)cubeInstruction.getHeight(), (boolean)cubeInstruction.getCenteredInTheCenter(), (boolean[])cubeInstruction.getTextureFaces());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)cubeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof SphereGraphics3DInstruction) {
            SphereGraphics3DInstruction sphereInstruction = (SphereGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Sphere((double)sphereInstruction.getRadius(), (int)sphereInstruction.getResolution(), (int)sphereInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)sphereInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof WedgeGraphics3DInstruction) {
            WedgeGraphics3DInstruction wedgeInstruction = (WedgeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Wedge((double)wedgeInstruction.getLengthX(), (double)wedgeInstruction.getWidthY(), (double)wedgeInstruction.getHeightZ());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)wedgeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof CapsuleGraphics3DInstruction) {
            CapsuleGraphics3DInstruction capsuleInstruction = (CapsuleGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Capsule((double)capsuleInstruction.getHeight(), (double)capsuleInstruction.getXRadius(), (double)capsuleInstruction.getYRadius(), (double)capsuleInstruction.getZRadius(), (int)capsuleInstruction.getResolution(), (int)capsuleInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)capsuleInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof EllipsoidGraphics3DInstruction) {
            EllipsoidGraphics3DInstruction ellipsoidInstruction = (EllipsoidGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Ellipsoid((double)ellipsoidInstruction.getXRadius(), (double)ellipsoidInstruction.getYRadius(), (double)ellipsoidInstruction.getZRadius(), (int)ellipsoidInstruction.getResolution(), (int)ellipsoidInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)ellipsoidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof CylinderGraphics3DInstruction) {
            CylinderGraphics3DInstruction cylinderInstruction = (CylinderGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cylinder((double)cylinderInstruction.getRadius(), (double)cylinderInstruction.getHeight(), (int)cylinderInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)cylinderInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ConeGraphics3DInstruction) {
            ConeGraphics3DInstruction coneInstruction = (ConeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Cone((double)coneInstruction.getHeight(), (double)coneInstruction.getRadius(), (int)coneInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)coneInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof TruncatedConeGraphics3DInstruction) {
            TruncatedConeGraphics3DInstruction truncatedConeInstruction = (TruncatedConeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.GenTruncatedCone((double)truncatedConeInstruction.getHeight(), (double)truncatedConeInstruction.getXBaseRadius(), (double)truncatedConeInstruction.getYBaseRadius(), (double)truncatedConeInstruction.getXTopRadius(), (double)truncatedConeInstruction.getYTopRadius(), (int)truncatedConeInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)truncatedConeInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof HemiEllipsoidGraphics3DInstruction) {
            HemiEllipsoidGraphics3DInstruction hemiEllipsoidInstruction = (HemiEllipsoidGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.HemiEllipsoid((double)hemiEllipsoidInstruction.getXRadius(), (double)hemiEllipsoidInstruction.getYRadius(), (double)hemiEllipsoidInstruction.getZRadius(), (int)hemiEllipsoidInstruction.getResolution(), (int)hemiEllipsoidInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)hemiEllipsoidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ArcTorusGraphics3DInstruction) {
            ArcTorusGraphics3DInstruction arcTorusInstruction = (ArcTorusGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.ArcTorus((double)arcTorusInstruction.getStartAngle(), (double)arcTorusInstruction.getEndAngle(), (double)arcTorusInstruction.getMajorRadius(), (double)arcTorusInstruction.getMinorRadius(), (int)arcTorusInstruction.getResolution());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)arcTorusInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof PyramidCubeGraphics3DInstruction) {
            PyramidCubeGraphics3DInstruction pyramidInstruction = (PyramidCubeGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.PyramidCube((double)pyramidInstruction.getLengthX(), (double)pyramidInstruction.getWidthY(), (double)pyramidInstruction.getHeightZ(), (double)pyramidInstruction.getPyramidHeight());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)pyramidInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof PolygonGraphics3DInstruction) {
            PolygonGraphics3DInstruction polygonInstruction = (PolygonGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.Polygon((List)polygonInstruction.getPolygonPoints());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)polygonInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else if (primitiveInstruction instanceof ExtrudedPolygonGraphics3DInstruction) {
            ExtrudedPolygonGraphics3DInstruction extrudedPolygonInstruction = (ExtrudedPolygonGraphics3DInstruction)primitiveInstruction;
            MeshDataHolder meshData = MeshDataGenerator.ExtrudedPolygon((List)extrudedPolygonInstruction.getPolygonPoints(), (double)extrudedPolygonInstruction.getExtrusionHeight());
            Graphics3DAddMeshDataInstruction meshDataInstruction = Graphics3DObject.createMeshDataInstruction((MeshDataHolder)meshData, (AppearanceDefinition)extrudedPolygonInstruction.getAppearance());
            this.doAddMeshDataInstruction(meshDataInstruction);
        } else {
            throw new RuntimeException("Need to support that primitive type! primitiveInstruction = " + primitiveInstruction);
        }
    }
}

