/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.graphing;

import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.SceneAntialiasing;
import javafx.scene.paint.Color;
import javafx.scene.shape.Box;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.graphInterfaces.GraphIndicesHolder;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.text.Text3D;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryHolder;
import us.ihmc.yoVariables.buffer.interfaces.YoTimeBufferHolder;

public class JavaFX3DGraph {
    private final JFXPanel javaFXPanel = new JFXPanel();
    private final GraphIndicesHolder graphIndicesHolder;
    private final SelectedVariableHolder selectedVariableHolder;
    private final YoBufferVariableEntryHolder dataEntryHolder;
    private final YoTimeBufferHolder timeDataHolder;

    public JavaFX3DGraph(GraphIndicesHolder graphIndicesHolder, SelectedVariableHolder selectedVariableHolder, YoBufferVariableEntryHolder dataEntryHolder, YoTimeBufferHolder timeDataHolder) {
        this.graphIndicesHolder = graphIndicesHolder;
        this.selectedVariableHolder = selectedVariableHolder;
        this.dataEntryHolder = dataEntryHolder;
        this.timeDataHolder = timeDataHolder;
        View3DFactory view3dFactory = new View3DFactory(-1.0, -1.0, true, SceneAntialiasing.BALANCED, View3DFactory.SceneType.MAIN_SCENE);
        view3dFactory.addCameraController(0.0, 1.0E7, false);
        view3dFactory.setBackgroundColor(Color.LIGHTGRAY);
        double infinity = 10000.0;
        double lineWidth = 0.005;
        Box box = new Box(lineWidth, lineWidth, infinity);
        view3dFactory.addNodeToView((Node)box);
        double fontHeight = 0.1;
        double fontThickness = lineWidth;
        Text3D xLabel = new Text3D("X");
        xLabel.setFontThickness(fontThickness);
        xLabel.setFontHeight(fontHeight);
        xLabel.setFontColor(Color.BLACK);
        xLabel.setOrientation(new AxisAngle(1.0, -1.0, 0.0, 180.0));
        xLabel.setPosition((Point3DReadOnly)new Point3D(1.0, -fontHeight / 2.0, 0.0));
        view3dFactory.addNodeToView(xLabel.getNode());
        Text3D yLabel = new Text3D("Y");
        yLabel.setFontThickness(fontThickness);
        yLabel.setFontHeight(fontHeight);
        yLabel.setFontColor(Color.BLACK);
        yLabel.setOrientation(new AxisAngle(1.0, 0.0, 0.0, 180.0));
        yLabel.setPosition((Point3DReadOnly)new Point3D(fontHeight / 2.0, 1.0, 0.0));
        view3dFactory.addNodeToView(yLabel.getNode());
        Text3D zLabel = new Text3D("Z");
        zLabel.setFontThickness(fontThickness);
        zLabel.setFontHeight(fontHeight);
        zLabel.setFontColor(Color.BLACK);
        zLabel.setOrientation(new AxisAngle(1.0, 0.0, 0.0, -90.0));
        zLabel.setPosition((Point3DReadOnly)new Point3D(fontHeight / 2.0, 0.0, 1.0));
        view3dFactory.addNodeToView(zLabel.getNode());
        this.javaFXPanel.setScene(view3dFactory.getScene());
    }

    public JFXPanel getPanel() {
        return this.javaFXPanel;
    }
}

