/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.graphics;

import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.Array;
import java.util.HashMap;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.shape.VertexFormat;
import org.apache.commons.lang3.tuple.Pair;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.log.LogTools;

public class JavaFXMeshDataInterpreter {
    public static TriangleMesh interpretMeshData(MeshDataHolder meshData) {
        return JavaFXMeshDataInterpreter.interpretMeshData(meshData, true);
    }

    public static TriangleMesh interpretMeshData(MeshDataHolder meshData, boolean optimizeMesh) {
        if (meshData == null || meshData.getTriangleIndices().length == 0) {
            return null;
        }
        Point3D32[] vertices = meshData.getVertices();
        TexCoord2f[] texturePoints = meshData.getTexturePoints();
        int[] triangleIndices = meshData.getTriangleIndices();
        Vector3D32[] normals = meshData.getVertexNormals();
        TIntArrayList facesIndices = new TIntArrayList();
        if (optimizeMesh) {
            Pair<int[], Point3D32[]> filterDuplicateVertices = JavaFXMeshDataInterpreter.filterDuplicates(triangleIndices, vertices);
            Pair<int[], Vector3D32[]> filterDuplicateNormals = JavaFXMeshDataInterpreter.filterDuplicates(triangleIndices, normals);
            Pair<int[], TexCoord2f[]> filterDuplicateTex = JavaFXMeshDataInterpreter.filterDuplicates(triangleIndices, texturePoints);
            vertices = (Point3D32[])filterDuplicateVertices.getRight();
            normals = (Vector3D32[])filterDuplicateNormals.getRight();
            texturePoints = (TexCoord2f[])filterDuplicateTex.getRight();
            for (int pos = 0; pos < triangleIndices.length; ++pos) {
                facesIndices.add(((int[])filterDuplicateVertices.getLeft())[pos]);
                facesIndices.add(((int[])filterDuplicateNormals.getLeft())[pos]);
                facesIndices.add(((int[])filterDuplicateTex.getLeft())[pos]);
            }
        } else {
            for (int pos = 0; pos < triangleIndices.length; ++pos) {
                facesIndices.add(triangleIndices[pos]);
                facesIndices.add(triangleIndices[pos]);
                facesIndices.add(triangleIndices[pos]);
            }
        }
        int[] indices = facesIndices.toArray();
        TriangleMesh triangleMesh = new TriangleMesh(VertexFormat.POINT_NORMAL_TEXCOORD);
        triangleMesh.getPoints().addAll(JavaFXMeshDataInterpreter.convertToFloatArray((Tuple3DBasics[])vertices));
        triangleMesh.getTexCoords().addAll(JavaFXMeshDataInterpreter.convertToFloatArray((Tuple2DBasics[])texturePoints));
        triangleMesh.getFaces().addAll(indices);
        triangleMesh.getFaceSmoothingGroups().addAll(new int[indices.length / triangleMesh.getFaceElementSize()]);
        triangleMesh.getNormals().addAll(JavaFXMeshDataInterpreter.convertToFloatArray((Tuple3DBasics[])normals));
        return triangleMesh;
    }

    private static <T> Pair<int[], T[]> filterDuplicates(int[] originalIndices, T[] valuesWithDuplicates) {
        HashMap<Object, Integer> uniqueValueIndices = new HashMap<Object, Integer>();
        for (int valueIndex = valuesWithDuplicates.length - 1; valueIndex >= 0; --valueIndex) {
            uniqueValueIndices.put(valuesWithDuplicates[valueIndex], valueIndex);
        }
        Object[] filteredValue = (Object[])Array.newInstance(valuesWithDuplicates[0].getClass(), uniqueValueIndices.size());
        int pos = 0;
        for (Object value : uniqueValueIndices.keySet()) {
            uniqueValueIndices.put(value, pos);
            filteredValue[pos] = value;
            ++pos;
        }
        int[] filteredIndices = new int[originalIndices.length];
        pos = 0;
        for (int triangleIndex : originalIndices) {
            filteredIndices[pos++] = (Integer)uniqueValueIndices.get(valuesWithDuplicates[triangleIndex]);
        }
        return Pair.of((Object)filteredIndices, (Object)filteredValue);
    }

    private static float[] convertToFloatArray(Tuple3DBasics[] tuple3fs) {
        float[] array = new float[3 * tuple3fs.length];
        int index = 0;
        for (Tuple3DBasics tuple : tuple3fs) {
            if (tuple == null) {
                LogTools.error((String)"Got Null, Something is funny here");
                array[index++] = Float.NaN;
                array[index++] = Float.NaN;
                array[index++] = Float.NaN;
                continue;
            }
            array[index++] = tuple.getX32();
            array[index++] = tuple.getY32();
            array[index++] = tuple.getZ32();
        }
        return array;
    }

    private static float[] convertToFloatArray(Tuple2DBasics[] tuple2fs) {
        float[] array = new float[2 * tuple2fs.length];
        int index = 0;
        for (Tuple2DBasics tuple : tuple2fs) {
            if (tuple == null) {
                LogTools.error((String)"Got Null, Something is funny here");
                array[index++] = Float.NaN;
                array[index++] = Float.NaN;
                continue;
            }
            array[index++] = tuple.getX32();
            array[index++] = tuple.getY32();
        }
        return array;
    }
}

