/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.cameraControllers;

import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;

public class CameraRotationCalculator {
    private final Affine rotation = new Affine();
    private final Affine offset = new Affine();
    private final DoubleProperty latitude = new SimpleDoubleProperty((Object)this, "latitude", 0.0);
    private final DoubleProperty longitude = new SimpleDoubleProperty((Object)this, "longitude", 0.0);
    private final DoubleProperty roll = new SimpleDoubleProperty((Object)this, "roll", 0.0);
    private final BooleanProperty keepRotationLeveled = new SimpleBooleanProperty((Object)this, "keepRotationLeveled", true);
    private final ObjectProperty<Predicate<MouseEvent>> fastModifierPredicate = new SimpleObjectProperty((Object)this, "fastModifierPredicate", null);
    private final DoubleProperty slowModifier = new SimpleDoubleProperty((Object)this, "slowModifier", 0.005);
    private final DoubleProperty fastModifier = new SimpleDoubleProperty((Object)this, "fastModifier", 0.01);
    private final DoubleProperty rollModifier = new SimpleDoubleProperty((Object)this, "rollModifier", 0.005);
    private final ObjectProperty<MouseButton> rotationMouseButton = new SimpleObjectProperty((Object)this, "rotationMouseButton", (Object)MouseButton.PRIMARY);
    private final BooleanProperty restrictLatitude = new SimpleBooleanProperty((Object)this, "restrictLatitude", true);
    private final DoubleProperty minLatitude = new SimpleDoubleProperty((Object)this, "minLatitude", -1.3707963267948966);
    private final DoubleProperty maxLatitude = new SimpleDoubleProperty((Object)this, "maxLatitude", 1.3707963267948966);
    private final Vector3D up = new Vector3D();
    private final Vector3D down = new Vector3D();
    private final Vector3D forward = new Vector3D();
    private boolean disableAffineAutoUpdate = false;

    public CameraRotationCalculator(Vector3DReadOnly up, Vector3DReadOnly forward) {
        Vector3D left = new Vector3D();
        left.cross((Tuple3DReadOnly)up, (Tuple3DReadOnly)forward);
        if (!MathTools.epsilonEquals((double)left.length(), (double)1.0, (double)1.0E-5)) {
            throw new RuntimeException("The vectors up and forward must be orthogonal. Received: up = " + up + ", forward = " + forward);
        }
        this.up.set((Tuple3DReadOnly)up);
        this.forward.set((Tuple3DReadOnly)forward);
        this.down.setAndNegate((Tuple3DReadOnly)up);
        this.computeOffset();
        ChangeListener listener = (o, oldValue, newValue) -> {
            if (!this.disableAffineAutoUpdate) {
                this.updateRotation();
            }
        };
        this.latitude.addListener(listener);
        this.longitude.addListener(listener);
        this.roll.addListener(listener);
    }

    private void computeOffset() {
        Vector3D cameraZAxis = new Vector3D((Tuple3DReadOnly)this.forward);
        Vector3D cameraYAxis = new Vector3D((Tuple3DReadOnly)this.down);
        Vector3D cameraXAxis = new Vector3D();
        cameraXAxis.cross((Tuple3DReadOnly)cameraYAxis, (Tuple3DReadOnly)cameraZAxis);
        RotationMatrix rotationOffset = new RotationMatrix();
        rotationOffset.setColumns((Tuple3DReadOnly)cameraXAxis, (Tuple3DReadOnly)cameraYAxis, (Tuple3DReadOnly)cameraZAxis);
        JavaFXTools.convertRotationMatrixToAffine((RotationMatrixReadOnly)rotationOffset, this.offset);
    }

    public EventHandler<MouseEvent> createMouseEventHandler(final ReadOnlyDoubleProperty sceneWidthProperty, final ReadOnlyDoubleProperty sceneHeightProperty) {
        return new EventHandler<MouseEvent>(){
            private final Point2D oldMouseLocation = new Point2D();

            public void handle(MouseEvent event) {
                if (event.getButton() != CameraRotationCalculator.this.rotationMouseButton.get()) {
                    return;
                }
                if (event.isStillSincePress()) {
                    return;
                }
                if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
                    this.oldMouseLocation.set(event.getSceneX(), event.getSceneY());
                    return;
                }
                if (event.getEventType() != MouseEvent.MOUSE_DRAGGED) {
                    return;
                }
                Point2D centerLocation = new Point2D();
                Point2D newMouseLocation = new Point2D();
                centerLocation.set(sceneWidthProperty.get() / 2.0, sceneHeightProperty.get() / 2.0);
                newMouseLocation.set(event.getSceneX(), event.getSceneY());
                double modifier = CameraRotationCalculator.this.fastModifierPredicate.get() == null || !((Predicate)CameraRotationCalculator.this.fastModifierPredicate.get()).test(event) ? CameraRotationCalculator.this.slowModifier.get() : CameraRotationCalculator.this.fastModifier.get();
                Vector2D drag = new Vector2D();
                drag.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)this.oldMouseLocation);
                Vector2D centerToMouseLocation = new Vector2D();
                centerToMouseLocation.sub((Tuple2DReadOnly)newMouseLocation, (Tuple2DReadOnly)centerLocation);
                double rollShift = 0.0 * modifier * CameraRotationCalculator.this.rollModifier.get() * drag.cross((Tuple2DReadOnly)centerToMouseLocation);
                drag.scale(modifier);
                CameraRotationCalculator.this.updateRotation(drag.getY(), -drag.getX(), rollShift);
                this.oldMouseLocation.set(newMouseLocation);
            }
        };
    }

    public void updateRotation(double deltaLatitude, double deltaLongitude, double deltaRoll) {
        this.disableAffineAutoUpdate = true;
        double newLatitude = this.latitude.get() + deltaLatitude;
        newLatitude = this.restrictLatitude.get() ? MathTools.clamp((double)newLatitude, (double)this.minLatitude.get(), (double)this.maxLatitude.get()) : MathTools.clamp((double)newLatitude, (double)Math.PI);
        this.latitude.set(newLatitude);
        double newLongitude = this.longitude.get() + deltaLongitude;
        newLongitude = EuclidCoreTools.trimAngleMinusPiToPi((double)newLongitude);
        this.longitude.set(newLongitude);
        if (this.keepRotationLeveled.get()) {
            this.roll.set(0.0);
        } else {
            double newRoll = this.roll.get() + deltaRoll;
            newRoll = EuclidCoreTools.trimAngleMinusPiToPi((double)newRoll);
            this.roll.set(newRoll);
        }
        this.disableAffineAutoUpdate = false;
        this.updateRotation();
    }

    public void setRotationFromCameraAndFocusPositions(Point3DReadOnly cameraPosition, Point3DReadOnly focusPoint, double cameraRoll) {
        this.disableAffineAutoUpdate = true;
        Vector3D fromFocusToCamera = new Vector3D();
        fromFocusToCamera.sub((Tuple3DReadOnly)cameraPosition, (Tuple3DReadOnly)focusPoint);
        fromFocusToCamera.normalize();
        Vector3D fromCameraToFocus = new Vector3D();
        fromCameraToFocus.setAndNegate((Tuple3DReadOnly)fromFocusToCamera);
        fromCameraToFocus.scaleAdd(-fromCameraToFocus.dot((Tuple3DReadOnly)this.up), (Tuple3DReadOnly)this.up, (Tuple3DReadOnly)fromCameraToFocus);
        double newLatitude = 1.5707963267948966 - fromFocusToCamera.angle((Vector3DReadOnly)this.up);
        double newLongitude = fromCameraToFocus.angle((Vector3DReadOnly)this.forward);
        Vector3D cross = new Vector3D();
        cross.cross((Tuple3DReadOnly)fromCameraToFocus, (Tuple3DReadOnly)this.forward);
        if (cross.dot((Tuple3DReadOnly)this.up) > 0.0) {
            newLongitude = -newLongitude;
        }
        this.latitude.set(newLatitude);
        this.longitude.set(newLongitude);
        this.roll.set(cameraRoll);
        this.disableAffineAutoUpdate = false;
        this.updateRotation();
    }

    public void setRotation(double latitude, double longitude, double roll) {
        this.disableAffineAutoUpdate = true;
        if (this.restrictLatitude.get()) {
            this.latitude.set(MathTools.clamp((double)latitude, (double)this.minLatitude.get(), (double)this.maxLatitude.get()));
        } else {
            this.latitude.set(MathTools.clamp((double)latitude, (double)1.5707963267948966));
        }
        this.longitude.set(EuclidCoreTools.trimAngleMinusPiToPi((double)longitude));
        this.roll.set(EuclidCoreTools.trimAngleMinusPiToPi((double)roll));
        this.disableAffineAutoUpdate = false;
        this.updateRotation();
    }

    private void updateRotation() {
        Rotate latitudeRotate = new Rotate(Math.toDegrees(-this.latitude.get()), Rotate.X_AXIS);
        Rotate longitudeRotate = new Rotate(Math.toDegrees(-this.longitude.get()), Rotate.Y_AXIS);
        Rotate rollRotate = new Rotate(Math.toDegrees(this.roll.get()), Rotate.Z_AXIS);
        Affine newRotation = new Affine();
        newRotation.append((Transform)this.offset);
        newRotation.append((Transform)longitudeRotate);
        newRotation.append((Transform)latitudeRotate);
        newRotation.append((Transform)rollRotate);
        this.rotation.setToTransform((Transform)newRotation);
    }

    public Affine getRotation() {
        return this.rotation;
    }

    public final DoubleProperty latitudeProperty() {
        return this.latitude;
    }

    public final double getLatitude() {
        return this.latitudeProperty().get();
    }

    public final void setLatitude(double latitude) {
        this.latitudeProperty().set(latitude);
    }

    public final DoubleProperty longitudeProperty() {
        return this.longitude;
    }

    public final double getLongitude() {
        return this.longitudeProperty().get();
    }

    public final void setLongitude(double longitude) {
        this.longitudeProperty().set(longitude);
    }

    public final DoubleProperty rollProperty() {
        return this.roll;
    }

    public final double getRoll() {
        return this.rollProperty().get();
    }

    public final void setRoll(double roll) {
        this.rollProperty().set(roll);
    }

    public final BooleanProperty keepRotationLeveledProperty() {
        return this.keepRotationLeveled;
    }

    public final boolean isKeepRotationLeveled() {
        return this.keepRotationLeveledProperty().get();
    }

    public final void setKeepRotationLeveled(boolean keepRotationLeveled) {
        this.keepRotationLeveledProperty().set(keepRotationLeveled);
    }

    public final ObjectProperty<Predicate<MouseEvent>> fastModifierPredicateProperty() {
        return this.fastModifierPredicate;
    }

    public final Predicate<MouseEvent> getFastModifierPredicate() {
        return (Predicate)this.fastModifierPredicateProperty().get();
    }

    public final void setFastModifierPredicate(Predicate<MouseEvent> fastModifierPredicate) {
        this.fastModifierPredicateProperty().set(fastModifierPredicate);
    }

    public final DoubleProperty slowModifierProperty() {
        return this.slowModifier;
    }

    public final double getSlowModifier() {
        return this.slowModifierProperty().get();
    }

    public final void setSlowModifier(double slowModifier) {
        this.slowModifierProperty().set(slowModifier);
    }

    public final DoubleProperty fastModifierProperty() {
        return this.fastModifier;
    }

    public final double getFastModifier() {
        return this.fastModifierProperty().get();
    }

    public final void setFastModifier(double fastModifier) {
        this.fastModifierProperty().set(fastModifier);
    }

    public final DoubleProperty rollModifierProperty() {
        return this.rollModifier;
    }

    public final double getRollModifier() {
        return this.rollModifierProperty().get();
    }

    public final void setRollModifier(double rollModifier) {
        this.rollModifierProperty().set(rollModifier);
    }

    public final ObjectProperty<MouseButton> rotationMouseButtonProperty() {
        return this.rotationMouseButton;
    }

    public final MouseButton getRotationMouseButton() {
        return (MouseButton)this.rotationMouseButtonProperty().get();
    }

    public final void setRotationMouseButton(MouseButton rotationMouseButton) {
        this.rotationMouseButtonProperty().set((Object)rotationMouseButton);
    }

    public final BooleanProperty restrictLatitudeProperty() {
        return this.restrictLatitude;
    }

    public final boolean isRestrictLatitude() {
        return this.restrictLatitudeProperty().get();
    }

    public final void setRestrictLatitude(boolean restrictLatitude) {
        this.restrictLatitudeProperty().set(restrictLatitude);
    }

    public final DoubleProperty minLatitudeProperty() {
        return this.minLatitude;
    }

    public final double getMinLatitude() {
        return this.minLatitudeProperty().get();
    }

    public final void setMinLatitude(double minLatitude) {
        this.minLatitudeProperty().set(minLatitude);
    }

    public final DoubleProperty maxLatitudeProperty() {
        return this.maxLatitude;
    }

    public final double getMaxLatitude() {
        return this.maxLatitudeProperty().get();
    }

    public final void setMaxLatitude(double maxLatitude) {
        this.maxLatitudeProperty().set(maxLatitude);
    }
}

