/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.messager;

import com.sun.javafx.application.PlatformImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.SharedMemoryMessager;
import us.ihmc.messager.TopicListener;

public class SharedMemoryJavaFXMessager
extends SharedMemoryMessager
implements JavaFXMessager {
    private final Map<MessagerAPIFactory.Topic<?>, JavaFXSyncedTopicListeners> javaFXSyncedTopicListeners = new HashMap();
    private final AnimationTimer animationTimer = new AnimationTimer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(long now) {
            try {
                SharedMemoryJavaFXMessager.this.readingListeners = true;
                SharedMemoryJavaFXMessager.this.javaFXSyncedTopicListeners.entrySet().removeIf(entry -> ((JavaFXSyncedTopicListeners)entry.getValue()).isEmpty());
                for (JavaFXSyncedTopicListeners listener : SharedMemoryJavaFXMessager.this.javaFXSyncedTopicListeners.values()) {
                    listener.notifyListeners();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                SharedMemoryJavaFXMessager.this.readingListeners = false;
            }
        }
    };
    private boolean readingListeners = false;

    public SharedMemoryJavaFXMessager(MessagerAPIFactory.MessagerAPI messagerAPI) {
        super(messagerAPI);
    }

    @Override
    public <T> void registerJavaFXSyncedTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        JavaFXSyncedTopicListeners topicListeners = this.javaFXSyncedTopicListeners.get(topic);
        if (topicListeners == null) {
            JavaFXSyncedTopicListeners newTopicListeners;
            topicListeners = newTopicListeners = new JavaFXSyncedTopicListeners(topic);
            if (!this.readingListeners && Platform.isFxApplicationThread()) {
                this.javaFXSyncedTopicListeners.put(topic, newTopicListeners);
            } else {
                try {
                    Platform.runLater(() -> this.registerJavaFXSyncedTopicListener(topic, listener));
                }
                catch (IllegalStateException e) {
                    this.javaFXSyncedTopicListeners.put(topic, newTopicListeners);
                }
            }
        }
        topicListeners.addListener(listener);
    }

    @Override
    public <T> boolean removeJavaFXSyncedTopicListener(MessagerAPIFactory.Topic<T> topic, TopicListener<T> listener) {
        JavaFXSyncedTopicListeners topicListeners = this.javaFXSyncedTopicListeners.get(topic);
        if (topicListeners == null) {
            return false;
        }
        if (!this.readingListeners && Platform.isFxApplicationThread()) {
            return topicListeners.removeListener(listener);
        }
        try {
            MutableBoolean result = new MutableBoolean();
            PlatformImpl.runAndWait(() -> result.setValue(topicListeners.removeListener(listener)));
            return result.booleanValue();
        }
        catch (IllegalStateException e) {
            return topicListeners.removeListener(listener);
        }
    }

    public void startMessager() {
        super.startMessager();
        this.animationTimer.start();
    }

    public void closeMessager() {
        super.closeMessager();
        this.animationTimer.stop();
    }

    private class JavaFXSyncedTopicListeners {
        private final ConcurrentLinkedQueue<Object> inputQueue = new ConcurrentLinkedQueue();
        private final List<TopicListener<Object>> listeners = new ArrayList<TopicListener<Object>>();

        private JavaFXSyncedTopicListeners(MessagerAPIFactory.Topic<?> topic) {
            SharedMemoryJavaFXMessager.this.registerTopicListener(topic, message -> {
                if (message != null) {
                    this.inputQueue.add(message);
                }
            });
        }

        private void addListener(TopicListener<?> listener) {
            this.listeners.add(listener);
        }

        private boolean removeListener(TopicListener<?> listener) {
            return this.listeners.remove(listener);
        }

        private void notifyListeners() {
            while (!this.inputQueue.isEmpty()) {
                Object newData = this.inputQueue.poll();
                this.listeners.forEach(listener -> listener.receivedMessageForTopic(newData));
            }
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }
    }
}

