/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.shapes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import us.ihmc.javaFXToolkit.shapes.TextureColorPalette;
import us.ihmc.log.LogTools;

public class TextureColorAdaptivePalette
implements TextureColorPalette {
    private static final boolean PRINT_PALETTE = false;
    private static final int DEFAULT_PALETTE_SIZE = 1024;
    private WritableImage colorPalette;
    private int paletteSize;
    private int pixelSize;
    private final List<Color> colorList = new ArrayList<Color>();
    private final Map<Color, Integer> registeredColors = new HashMap<Color, Integer>();
    private final boolean autoClear;

    public TextureColorAdaptivePalette() {
        this(1024, 1, true);
    }

    public TextureColorAdaptivePalette(boolean autoClear) {
        this(1024, 1, autoClear);
    }

    public TextureColorAdaptivePalette(int paletteSize) {
        this(paletteSize, 1, true);
    }

    public TextureColorAdaptivePalette(int paletteSize, boolean autoClear) {
        this(paletteSize, 1, autoClear);
    }

    public TextureColorAdaptivePalette(int paletteSize, int colorPixelSize, boolean autoClear) {
        if (colorPixelSize >= paletteSize) {
            throw new RuntimeException("The size of pixels has to be smaller than the size of the palette.");
        }
        this.autoClear = autoClear;
        this.paletteSize = paletteSize;
        this.pixelSize = colorPixelSize;
    }

    public void clearPalette() {
        this.colorPalette = null;
        this.colorList.clear();
        this.registeredColors.clear();
    }

    private void initializePalette() {
        this.colorPalette = new WritableImage(this.paletteSize, this.paletteSize);
        this.colorList.clear();
        this.registeredColors.clear();
    }

    @Override
    public float[] getTextureLocation(Color color) {
        Integer pixelIndex;
        if (this.colorPalette == null) {
            this.initializePalette();
        }
        if ((pixelIndex = this.registeredColors.get(color)) != null) {
            return this.getTextureLocation(pixelIndex);
        }
        int newPixelIndex = this.colorList.size();
        if (newPixelIndex <= this.paletteSize * this.paletteSize) {
            this.colorList.add(color);
            this.registeredColors.put(color, newPixelIndex);
            this.writePixel(newPixelIndex, color);
            return this.getTextureLocation(newPixelIndex);
        }
        LogTools.error((String)"Reached maximum capacity of the palette. Next colors will be wrong.");
        return new float[]{0.0f, 0.0f};
    }

    private float[] getTextureLocation(int pixelIndex) {
        int scaledWidth = (int)this.colorPalette.getWidth() / this.pixelSize;
        int scaledHeight = (int)this.colorPalette.getHeight() / this.pixelSize;
        float x = (float)Math.floorMod(pixelIndex, scaledWidth) / (float)scaledWidth;
        float y = (float)Math.floorDiv(pixelIndex, scaledWidth) / (float)scaledHeight;
        return new float[]{x += 0.5f * (float)this.pixelSize / (float)this.colorPalette.getWidth(), y += 0.5f * (float)this.pixelSize / (float)this.colorPalette.getHeight()};
    }

    private void writePixel(int pixelIndex, Color color) {
        int width = (int)this.colorPalette.getRequestedWidth();
        int xStart = Math.floorMod(pixelIndex * this.pixelSize, width);
        int yStart = Math.floorDiv(pixelIndex * this.pixelSize, width) * this.pixelSize;
        for (int x = xStart; x < xStart + this.pixelSize; ++x) {
            for (int y = yStart; y < yStart + this.pixelSize; ++y) {
                this.colorPalette.getPixelWriter().setColor(x, y, color);
            }
        }
    }

    @Override
    public Image getColorPalette() {
        WritableImage ret = this.colorPalette;
        if (this.autoClear) {
            this.clearPalette();
        }
        return ret;
    }
}

