/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.cameraControllers;

import java.util.function.Predicate;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SubScene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.ScrollEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.javaFXToolkit.cameraControllers.CameraNodeTracker;
import us.ihmc.javaFXToolkit.cameraControllers.CameraRotationCalculator;
import us.ihmc.javaFXToolkit.cameraControllers.CameraTranslationCalculator;
import us.ihmc.javaFXToolkit.cameraControllers.CameraZoomCalculator;

public class FocusBasedCameraMouseEventHandler
implements EventHandler<Event> {
    private static final double DEFAULT_DISTANCE_FROM_FOCUS_POINT = 10.0;
    private final Sphere focusPointViz;
    private final Translate focusPointTranslation;
    private final Affine cameraOrientation;
    private final Translate offsetFromFocusPoint = new Translate(0.0, 0.0, -10.0);
    private final CameraZoomCalculator zoomCalculator = new CameraZoomCalculator();
    private final CameraRotationCalculator rotationCalculator;
    private final CameraTranslationCalculator translationCalculator;
    private final CameraNodeTracker nodeTracker;
    private final EventHandler<ScrollEvent> zoomEventHandler = this.zoomCalculator.createScrollEventHandler();
    private final EventHandler<MouseEvent> rotationEventHandler;
    private final EventHandler<KeyEvent> translationEventHandler;
    private final PerspectiveCamera camera;
    private EventHandler<MouseEvent> rayBasedFocusTranslation = null;

    public FocusBasedCameraMouseEventHandler(ReadOnlyDoubleProperty sceneWidthProperty, ReadOnlyDoubleProperty sceneHeightProperty, PerspectiveCamera camera, Vector3DReadOnly up, Vector3DReadOnly forward) {
        this.camera = camera;
        Vector3D left = new Vector3D();
        left.cross((Tuple3DReadOnly)up, (Tuple3DReadOnly)forward);
        if (!MathTools.epsilonEquals((double)left.length(), (double)1.0, (double)1.0E-5)) {
            throw new RuntimeException("The vectors up and forward must be orthogonal. Received: up = " + up + ", forward = " + forward);
        }
        this.zoomCalculator.zoomProperty().bindBidirectional((Property)this.offsetFromFocusPoint.zProperty());
        this.zoomCalculator.setInvertZoomDirection(true);
        this.zoomCalculator.setMinZoom(-0.9 * camera.getFarClip());
        this.zoomCalculator.setMaxZoom(-1.1 * camera.getNearClip());
        this.rotationCalculator = new CameraRotationCalculator(up, forward);
        this.rotationCalculator.setFastModifierPredicate(event -> event.isShiftDown());
        this.cameraOrientation = this.rotationCalculator.getRotation();
        this.rotationEventHandler = this.rotationCalculator.createMouseEventHandler(sceneWidthProperty, sceneHeightProperty);
        this.translationCalculator = new CameraTranslationCalculator(up);
        this.translationCalculator.setFastModifierPredicate(event -> event.isShiftDown());
        this.translationCalculator.setCameraOrientation((Transform)this.cameraOrientation);
        this.translationCalculator.setZoom((ReadOnlyDoubleProperty)this.zoomCalculator.zoomProperty());
        this.focusPointTranslation = this.translationCalculator.getTranslation();
        this.translationEventHandler = this.translationCalculator.createKeyEventHandler();
        this.nodeTracker = new CameraNodeTracker(this.focusPointTranslation);
        Translate nodeTrackingTranslate = this.nodeTracker.getNodeTrackingTranslate();
        this.changeCameraPosition(-2.0, 0.7, 1.0);
        camera.getTransforms().addAll((Object[])new Transform[]{nodeTrackingTranslate, this.focusPointTranslation, this.cameraOrientation, this.offsetFromFocusPoint});
        us.ihmc.euclid.tuple3D.Point3D cameraPosition = new us.ihmc.euclid.tuple3D.Point3D();
        JavaFXTools.applyTranform(camera.getLocalToSceneTransform(), (Point3DBasics)cameraPosition);
        this.focusPointViz = new Sphere(0.01);
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseColor(Color.DARKRED);
        material.setSpecularColor(Color.RED);
        this.focusPointViz.setMaterial((Material)material);
        this.focusPointViz.getTransforms().addAll((Object[])new Transform[]{nodeTrackingTranslate, this.focusPointTranslation});
        new AnimationTimer(){

            public void handle(long now) {
                double sphereRadius = 0.0025 * Math.abs(FocusBasedCameraMouseEventHandler.this.offsetFromFocusPoint.getTz());
                FocusBasedCameraMouseEventHandler.this.focusPointViz.setRadius(sphereRadius);
            }
        }.start();
    }

    public void changeCameraPosition(double x, double y, double z) {
        us.ihmc.euclid.tuple3D.Point3D desiredCameraPosition = new us.ihmc.euclid.tuple3D.Point3D(x, y, z);
        us.ihmc.euclid.tuple3D.Point3D desiredFocusPoint = new us.ihmc.euclid.tuple3D.Point3D(this.focusPointTranslation.getX(), this.focusPointTranslation.getY(), this.focusPointTranslation.getZ());
        double distanceFromFocusPoint = desiredCameraPosition.distance((Point3DReadOnly)desiredFocusPoint);
        this.offsetFromFocusPoint.setZ(-distanceFromFocusPoint);
        this.rotationCalculator.setRotationFromCameraAndFocusPositions((Point3DReadOnly)desiredCameraPosition, (Point3DReadOnly)desiredFocusPoint, 0.0);
    }

    public void handle(Event event) {
        if (event instanceof ScrollEvent) {
            this.zoomEventHandler.handle((Event)((ScrollEvent)event));
        }
        if (event instanceof KeyEvent) {
            this.translationEventHandler.handle((Event)((KeyEvent)event));
        }
        if (event instanceof MouseEvent) {
            if (this.rayBasedFocusTranslation != null) {
                this.rayBasedFocusTranslation.handle((Event)((MouseEvent)event));
            }
            this.rotationEventHandler.handle((Event)((MouseEvent)event));
        }
    }

    public void enableShiftClickFocusTranslation() {
        this.setupRayBasedFocusTranslation(event -> {
            if (!event.isShiftDown()) {
                return false;
            }
            if (event.getButton() != MouseButton.PRIMARY) {
                return false;
            }
            if (!event.isStillSincePress()) {
                return false;
            }
            return event.getEventType() == MouseEvent.MOUSE_CLICKED;
        });
    }

    public void setupRayBasedFocusTranslation(Predicate<MouseEvent> condition) {
        this.setupRayBasedFocusTranslation(condition, 0.1);
    }

    public void setupRayBasedFocusTranslation(final Predicate<MouseEvent> condition, final double animationDuration) {
        this.rayBasedFocusTranslation = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (condition.test(event)) {
                    PickResult pickResult = event.getPickResult();
                    Node intersectedNode = pickResult.getIntersectedNode();
                    if (intersectedNode == null || intersectedNode instanceof SubScene) {
                        return;
                    }
                    Point3D localPoint = pickResult.getIntersectedPoint();
                    Point3D scenePoint = intersectedNode.getLocalToSceneTransform().transform(localPoint);
                    FocusBasedCameraMouseEventHandler.this.nodeTracker.setNodeToTrack(null);
                    FocusBasedCameraMouseEventHandler.this.nodeTracker.resetTranslate();
                    if (animationDuration > 0.0) {
                        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)animationDuration), new KeyValue[]{new KeyValue((WritableValue)FocusBasedCameraMouseEventHandler.this.focusPointTranslation.xProperty(), (Object)scenePoint.getX(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)FocusBasedCameraMouseEventHandler.this.focusPointTranslation.yProperty(), (Object)scenePoint.getY(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)FocusBasedCameraMouseEventHandler.this.focusPointTranslation.zProperty(), (Object)scenePoint.getZ(), Interpolator.EASE_BOTH)})});
                        animation.playFromStart();
                    } else {
                        FocusBasedCameraMouseEventHandler.this.focusPointTranslation.setX(scenePoint.getX());
                        FocusBasedCameraMouseEventHandler.this.focusPointTranslation.setY(scenePoint.getY());
                        FocusBasedCameraMouseEventHandler.this.focusPointTranslation.setZ(scenePoint.getZ());
                    }
                }
            }
        };
    }

    public Sphere getFocusPointViz() {
        return this.focusPointViz;
    }

    public void prependTransform(Transform transform) {
        this.camera.getTransforms().add(0, (Object)transform);
        this.focusPointViz.getTransforms().add(0, (Object)transform);
    }

    public Translate getTranslate() {
        return this.focusPointTranslation;
    }

    public CameraZoomCalculator getZoomCalculator() {
        return this.zoomCalculator;
    }

    public final DoubleProperty minZoomProperty() {
        return this.zoomCalculator.minZoomProperty();
    }

    public final double getMinZoom() {
        return this.minZoomProperty().get();
    }

    public final void setMinZoom(double minZoom) {
        this.minZoomProperty().set(minZoom);
    }

    public final DoubleProperty maxZoomProperty() {
        return this.zoomCalculator.maxZoomProperty();
    }

    public final double getMaxZoom() {
        return this.maxZoomProperty().get();
    }

    public final void setMaxZoom(double maxZoom) {
        this.maxZoomProperty().set(maxZoom);
    }

    public final DoubleProperty zoomSpeedFactorProperty() {
        return this.zoomCalculator.zoomSpeedFactorProperty();
    }

    public final double getZoomSpeedFactor() {
        return this.zoomSpeedFactorProperty().get();
    }

    public final void setZoomSpeedFactor(double zoomSpeedFactor) {
        this.zoomSpeedFactorProperty().set(zoomSpeedFactor);
    }

    public final BooleanProperty invertZoomDirectionProperty() {
        return this.zoomCalculator.invertZoomDirectionProperty();
    }

    public final boolean isInvertZoomDirection() {
        return this.invertZoomDirectionProperty().get();
    }

    public final void setInvertZoomDirection(boolean invertZoomDirection) {
        this.invertZoomDirectionProperty().set(invertZoomDirection);
    }

    public CameraRotationCalculator getRotationCalculator() {
        return this.rotationCalculator;
    }

    public final DoubleProperty latitudeProperty() {
        return this.rotationCalculator.latitudeProperty();
    }

    public final double getLatitude() {
        return this.latitudeProperty().get();
    }

    public final void setLatitude(double latitude) {
        this.latitudeProperty().set(latitude);
    }

    public final DoubleProperty longitudeProperty() {
        return this.rotationCalculator.longitudeProperty();
    }

    public final double getLongitude() {
        return this.longitudeProperty().get();
    }

    public final void setLongitude(double longitude) {
        this.longitudeProperty().set(longitude);
    }

    public final DoubleProperty rollProperty() {
        return this.rotationCalculator.rollProperty();
    }

    public final double getRoll() {
        return this.rollProperty().get();
    }

    public final void setRoll(double roll) {
        this.rollProperty().set(roll);
    }

    public final BooleanProperty keepRotationLeveledProperty() {
        return this.rotationCalculator.keepRotationLeveledProperty();
    }

    public final boolean isKeepRotationLeveled() {
        return this.keepRotationLeveledProperty().get();
    }

    public final void setKeepRotationLeveled(boolean keepRotationLeveled) {
        this.keepRotationLeveledProperty().set(keepRotationLeveled);
    }

    public final ObjectProperty<Predicate<MouseEvent>> rotationFastModifierPredicateProperty() {
        return this.rotationCalculator.fastModifierPredicateProperty();
    }

    public final Predicate<MouseEvent> getRotationFastModifierPredicate() {
        return (Predicate)this.rotationFastModifierPredicateProperty().get();
    }

    public final void setRotationFastModifierPredicate(Predicate<MouseEvent> fastModifierPredicate) {
        this.rotationFastModifierPredicateProperty().set(fastModifierPredicate);
    }

    public final DoubleProperty rotationSlowModifierProperty() {
        return this.rotationCalculator.slowModifierProperty();
    }

    public final double getRotationSlowModifier() {
        return this.rotationSlowModifierProperty().get();
    }

    public final void setRotationSlowModifier(double slowModifier) {
        this.rotationSlowModifierProperty().set(slowModifier);
    }

    public final DoubleProperty rotationFastModifierProperty() {
        return this.rotationCalculator.fastModifierProperty();
    }

    public final double getRotationFastModifier() {
        return this.rotationFastModifierProperty().get();
    }

    public final void setRotationFastModifier(double fastModifier) {
        this.rotationFastModifierProperty().set(fastModifier);
    }

    public final DoubleProperty rollModifierProperty() {
        return this.rotationCalculator.rollModifierProperty();
    }

    public final double getRollModifier() {
        return this.rollModifierProperty().get();
    }

    public final void setRollModifier(double rollModifier) {
        this.rollModifierProperty().set(rollModifier);
    }

    public final ObjectProperty<MouseButton> rotationMouseButtonProperty() {
        return this.rotationCalculator.rotationMouseButtonProperty();
    }

    public final MouseButton getRotationMouseButton() {
        return (MouseButton)this.rotationMouseButtonProperty().get();
    }

    public final void setRotationMouseButton(MouseButton rotationMouseButton) {
        this.rotationMouseButtonProperty().set((Object)rotationMouseButton);
    }

    public final BooleanProperty restrictLatitudeProperty() {
        return this.rotationCalculator.restrictLatitudeProperty();
    }

    public final boolean isRestrictLatitude() {
        return this.restrictLatitudeProperty().get();
    }

    public final void setRestrictLatitude(boolean restrictLatitude) {
        this.restrictLatitudeProperty().set(restrictLatitude);
    }

    public final DoubleProperty minLatitudeProperty() {
        return this.rotationCalculator.minLatitudeProperty();
    }

    public final double getMinLatitude() {
        return this.minLatitudeProperty().get();
    }

    public final void setMinLatitude(double minLatitude) {
        this.minLatitudeProperty().set(minLatitude);
    }

    public final DoubleProperty maxLatitudeProperty() {
        return this.rotationCalculator.maxLatitudeProperty();
    }

    public final double getMaxLatitude() {
        return this.maxLatitudeProperty().get();
    }

    public final void setMaxLatitude(double maxLatitude) {
        this.maxLatitudeProperty().set(maxLatitude);
    }

    public CameraTranslationCalculator getTranslationCalculator() {
        return this.translationCalculator;
    }

    public final BooleanProperty keepTranslationLeveledProperty() {
        return this.translationCalculator.keepTranslationLeveledProperty();
    }

    public final boolean isKeepTranslationLeveled() {
        return this.keepTranslationLeveledProperty().get();
    }

    public final void setKeepTranslationLeveled(boolean keepTranslationLeveled) {
        this.keepTranslationLeveledProperty().set(keepTranslationLeveled);
    }

    public final ObjectProperty<Predicate<KeyEvent>> translationFastModifierPredicateProperty() {
        return this.translationCalculator.fastModifierPredicateProperty();
    }

    public final Predicate<KeyEvent> getTranslationFastModifierPredicate() {
        return (Predicate)this.translationFastModifierPredicateProperty().get();
    }

    public final void setTranslationFastModifierPredicate(Predicate<KeyEvent> fastModifierPredicate) {
        this.translationFastModifierPredicateProperty().set(fastModifierPredicate);
    }

    public final DoubleProperty translationSlowModifierProperty() {
        return this.translationCalculator.slowModifierProperty();
    }

    public final double getTranslationSlowModifier() {
        return this.translationSlowModifierProperty().get();
    }

    public final void setTranslationSlowModifier(double slowModifier) {
        this.translationSlowModifierProperty().set(slowModifier);
    }

    public final DoubleProperty translationFastModifierProperty() {
        return this.translationCalculator.fastModifierProperty();
    }

    public final double getTranslationFastModifier() {
        return this.translationFastModifierProperty().get();
    }

    public final void setTranslationFastModifier(double fastModifier) {
        this.translationFastModifierProperty().set(fastModifier);
    }

    public final DoubleProperty minTranslationOffsetProperty() {
        return this.translationCalculator.minTranslationOffsetProperty();
    }

    public final double getMinTranslationOffset() {
        return this.minTranslationOffsetProperty().get();
    }

    public final void setMinTranslationOffset(double minTranslationOffset) {
        this.minTranslationOffsetProperty().set(minTranslationOffset);
    }

    public final DoubleProperty zoomToTranslationPowProperty() {
        return this.translationCalculator.zoomToTranslationPowProperty();
    }

    public final double getZoomToTranslationPow() {
        return this.zoomToTranslationPowProperty().get();
    }

    public final void setZoomToTranslationPow(double zoomToTranslationPow) {
        this.zoomToTranslationPowProperty().set(zoomToTranslationPow);
    }

    public final ObjectProperty<KeyCode> forwardKeyProperty() {
        return this.translationCalculator.forwardKeyProperty();
    }

    public final KeyCode getForwardKey() {
        return (KeyCode)this.forwardKeyProperty().get();
    }

    public final void setForwardKey(KeyCode forwardKey) {
        this.forwardKeyProperty().set((Object)forwardKey);
    }

    public final ObjectProperty<KeyCode> backwardKeyProperty() {
        return this.translationCalculator.backwardKeyProperty();
    }

    public final KeyCode getBackwardKey() {
        return (KeyCode)this.backwardKeyProperty().get();
    }

    public final void setBackwardKey(KeyCode backwardKey) {
        this.backwardKeyProperty().set((Object)backwardKey);
    }

    public final ObjectProperty<KeyCode> leftKeyProperty() {
        return this.translationCalculator.leftKeyProperty();
    }

    public final KeyCode getLeftKey() {
        return (KeyCode)this.leftKeyProperty().get();
    }

    public final void setLeftKey(KeyCode leftKey) {
        this.leftKeyProperty().set((Object)leftKey);
    }

    public final ObjectProperty<KeyCode> rightKeyProperty() {
        return this.translationCalculator.rightKeyProperty();
    }

    public final KeyCode getRightKey() {
        return (KeyCode)this.rightKeyProperty().get();
    }

    public final void setRightKey(KeyCode rightKey) {
        this.rightKeyProperty().set((Object)rightKey);
    }

    public final ObjectProperty<KeyCode> upKeyProperty() {
        return this.translationCalculator.upKeyProperty();
    }

    public final KeyCode getUpKey() {
        return (KeyCode)this.upKeyProperty().get();
    }

    public final void setUpKey(KeyCode upKey) {
        this.upKeyProperty().set((Object)upKey);
    }

    public final ObjectProperty<KeyCode> downKeyProperty() {
        return this.translationCalculator.downKeyProperty();
    }

    public final KeyCode getDownKey() {
        return (KeyCode)this.downKeyProperty().get();
    }

    public final void setDownKey(KeyCode downKey) {
        this.downKeyProperty().set((Object)downKey);
    }

    public CameraNodeTracker getNodeTracker() {
        return this.nodeTracker;
    }
}

