/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.cameraControllers;

import java.util.function.Predicate;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;

public class CameraTranslationCalculator {
    private final Translate translation = new Translate();
    private final ObjectProperty<Transform> cameraOrientation = new SimpleObjectProperty((Object)this, "cameraOrientation", null);
    private ReadOnlyDoubleProperty currentZoom = null;
    private final BooleanProperty keepTranslationLeveled = new SimpleBooleanProperty((Object)this, "keepTranslationLeveled", true);
    private final ObjectProperty<Predicate<KeyEvent>> fastModifierPredicate = new SimpleObjectProperty((Object)this, "fastModifierPredicate", null);
    private final DoubleProperty slowModifier = new SimpleDoubleProperty((Object)this, "slowModifier", 0.005);
    private final DoubleProperty fastModifier = new SimpleDoubleProperty((Object)this, "fastModifier", 0.01);
    private final DoubleProperty minTranslationOffset = new SimpleDoubleProperty((Object)this, "minTranslationOffset", 0.1);
    private final DoubleProperty zoomToTranslationPow = new SimpleDoubleProperty((Object)this, "zoomToTranslationPow", 1.5);
    private final ObjectProperty<KeyCode> forwardKey = new SimpleObjectProperty((Object)this, "forwardKey", (Object)KeyCode.W);
    private final ObjectProperty<KeyCode> backwardKey = new SimpleObjectProperty((Object)this, "backwardKey", (Object)KeyCode.S);
    private final ObjectProperty<KeyCode> leftKey = new SimpleObjectProperty((Object)this, "leftKey", (Object)KeyCode.A);
    private final ObjectProperty<KeyCode> rightKey = new SimpleObjectProperty((Object)this, "rightKey", (Object)KeyCode.D);
    private final ObjectProperty<KeyCode> upKey = new SimpleObjectProperty((Object)this, "upKey", (Object)KeyCode.Q);
    private final ObjectProperty<KeyCode> downKey = new SimpleObjectProperty((Object)this, "downKey", (Object)KeyCode.Z);
    private final Vector3D down = new Vector3D();

    public CameraTranslationCalculator(Vector3DReadOnly up) {
        this.down.setAndNegate((Tuple3DReadOnly)up);
    }

    public EventHandler<KeyEvent> createKeyEventHandler() {
        final Vector3D activeTranslationOffset = new Vector3D();
        AnimationTimer translateAnimation = new AnimationTimer(){

            public void handle(long now) {
                CameraTranslationCalculator.this.updateObserverTranslation((Vector3DReadOnly)activeTranslationOffset);
            }
        };
        translateAnimation.start();
        EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                boolean isKeyReleased;
                double modifier = CameraTranslationCalculator.this.fastModifierPredicate.get() == null || !((Predicate)CameraTranslationCalculator.this.fastModifierPredicate.get()).test(event) ? CameraTranslationCalculator.this.slowModifier.get() : CameraTranslationCalculator.this.fastModifier.get();
                if (CameraTranslationCalculator.this.currentZoom != null) {
                    modifier *= Math.pow(Math.abs(CameraTranslationCalculator.this.currentZoom.get()), CameraTranslationCalculator.this.zoomToTranslationPow.get());
                    modifier = Math.min(modifier, CameraTranslationCalculator.this.minTranslationOffset.get());
                }
                KeyCode keyDown = event.getCode();
                boolean bl = isKeyReleased = event.getEventType() == KeyEvent.KEY_RELEASED;
                if (keyDown == CameraTranslationCalculator.this.forwardKey.get()) {
                    activeTranslationOffset.setZ(isKeyReleased ? 0.0 : modifier);
                }
                if (keyDown == CameraTranslationCalculator.this.backwardKey.get()) {
                    activeTranslationOffset.setZ(isKeyReleased ? 0.0 : -modifier);
                }
                if (keyDown == CameraTranslationCalculator.this.rightKey.get()) {
                    activeTranslationOffset.setX(isKeyReleased ? 0.0 : modifier);
                }
                if (keyDown == CameraTranslationCalculator.this.leftKey.get()) {
                    activeTranslationOffset.setX(isKeyReleased ? 0.0 : -modifier);
                }
                if (keyDown == CameraTranslationCalculator.this.downKey.get()) {
                    activeTranslationOffset.setY(isKeyReleased ? 0.0 : modifier);
                }
                if (keyDown == CameraTranslationCalculator.this.upKey.get()) {
                    activeTranslationOffset.setY(isKeyReleased ? 0.0 : -modifier);
                }
            }
        };
        return keyEventHandler;
    }

    public void updateObserverTranslation(Vector3DReadOnly translationOffset) {
        this.updateObserverTranslation(translationOffset.getX(), translationOffset.getY(), translationOffset.getZ());
    }

    public void updateObserverTranslation(double dx, double dy, double dz) {
        if (this.cameraOrientation.get() == null) {
            this.updateWorldTranslation(dx, dy, dz);
            return;
        }
        Vector3D shift = new Vector3D(dx, dy, dz);
        if (this.keepTranslationLeveled.get()) {
            double mxz = ((Transform)this.cameraOrientation.get()).getMxz();
            double myz = ((Transform)this.cameraOrientation.get()).getMyz();
            double mzz = ((Transform)this.cameraOrientation.get()).getMzz();
            Vector3D cameraZAxis = new Vector3D(mxz, myz, mzz);
            Vector3D xAxisLeveled = new Vector3D();
            xAxisLeveled.cross((Tuple3DReadOnly)this.down, (Tuple3DReadOnly)cameraZAxis);
            xAxisLeveled.normalize();
            Vector3D yAxisLeveled = new Vector3D((Tuple3DReadOnly)this.down);
            Vector3D zAxisLeveled = new Vector3D();
            zAxisLeveled.cross((Tuple3DReadOnly)xAxisLeveled, (Tuple3DReadOnly)yAxisLeveled);
            RotationMatrix rotation = new RotationMatrix();
            rotation.setColumns((Tuple3DReadOnly)xAxisLeveled, (Tuple3DReadOnly)yAxisLeveled, (Tuple3DReadOnly)zAxisLeveled);
            rotation.transform((Tuple3DBasics)shift);
        } else {
            JavaFXTools.applyTranform((Transform)this.cameraOrientation.get(), (Vector3DBasics)shift);
        }
        JavaFXTools.addEquals(this.translation, (Tuple3DBasics)shift);
    }

    public void updateWorldTranslation(double dx, double dy, double dz) {
        Vector3D shift = new Vector3D(dx, dy, dz);
        JavaFXTools.addEquals(this.translation, (Tuple3DBasics)shift);
    }

    public void setCameraOrientation(Transform cameraOrientation) {
        this.cameraOrientation.set((Object)cameraOrientation);
    }

    public void setZoom(ReadOnlyDoubleProperty zoom) {
        this.currentZoom = zoom;
    }

    public Translate getTranslation() {
        return this.translation;
    }

    public final BooleanProperty keepTranslationLeveledProperty() {
        return this.keepTranslationLeveled;
    }

    public final boolean isKeepTranslationLeveled() {
        return this.keepTranslationLeveledProperty().get();
    }

    public final void setKeepTranslationLeveled(boolean keepTranslationLeveled) {
        this.keepTranslationLeveledProperty().set(keepTranslationLeveled);
    }

    public final ObjectProperty<Predicate<KeyEvent>> fastModifierPredicateProperty() {
        return this.fastModifierPredicate;
    }

    public final Predicate<KeyEvent> getFastModifierPredicate() {
        return (Predicate)this.fastModifierPredicateProperty().get();
    }

    public final void setFastModifierPredicate(Predicate<KeyEvent> fastModifierPredicate) {
        this.fastModifierPredicateProperty().set(fastModifierPredicate);
    }

    public final DoubleProperty slowModifierProperty() {
        return this.slowModifier;
    }

    public final double getSlowModifier() {
        return this.slowModifierProperty().get();
    }

    public final void setSlowModifier(double slowModifier) {
        this.slowModifierProperty().set(slowModifier);
    }

    public final DoubleProperty fastModifierProperty() {
        return this.fastModifier;
    }

    public final double getFastModifier() {
        return this.fastModifierProperty().get();
    }

    public final void setFastModifier(double fastModifier) {
        this.fastModifierProperty().set(fastModifier);
    }

    public final DoubleProperty minTranslationOffsetProperty() {
        return this.minTranslationOffset;
    }

    public final double getMinTranslationOffset() {
        return this.minTranslationOffsetProperty().get();
    }

    public final void setMinTranslationOffset(double minTranslationOffset) {
        this.minTranslationOffsetProperty().set(minTranslationOffset);
    }

    public final DoubleProperty zoomToTranslationPowProperty() {
        return this.zoomToTranslationPow;
    }

    public final double getZoomToTranslationPow() {
        return this.zoomToTranslationPowProperty().get();
    }

    public final void setZoomToTranslationPow(double zoomToTranslationPow) {
        this.zoomToTranslationPowProperty().set(zoomToTranslationPow);
    }

    public final ObjectProperty<KeyCode> forwardKeyProperty() {
        return this.forwardKey;
    }

    public final KeyCode getForwardKey() {
        return (KeyCode)this.forwardKeyProperty().get();
    }

    public final void setForwardKey(KeyCode forwardKey) {
        this.forwardKeyProperty().set((Object)forwardKey);
    }

    public final ObjectProperty<KeyCode> backwardKeyProperty() {
        return this.backwardKey;
    }

    public final KeyCode getBackwardKey() {
        return (KeyCode)this.backwardKeyProperty().get();
    }

    public final void setBackwardKey(KeyCode backwardKey) {
        this.backwardKeyProperty().set((Object)backwardKey);
    }

    public final ObjectProperty<KeyCode> leftKeyProperty() {
        return this.leftKey;
    }

    public final KeyCode getLeftKey() {
        return (KeyCode)this.leftKeyProperty().get();
    }

    public final void setLeftKey(KeyCode leftKey) {
        this.leftKeyProperty().set((Object)leftKey);
    }

    public final ObjectProperty<KeyCode> rightKeyProperty() {
        return this.rightKey;
    }

    public final KeyCode getRightKey() {
        return (KeyCode)this.rightKeyProperty().get();
    }

    public final void setRightKey(KeyCode rightKey) {
        this.rightKeyProperty().set((Object)rightKey);
    }

    public final ObjectProperty<KeyCode> upKeyProperty() {
        return this.upKey;
    }

    public final KeyCode getUpKey() {
        return (KeyCode)this.upKeyProperty().get();
    }

    public final void setUpKey(KeyCode upKey) {
        this.upKeyProperty().set((Object)upKey);
    }

    public final ObjectProperty<KeyCode> downKeyProperty() {
        return this.downKey;
    }

    public final KeyCode getDownKey() {
        return (KeyCode)this.downKeyProperty().get();
    }

    public final void setDownKey(KeyCode downKey) {
        this.downKeyProperty().set((Object)downKey);
    }
}

