/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXToolkit.shapes;

import java.util.Random;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import javafx.stage.Stage;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.javaFXToolkit.shapes.JavaFXMeshBuilder;
import us.ihmc.javaFXToolkit.starter.ApplicationRunner;

public class MeshBuilderVisualizer {
    private static final MeshToDisplay MESH_TO_DISPLAY = MeshToDisplay.CONE;

    public MeshBuilderVisualizer(Stage primaryStage) {
        primaryStage.setTitle(this.getClass().getSimpleName());
        View3DFactory view3dFactory = new View3DFactory(600.0, 400.0);
        view3dFactory.addCameraController();
        view3dFactory.addWorldCoordinateSystem(0.3);
        JavaFXMeshBuilder meshBuilder = new JavaFXMeshBuilder();
        switch (MESH_TO_DISPLAY) {
            case BOX: {
                this.addRandomBoxes(meshBuilder);
                break;
            }
            case LINE: {
                this.addLines(meshBuilder);
                break;
            }
            case CYLINDER: {
                this.addCylinders(meshBuilder);
                break;
            }
            case CONE: {
                this.addCones(meshBuilder);
                break;
            }
        }
        MeshView meshView = new MeshView(meshBuilder.generateMesh());
        PhongMaterial material = new PhongMaterial();
        material.setDiffuseColor(Color.CYAN);
        material.setSpecularColor(Color.CYAN.brighter());
        meshView.setMaterial((Material)material);
        view3dFactory.addNodeToView((Node)meshView);
        primaryStage.setScene(view3dFactory.getScene());
        primaryStage.show();
    }

    public void addRandomBoxes(JavaFXMeshBuilder meshBuilder) {
        int count = 0;
        for (float x = -5.0f; x <= 5.0f; x += 0.055f) {
            for (float y = -2.0f; y <= 2.0f; y += 0.055f) {
                meshBuilder.addBox(0.05f, 0.05f, 0.05f, (Tuple3DReadOnly)new Vector3D32(x, y, RandomNumbers.nextFloat((Random)new Random(), (float)-2.0f, (float)2.0f)));
                ++count;
            }
        }
        System.out.println("Number of boxes: " + count);
    }

    private void addLines(JavaFXMeshBuilder meshBuilder) {
        Point3D start = new Point3D(0.3, 0.0, -0.0);
        Point3D end = new Point3D(0.0, 0.3, 0.0);
        double lineWidth = 0.01;
        meshBuilder.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth);
    }

    private void addCylinders(JavaFXMeshBuilder meshBuilder) {
        Point3D cylinderPosition = new Point3D(1.0, 0.0, 0.0);
        double height = 0.3;
        double radius = 0.1;
        meshBuilder.addCylinder(height, radius, (Tuple3DReadOnly)cylinderPosition);
        meshBuilder.addMesh(MeshDataGenerator.Cylinder((double)radius, (double)height, (int)64));
    }

    private void addCones(JavaFXMeshBuilder meshBuilder) {
        Point3D conePosition = new Point3D(0.4, 0.0, 0.0);
        double height = 0.3;
        double radius = 0.1;
        meshBuilder.addCone(height, radius, (Tuple3DReadOnly)conePosition);
        meshBuilder.addMesh(MeshDataGenerator.Cone((double)height, (double)radius, (int)64));
    }

    public static void main(String[] args) {
        ApplicationRunner.runApplication(MeshBuilderVisualizer::new);
    }

    private static enum MeshToDisplay {
        BOX,
        LINE,
        CYLINDER,
        CONE;

    }
}

