/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXGraphics;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.color.MutableColor;
import us.ihmc.graphicsDescription.instructions.Graphics3DInstruction;
import us.ihmc.graphicsDescription.instructions.Graphics3DPrimitiveInstruction;
import us.ihmc.javaFXToolkit.node.JavaFXGraphicsObject;

@Tag(value="gui")
public class JavaFXGraphicsTest {
    private static final double CUBE_SIDE = 2.0;
    private static final double CUBE_X = 5.0;
    private static final AppearanceDefinition desiredAppearance = YoAppearance.Red();

    @Test
    public void testJavaFXGraphicsObject() {
        Graphics3DObject cubeGraphics = new Graphics3DObject();
        cubeGraphics.translate((Tuple3DReadOnly)new Vector3D(5.0, 0.0, 0.0));
        cubeGraphics.addCube(2.0, 2.0, 2.0);
        JavaFXGraphicsObject javaFXGraphics = new JavaFXGraphicsObject(cubeGraphics, desiredAppearance);
        List graphics3dInstructions = cubeGraphics.getGraphics3DInstructions();
        for (Graphics3DPrimitiveInstruction primitive : graphics3dInstructions) {
            if (!(primitive instanceof Graphics3DInstruction)) continue;
            Graphics3DInstruction graphicsInstruction = (Graphics3DInstruction)primitive;
            AppearanceDefinition appearance = graphicsInstruction.getAppearance();
            MutableColor actualColor = appearance.getColor();
            MutableColor expectedColor = desiredAppearance.getColor();
            Assertions.assertTrue((actualColor.x == expectedColor.x ? 1 : 0) != 0);
            Assertions.assertTrue((actualColor.y == expectedColor.y ? 1 : 0) != 0);
            Assertions.assertTrue((actualColor.z == expectedColor.z ? 1 : 0) != 0);
        }
        System.out.print(javaFXGraphics.getClass().getSimpleName() + " propely set up graphics from instructions.");
    }
}

