/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXExtensions.control;

import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;

public class UnboundedDoubleSpinnerValueFactory
extends SpinnerValueFactory<Double> {
    private DoubleProperty min = new SimpleDoubleProperty((Object)this, "min"){

        protected void invalidated() {
            Double currentValue = (Double)UnboundedDoubleSpinnerValueFactory.this.getValue();
            if (currentValue == null) {
                return;
            }
            double newMin = this.get();
            if (newMin > UnboundedDoubleSpinnerValueFactory.this.getMax()) {
                UnboundedDoubleSpinnerValueFactory.this.setMin(UnboundedDoubleSpinnerValueFactory.this.getMax());
                return;
            }
            if (currentValue < newMin) {
                UnboundedDoubleSpinnerValueFactory.this.setValue(newMin);
            }
        }
    };
    private DoubleProperty max = new SimpleDoubleProperty((Object)this, "max"){

        protected void invalidated() {
            Double currentValue = (Double)UnboundedDoubleSpinnerValueFactory.this.getValue();
            if (currentValue == null) {
                return;
            }
            double newMax = this.get();
            if (newMax < UnboundedDoubleSpinnerValueFactory.this.getMin()) {
                UnboundedDoubleSpinnerValueFactory.this.setMax(UnboundedDoubleSpinnerValueFactory.this.getMin());
                return;
            }
            if (currentValue > newMax) {
                UnboundedDoubleSpinnerValueFactory.this.setValue(newMax);
            }
        }
    };
    private DoubleProperty amountToStepBy = new SimpleDoubleProperty((Object)this, "amountToStepBy");

    public UnboundedDoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max) {
        this(min, max, min);
    }

    public UnboundedDoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue) {
        this(min, max, initialValue, 1.0);
    }

    public UnboundedDoubleSpinnerValueFactory(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue, @NamedArg(value="amountToStepBy") double amountToStepBy) {
        this.setMin(min);
        this.setMax(max);
        this.setAmountToStepBy(amountToStepBy);
        this.setConverter((StringConverter)new DoubleStringConverter());
        this.valueProperty().addListener((o, oldValue, newValue) -> {
            if (newValue == null) {
                this.setValue(oldValue);
                return;
            }
            if (newValue < this.getMin()) {
                this.setValue(this.getMin());
            } else if (newValue > this.getMax()) {
                this.setValue(this.getMax());
            }
        });
        this.setValue(initialValue >= min && initialValue <= max ? initialValue : min);
    }

    public final void setMin(double value) {
        this.min.set(value);
    }

    public final double getMin() {
        return this.min.get();
    }

    public final DoubleProperty minProperty() {
        return this.min;
    }

    public final void setMax(double value) {
        this.max.set(value);
    }

    public final double getMax() {
        return this.max.get();
    }

    public final DoubleProperty maxProperty() {
        return this.max;
    }

    public final void setAmountToStepBy(double value) {
        this.amountToStepBy.set(value);
    }

    public final double getAmountToStepBy() {
        return this.amountToStepBy.get();
    }

    public final DoubleProperty amountToStepByProperty() {
        return this.amountToStepBy;
    }

    public void decrement(int steps) {
        double currentValue = (Double)this.getValue();
        double min = this.getMin();
        double max = this.getMax();
        double amountToStepBy = this.getAmountToStepBy();
        double newValue = currentValue - amountToStepBy * (double)steps;
        if (newValue >= min) {
            this.setValue(newValue);
        } else if (this.isWrapAround()) {
            this.setValue(UnboundedDoubleSpinnerValueFactory.wrapValue(newValue, min, max));
        } else {
            this.setValue(min);
        }
    }

    public void increment(int steps) {
        double currentValue = (Double)this.getValue();
        double min = this.getMin();
        double max = this.getMax();
        double amountToStepBy = this.getAmountToStepBy();
        double newValue = currentValue + amountToStepBy * (double)steps;
        if (newValue <= max) {
            this.setValue(newValue);
        } else if (this.isWrapAround()) {
            this.setValue(UnboundedDoubleSpinnerValueFactory.wrapValue(newValue, min, max));
        } else {
            this.setValue(max);
        }
    }

    static double wrapValue(double value, double min, double max) {
        if (max == 0.0) {
            throw new RuntimeException();
        }
        if (value < min) {
            return max;
        }
        if (value > max) {
            return min;
        }
        return value;
    }
}

