/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.scene.chart.NumberAxis;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.StringConverter;

public interface FastAxisBase {
    public Region asRegion();

    default public double prefWidth(double height) {
        return this.asRegion().prefWidth(height);
    }

    default public double prefHeight(double width) {
        return this.asRegion().prefHeight(width);
    }

    default public double getWidth() {
        return this.asRegion().getWidth();
    }

    default public double getHeight() {
        return this.asRegion().getHeight();
    }

    default public Point2D screenToLocal(double screenX, double screenY) {
        return this.asRegion().screenToLocal(screenX, screenY);
    }

    default public void resizeRelocate(double x, double y, double width, double height) {
        this.asRegion().resizeRelocate(x, y, width, height);
    }

    public void requestAxisLayout();

    default public void layout() {
        this.asRegion().layout();
    }

    default public Side getSide() {
        return (Side)this.sideProperty().get();
    }

    default public void setSide(Side value) {
        this.sideProperty().set((Object)value);
    }

    public ObjectProperty<Side> sideProperty();

    default public boolean isAutoRanging() {
        return this.autoRangingProperty().get();
    }

    default public void setAutoRanging(boolean value) {
        this.autoRangingProperty().set(value);
    }

    public BooleanProperty autoRangingProperty();

    default public void invalidateRange(double[] data) {
        ArrayList<Number> dataAsList = new ArrayList<Number>();
        for (double value : data) {
            dataAsList.add(value);
        }
        this.invalidateRange(dataAsList);
    }

    default public void invalidateRange(double minValue, double maxValue) {
        this.invalidateRange(Arrays.asList(minValue, maxValue));
    }

    public void invalidateRange(List<Number> var1);

    public double getDisplayPosition(double var1);

    public double getValueForDisplay(double var1);

    public void setForceZeroInRange(boolean var1);

    default public double getTickUnit() {
        if (this.tickUnitProperty() != null) {
            return this.tickUnitProperty().get();
        }
        return Double.NaN;
    }

    default public void setTickUnit(double value) {
        if (this.tickUnitProperty() != null) {
            this.tickUnitProperty().set(value);
        }
    }

    public DoubleProperty tickUnitProperty();

    default public boolean isMinorTickVisible() {
        if (this.minorTickVisibleProperty() != null) {
            return this.minorTickVisibleProperty().get();
        }
        return false;
    }

    default public void setMinorTickVisible(boolean value) {
        if (this.minorTickVisibleProperty() != null) {
            this.minorTickVisibleProperty().set(value);
        }
    }

    public BooleanProperty minorTickVisibleProperty();

    default public double getScale() {
        return this.scaleProperty().get();
    }

    public ReadOnlyDoubleProperty scaleProperty();

    default public double getLowerBound() {
        return this.lowerBoundProperty().get();
    }

    default public void setLowerBound(double value) {
        this.lowerBoundProperty().set(value);
    }

    public DoubleProperty lowerBoundProperty();

    default public double getUpperBound() {
        return this.upperBoundProperty().get();
    }

    default public void setUpperBound(double value) {
        this.upperBoundProperty().set(value);
    }

    public DoubleProperty upperBoundProperty();

    default public StringConverter<Number> getTickLabelFormatter() {
        if (this.tickLabelFormatterProperty() != null) {
            return (StringConverter)this.tickLabelFormatterProperty().getValue();
        }
        return null;
    }

    default public void setTickLabelFormatter(StringConverter<Number> value) {
        if (this.tickLabelFormatterProperty() != null) {
            this.tickLabelFormatterProperty().setValue(value);
        }
    }

    public ObjectProperty<StringConverter<Number>> tickLabelFormatterProperty();

    default public double getMinorTickLength() {
        if (this.minorTickLengthProperty() != null) {
            return this.minorTickLengthProperty().get();
        }
        return Double.NaN;
    }

    default public void setMinorTickLength(double value) {
        if (this.minorTickLengthProperty() != null) {
            this.minorTickLengthProperty().set(value);
        }
    }

    public DoubleProperty minorTickLengthProperty();

    default public int getMinorTickCount() {
        return this.minorTickCountProperty().get();
    }

    default public void setMinorTickCount(int value) {
        this.minorTickCountProperty().set(value);
    }

    public IntegerProperty minorTickCountProperty();

    default public String getLabel() {
        if (this.labelProperty() != null) {
            return (String)this.labelProperty().get();
        }
        return null;
    }

    default public void setLabel(String value) {
        if (this.labelProperty() != null) {
            this.labelProperty().set((Object)value);
        }
    }

    public ObjectProperty<String> labelProperty();

    default public boolean isTickMarkVisible() {
        if (this.tickMarkVisibleProperty() != null) {
            return this.tickMarkVisibleProperty().get();
        }
        return false;
    }

    default public void setTickMarkVisible(boolean value) {
        if (this.tickMarkVisibleProperty() != null) {
            this.tickMarkVisibleProperty().set(value);
        }
    }

    public BooleanProperty tickMarkVisibleProperty();

    default public boolean isTickLabelsVisible() {
        if (this.tickLabelsVisibleProperty() != null) {
            return this.tickLabelsVisibleProperty().get();
        }
        return false;
    }

    default public void setTickLabelsVisible(boolean value) {
        if (this.tickLabelsVisibleProperty() != null) {
            this.tickLabelsVisibleProperty().set(value);
        }
    }

    default public double getTickLength() {
        if (this.tickLengthProperty() != null) {
            return this.tickLengthProperty().get();
        }
        return Double.NaN;
    }

    default public void setTickLength(double value) {
        if (this.tickLengthProperty() != null) {
            this.tickLengthProperty().set(value);
        }
    }

    public DoubleProperty tickLengthProperty();

    public BooleanProperty tickLabelsVisibleProperty();

    default public Font getTickLabelFont() {
        if (this.tickLabelFontProperty() != null) {
            return (Font)this.tickLabelFontProperty().get();
        }
        return null;
    }

    default public void setTickLabelFont(Font value) {
        if (this.tickLabelFontProperty() != null) {
            this.tickLabelFontProperty().set((Object)value);
        }
    }

    public ObjectProperty<Font> tickLabelFontProperty();

    default public Paint getTickLabelFill() {
        if (this.tickLabelFillProperty() != null) {
            return (Paint)this.tickLabelFillProperty().get();
        }
        return null;
    }

    default public void setTickLabelFill(Paint value) {
        if (this.tickLabelFillProperty() != null) {
            this.tickLabelFillProperty().set((Object)value);
        }
    }

    public ObjectProperty<Paint> tickLabelFillProperty();

    default public double getTickLabelGap() {
        if (this.tickLabelGapProperty() != null) {
            return this.tickLabelGapProperty().get();
        }
        return Double.NaN;
    }

    default public void setTickLabelGap(double value) {
        if (this.tickLabelGapProperty() != null) {
            this.tickLabelGapProperty().set(value);
        }
    }

    public DoubleProperty tickLabelGapProperty();

    default public boolean getAnimated() {
        if (this.animatedProperty() != null) {
            return this.animatedProperty().get();
        }
        return false;
    }

    default public void setAnimated(boolean value) {
        if (this.animatedProperty() != null) {
            this.animatedProperty().set(value);
        }
    }

    public BooleanProperty animatedProperty();

    default public double getTickLabelRotation() {
        if (this.tickLabelRotationProperty() != null) {
            return this.tickLabelRotationProperty().getValue();
        }
        return Double.NaN;
    }

    default public void setTickLabelRotation(double value) {
        if (this.tickLabelRotationProperty() != null) {
            this.tickLabelRotationProperty().setValue((Number)value);
        }
    }

    public DoubleProperty tickLabelRotationProperty();

    public void setEffectiveOrientation(Orientation var1);

    public static FastAxisBase wrap(final NumberAxis numberAxis) {
        return new FastAxisBase(){

            @Override
            public Region asRegion() {
                return numberAxis;
            }

            @Override
            public void requestAxisLayout() {
                numberAxis.requestAxisLayout();
            }

            @Override
            public ObjectProperty<Side> sideProperty() {
                return numberAxis.sideProperty();
            }

            @Override
            public BooleanProperty autoRangingProperty() {
                return numberAxis.autoRangingProperty();
            }

            @Override
            public void invalidateRange(List<Number> data) {
                numberAxis.invalidateRange(data);
            }

            @Override
            public DoubleProperty lowerBoundProperty() {
                return numberAxis.lowerBoundProperty();
            }

            @Override
            public DoubleProperty upperBoundProperty() {
                return numberAxis.upperBoundProperty();
            }

            @Override
            public double getDisplayPosition(double value) {
                return numberAxis.getDisplayPosition((Number)value);
            }

            @Override
            public double getValueForDisplay(double displayPosition) {
                Number valueForDisplay = numberAxis.getValueForDisplay(displayPosition);
                return valueForDisplay.doubleValue();
            }

            @Override
            public void setForceZeroInRange(boolean value) {
                numberAxis.setForceZeroInRange(value);
            }

            @Override
            public DoubleProperty tickUnitProperty() {
                return numberAxis.tickUnitProperty();
            }

            @Override
            public BooleanProperty minorTickVisibleProperty() {
                return numberAxis.minorTickVisibleProperty();
            }

            @Override
            public ReadOnlyDoubleProperty scaleProperty() {
                return numberAxis.scaleProperty();
            }

            @Override
            public ObjectProperty<StringConverter<Number>> tickLabelFormatterProperty() {
                return numberAxis.tickLabelFormatterProperty();
            }

            @Override
            public DoubleProperty minorTickLengthProperty() {
                return numberAxis.minorTickLengthProperty();
            }

            @Override
            public IntegerProperty minorTickCountProperty() {
                return numberAxis.minorTickCountProperty();
            }

            @Override
            public ObjectProperty<String> labelProperty() {
                return numberAxis.labelProperty();
            }

            @Override
            public BooleanProperty tickMarkVisibleProperty() {
                return numberAxis.tickMarkVisibleProperty();
            }

            @Override
            public DoubleProperty tickLengthProperty() {
                return numberAxis.tickLengthProperty();
            }

            @Override
            public BooleanProperty tickLabelsVisibleProperty() {
                return numberAxis.tickLabelsVisibleProperty();
            }

            @Override
            public ObjectProperty<Font> tickLabelFontProperty() {
                return numberAxis.tickLabelFontProperty();
            }

            @Override
            public ObjectProperty<Paint> tickLabelFillProperty() {
                return numberAxis.tickLabelFillProperty();
            }

            @Override
            public DoubleProperty tickLabelGapProperty() {
                return numberAxis.tickLabelGapProperty();
            }

            @Override
            public BooleanProperty animatedProperty() {
                return numberAxis.animatedProperty();
            }

            @Override
            public DoubleProperty tickLabelRotationProperty() {
                return numberAxis.tickLabelRotationProperty();
            }

            @Override
            public void setEffectiveOrientation(Orientation orientation) {
                numberAxis.setEffectiveOrientation(orientation);
            }
        };
    }
}

