/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXExtensions.control;

import javafx.beans.NamedArg;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;
import javafx.util.converter.LongStringConverter;

public class LongSpinnerValueFactory
extends SpinnerValueFactory<Long> {
    private LongProperty min = new SimpleLongProperty((Object)this, "min"){

        protected void invalidated() {
            Long currentValue = (Long)LongSpinnerValueFactory.this.getValue();
            if (currentValue == null) {
                return;
            }
            long newMin = this.get();
            if (newMin > LongSpinnerValueFactory.this.getMax()) {
                LongSpinnerValueFactory.this.setMin(LongSpinnerValueFactory.this.getMax());
                return;
            }
            if (currentValue < newMin) {
                LongSpinnerValueFactory.this.setValue(newMin);
            }
        }
    };
    private LongProperty max = new SimpleLongProperty((Object)this, "max"){

        protected void invalidated() {
            Long currentValue = (Long)LongSpinnerValueFactory.this.getValue();
            if (currentValue == null) {
                return;
            }
            long newMax = this.get();
            if (newMax < LongSpinnerValueFactory.this.getMin()) {
                LongSpinnerValueFactory.this.setMax(LongSpinnerValueFactory.this.getMin());
                return;
            }
            if (currentValue > newMax) {
                LongSpinnerValueFactory.this.setValue(newMax);
            }
        }
    };
    private LongProperty amountToStepBy = new SimpleLongProperty((Object)this, "amountToStepBy");

    public LongSpinnerValueFactory(@NamedArg(value="min") long min, @NamedArg(value="max") long max) {
        this(min, max, min);
    }

    public LongSpinnerValueFactory(@NamedArg(value="min") long min, @NamedArg(value="max") long max, @NamedArg(value="initialValue") long initialValue) {
        this(min, max, initialValue, 1L);
    }

    public LongSpinnerValueFactory(@NamedArg(value="min") long min, @NamedArg(value="max") long max, @NamedArg(value="initialValue") long initialValue, @NamedArg(value="amountToStepBy") long amountToStepBy) {
        this.setMin(min);
        this.setMax(max);
        this.setAmountToStepBy(amountToStepBy);
        this.setConverter((StringConverter)new LongStringConverter());
        this.valueProperty().addListener((o, oldValue, newValue) -> {
            if (newValue < this.getMin()) {
                this.setValue(this.getMin());
            } else if (newValue > this.getMax()) {
                this.setValue(this.getMax());
            }
        });
        this.setValue(initialValue >= min && initialValue <= max ? initialValue : min);
    }

    public final void setMin(long value) {
        this.min.set(value);
    }

    public final long getMin() {
        return this.min.get();
    }

    public final LongProperty minProperty() {
        return this.min;
    }

    public final void setMax(long value) {
        this.max.set(value);
    }

    public final long getMax() {
        return this.max.get();
    }

    public final LongProperty maxProperty() {
        return this.max;
    }

    public final void setAmountToStepBy(long value) {
        this.amountToStepBy.set(value);
    }

    public final long getAmountToStepBy() {
        return this.amountToStepBy.get();
    }

    public final LongProperty amountToStepByProperty() {
        return this.amountToStepBy;
    }

    public void decrement(int steps) {
        long min = this.getMin();
        long max = this.getMax();
        long newIndex = (Long)this.getValue() - (long)steps * this.getAmountToStepBy();
        this.setValue(newIndex >= min ? newIndex : (this.isWrapAround() ? LongSpinnerValueFactory.wrapValue(newIndex, min, max) + 1L : min));
    }

    public void increment(int steps) {
        long min = this.getMin();
        long max = this.getMax();
        long currentValue = (Long)this.getValue();
        long newIndex = currentValue + (long)steps * this.getAmountToStepBy();
        this.setValue(newIndex <= max ? newIndex : (this.isWrapAround() ? LongSpinnerValueFactory.wrapValue(newIndex, min, max) - 1L : max));
    }

    static long wrapValue(long value, long min, long max) {
        if (max == 0L) {
            throw new RuntimeException();
        }
        long r = value % max;
        if (r > min && max < min) {
            r = r + max - min;
        } else if (r < min && max > min) {
            r = r + max - min;
        }
        return r;
    }
}

