/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.layout.Region;

public class InvisibleNumberAxis
extends Region {
    private Orientation effectiveOrientation;
    private double oldLength = 0.0;
    boolean rangeValid = false;
    private ObjectProperty<Side> side = new StyleableObjectProperty<Side>(){

        protected void invalidated() {
            Side edge = (Side)this.get();
            InvisibleNumberAxis.this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, edge == Side.TOP);
            InvisibleNumberAxis.this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, edge == Side.RIGHT);
            InvisibleNumberAxis.this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, edge == Side.BOTTOM);
            InvisibleNumberAxis.this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, edge == Side.LEFT);
            InvisibleNumberAxis.this.requestAxisLayout();
        }

        public CssMetaData<InvisibleNumberAxis, Side> getCssMetaData() {
            return StyleableProperties.SIDE;
        }

        public Object getBean() {
            return InvisibleNumberAxis.this;
        }

        public String getName() {
            return "side";
        }
    };
    private BooleanProperty autoRanging = new BooleanPropertyBase(true){

        protected void invalidated() {
            if (this.get()) {
                InvisibleNumberAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return InvisibleNumberAxis.this;
        }

        public String getName() {
            return "autoRanging";
        }
    };
    private double offset;
    double dataMinValue;
    double dataMaxValue;
    private ReadOnlyDoubleWrapper scale = new ReadOnlyDoubleWrapper((Object)this, "scale", 0.0){

        protected void invalidated() {
            InvisibleNumberAxis.this.requestAxisLayout();
        }
    };
    private DoubleProperty upperBound = new DoublePropertyBase(100.0){

        protected void invalidated() {
            if (!InvisibleNumberAxis.this.isAutoRanging()) {
                InvisibleNumberAxis.this.invalidateRange();
                InvisibleNumberAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return InvisibleNumberAxis.this;
        }

        public String getName() {
            return "upperBound";
        }
    };
    private DoubleProperty lowerBound = new DoublePropertyBase(0.0){

        protected void invalidated() {
            if (!InvisibleNumberAxis.this.isAutoRanging()) {
                InvisibleNumberAxis.this.invalidateRange();
                InvisibleNumberAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return InvisibleNumberAxis.this;
        }

        public String getName() {
            return "lowerBound";
        }
    };
    private DoubleProperty rangePadding = new SimpleDoubleProperty((Object)this, "rangePadding", 0.05){

        protected void invalidated() {
            InvisibleNumberAxis.this.invalidateRange();
            InvisibleNumberAxis.this.requestAxisLayout();
        }
    };
    private BooleanProperty forceZeroInRange = new BooleanPropertyBase(true){

        protected void invalidated() {
            if (InvisibleNumberAxis.this.isAutoRanging()) {
                InvisibleNumberAxis.this.requestAxisLayout();
                InvisibleNumberAxis.this.invalidateRange();
            }
        }

        public Object getBean() {
            return InvisibleNumberAxis.this;
        }

        public String getName() {
            return "forceZeroInRange";
        }
    };
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass((String)"right");

    public final Side getSide() {
        return (Side)this.side.get();
    }

    public final void setSide(Side value) {
        this.side.set((Object)value);
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    private final Side getEffectiveSide() {
        Side side = this.getSide();
        if (side == null || side.isVertical() && this.effectiveOrientation == Orientation.HORIZONTAL || side.isHorizontal() && this.effectiveOrientation == Orientation.VERTICAL) {
            return this.effectiveOrientation == Orientation.VERTICAL ? Side.LEFT : Side.BOTTOM;
        }
        return side;
    }

    public final boolean isAutoRanging() {
        return this.autoRanging.get();
    }

    public final void setAutoRanging(boolean value) {
        this.autoRanging.set(value);
    }

    public final BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    private final boolean isRangeValid() {
        return this.rangeValid;
    }

    private final void invalidateRange() {
        this.rangeValid = false;
    }

    public void requestLayout() {
    }

    public void requestAxisLayout() {
        super.requestLayout();
    }

    protected double computePrefHeight(double width) {
        Side side = this.getEffectiveSide();
        if (side.isVertical()) {
            return 100.0;
        }
        return 0.0;
    }

    protected double computePrefWidth(double height) {
        Side side = this.getEffectiveSide();
        if (side.isVertical()) {
            return 0.0;
        }
        return 100.0;
    }

    public final double getScale() {
        return this.scale.get();
    }

    private final void setScale(double scale) {
        this.scale.set(scale);
    }

    public final ReadOnlyDoubleProperty scaleProperty() {
        return this.scale.getReadOnlyProperty();
    }

    public final double getUpperBound() {
        return this.upperBound.get();
    }

    public final void setUpperBound(double value) {
        this.upperBound.set(value);
    }

    public final DoubleProperty upperBoundProperty() {
        return this.upperBound;
    }

    public final double getLowerBound() {
        return this.lowerBound.get();
    }

    public final void setLowerBound(double value) {
        this.lowerBound.set(value);
    }

    public final DoubleProperty lowerBoundProperty() {
        return this.lowerBound;
    }

    private final double calculateNewScale(double length, double lowerBound, double upperBound) {
        double newScale = 1.0;
        Side side = this.getEffectiveSide();
        if (side.isVertical()) {
            this.offset = length;
            newScale = upperBound - lowerBound == 0.0 ? -length : -(length / (upperBound - lowerBound));
        } else {
            this.offset = 0.0;
            newScale = upperBound - lowerBound == 0.0 ? length : length / (upperBound - lowerBound);
        }
        return newScale;
    }

    protected void layoutChildren() {
        boolean lengthDiffers;
        double length;
        Side side = this.getEffectiveSide();
        double d = length = side.isVertical() ? this.getHeight() : this.getWidth();
        if (!this.isAutoRanging()) {
            this.setScale(this.calculateNewScale(length, this.getLowerBound(), this.getUpperBound()));
        }
        boolean rangeInvalid = !this.isRangeValid();
        boolean bl = lengthDiffers = this.oldLength != length;
        if (lengthDiffers || rangeInvalid) {
            if (this.isAutoRanging()) {
                this.autoRange(this.dataMinValue, this.dataMaxValue, length);
            }
            this.oldLength = length;
            this.rangeValid = true;
        }
    }

    public void invalidateRange(List<Number> data) {
        if (data.isEmpty()) {
            this.dataMaxValue = this.getUpperBound();
            this.dataMinValue = this.getLowerBound();
        } else {
            this.dataMinValue = Double.MAX_VALUE;
            this.dataMaxValue = -1.7976931348623157E308;
        }
        for (Number dataValue : data) {
            this.dataMinValue = Math.min(this.dataMinValue, dataValue.doubleValue());
            this.dataMaxValue = Math.max(this.dataMaxValue, dataValue.doubleValue());
        }
        this.invalidateRange();
        this.requestAxisLayout();
    }

    public void invalidateRange(double[] data) {
        if (data.length == 0) {
            this.dataMaxValue = this.getUpperBound();
            this.dataMinValue = this.getLowerBound();
        } else {
            this.dataMinValue = Double.MAX_VALUE;
            this.dataMaxValue = -1.7976931348623157E308;
        }
        for (double dataValue : data) {
            this.dataMinValue = Math.min(this.dataMinValue, dataValue);
            this.dataMaxValue = Math.max(this.dataMaxValue, dataValue);
        }
        this.invalidateRange();
        this.requestAxisLayout();
    }

    public void invalidateRange(double minValue, double maxValue) {
        this.dataMinValue = minValue;
        this.dataMaxValue = maxValue;
        this.invalidateRange();
        this.requestAxisLayout();
    }

    public double getDisplayPosition(double value) {
        return this.offset + (value - this.lowerBound.get()) * this.getScale();
    }

    public double getValueForDisplay(double displayPosition) {
        return (displayPosition - this.offset) / this.getScale() + this.lowerBound.get();
    }

    public double getZeroPosition() {
        if (0.0 < this.getLowerBound() || 0.0 > this.getUpperBound()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    public boolean isValueOnAxis(double value) {
        return value >= this.getLowerBound() && value <= this.getUpperBound();
    }

    public double getRangePadding() {
        return this.rangePadding.get();
    }

    public void setRangePadding(double rangePadding) {
        this.rangePadding.set(rangePadding);
    }

    public DoubleProperty rangePaddingProperty() {
        return this.rangePadding;
    }

    public final boolean isForceZeroInRange() {
        return this.forceZeroInRange.getValue();
    }

    public final void setForceZeroInRange(boolean value) {
        this.forceZeroInRange.setValue(Boolean.valueOf(value));
    }

    public final BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    public InvisibleNumberAxis() {
        this.getStyleClass().setAll((Object[])new String[]{"axis"});
    }

    public InvisibleNumberAxis(double lowerBound, double upperBound, double tickUnit) {
        this();
        this.setAutoRanging(false);
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
    }

    private void autoRange(double minValue, double maxValue, double length) {
        double range;
        if (this.isForceZeroInRange()) {
            if (maxValue < 0.0) {
                maxValue = 0.0;
            } else if (minValue > 0.0) {
                minValue = 0.0;
            }
        }
        if ((range = maxValue - minValue) != 0.0 && range / 2.0 <= Math.ulp(minValue)) {
            range = 0.0;
        }
        double paddedRange = range == 0.0 ? (minValue == 0.0 ? this.getRangePadding() : Math.abs(minValue) * this.getRangePadding()) : Math.abs(range) * (1.0 + this.getRangePadding());
        double padding = (paddedRange - range) / 2.0;
        double paddedMin = minValue - padding;
        double paddedMax = maxValue + padding;
        this.setLowerBound(paddedMin);
        this.setUpperBound(paddedMax);
        this.setScale(this.calculateNewScale(length, paddedMin, paddedMax));
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return InvisibleNumberAxis.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<InvisibleNumberAxis, Side> SIDE = new CssMetaData<InvisibleNumberAxis, Side>("-fx-side", (StyleConverter)new EnumConverter(Side.class)){

            public boolean isSettable(InvisibleNumberAxis n) {
                return n.side == null || !n.side.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(InvisibleNumberAxis n) {
                return (StyleableProperty)n.sideProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<InvisibleNumberAxis, Side>> styleables = new ArrayList<CssMetaData<InvisibleNumberAxis, Side>>(Region.getClassCssMetaData());
            styleables.add(SIDE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

