/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXExtensions.raycast;

import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.DepthTest;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.input.PickResult;
import javafx.scene.shape.Box;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.ObservableFaceArray;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.exceptions.SingularMatrixException;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class CustomPickRayTools {
    private static final double ONE_THIRD = 0.3333333333333333;
    private static final double EPSILON_ABSOLUTE = 1.0E-5;

    public static PickResult pick(double xScene, double yScene, double widthScene, double heightScene, PerspectiveCamera camera, Node root) {
        CustomPickRay pickRay = CustomPickRayTools.computePickRay(xScene, yScene, widthScene, heightScene, camera, null);
        pickRay.direction.normalize();
        CustomPickResultChooser result = new CustomPickResultChooser();
        CustomPickRayTools.pickNode(root, pickRay, result);
        return result.toPickResult();
    }

    public static CustomPickRay computePickRay(double xScene, double yScene, double widthScene, double heightScene, PerspectiveCamera camera, CustomPickRay pickRay) {
        return CustomPickRayTools.computePerspectivePickRay(xScene, yScene, widthScene, heightScene, camera.isFixedEyeAtCameraZero(), Math.toRadians(camera.getFieldOfView()), camera.isVerticalFieldOfView(), camera.getLocalToSceneTransform(), camera.getNearClip(), camera.getFarClip(), pickRay);
    }

    public static CustomPickRay computePerspectivePickRay(double xScene, double yScene, double widthScene, double heightScene, boolean fixedEye, double fieldOfViewRadians, boolean verticalFieldOfView, Transform cameraTransform, double nearClip, double farClip, CustomPickRay pickRay) {
        if (pickRay == null) {
            pickRay = new CustomPickRay();
        }
        Vector3D direction = pickRay.direction;
        double halfViewWidth = widthScene / 2.0;
        double halfViewHeight = heightScene / 2.0;
        double halfViewDim = verticalFieldOfView ? halfViewHeight : halfViewWidth;
        double distanceZ = halfViewDim / Math.tan(fieldOfViewRadians / 2.0);
        direction.set(xScene - halfViewWidth, yScene - halfViewHeight, distanceZ);
        us.ihmc.euclid.tuple3D.Point3D eye = pickRay.origin;
        if (fixedEye) {
            eye.setToZero();
        } else {
            eye.set(halfViewWidth, halfViewHeight, -distanceZ);
        }
        double clipScale = direction.length() / (fixedEye ? distanceZ : 1.0);
        pickRay.nearClip = nearClip * clipScale;
        pickRay.farClip = farClip * clipScale;
        pickRay.applyTransform(cameraTransform);
        return pickRay;
    }

    public static void pickNode(Node node, CustomPickRay pickRay, CustomPickResultChooser result) {
        if (!node.isVisible() || node.isDisable() || node.isMouseTransparent()) {
            return;
        }
        us.ihmc.euclid.tuple3D.Point3D o = pickRay.origin;
        double ox = o.getX();
        double oy = o.getY();
        double oz = o.getZ();
        Vector3D d = pickRay.direction;
        double dx = d.getX();
        double dy = d.getY();
        double dz = d.getZ();
        Transform localToParentTransform = node.getLocalToParentTransform();
        try {
            CustomPickRayTools.inverseTransform(localToParentTransform, (Point3DBasics)o);
            CustomPickRayTools.inverseTransform(localToParentTransform, (Vector3DBasics)d);
            CustomPickRayTools.pickNodeLocal(node, pickRay, result);
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        o.set(ox, oy, oz);
        d.set(dx, dy, dz);
    }

    public static void pickNodeLocal(Node node, CustomPickRay pickRay, CustomPickResultChooser pickResult) {
        if (node instanceof Parent) {
            CustomPickRayTools.pickNodeLocal((Parent)node, pickRay, pickResult);
        } else {
            CustomPickRayTools.intersects(node, pickRay, pickResult);
        }
    }

    public static void pickNodeLocal(Parent node, CustomPickRay pickRay, CustomPickResultChooser pickResult) {
        double boundsDistance = CustomPickRayTools.intersectsBounds((Node)node, pickRay);
        if (!Double.isNaN(boundsDistance)) {
            ObservableList children = node.getChildrenUnmodifiable();
            for (int i = children.size() - 1; i >= 0; --i) {
                CustomPickRayTools.pickNode((Node)children.get(i), pickRay, pickResult);
                if (!pickResult.isClosed()) continue;
                return;
            }
            if (node.isPickOnBounds()) {
                pickResult.offer((Node)node, boundsDistance, CustomPickResultChooser.computePoint(pickRay, boundsDistance));
            }
        }
    }

    public static boolean intersects(Node node, CustomPickRay pickRay, CustomPickResultChooser pickResult) {
        double boundsDistance = CustomPickRayTools.intersectsBounds(node, pickRay);
        if (!Double.isNaN(boundsDistance)) {
            if (node.isPickOnBounds()) {
                if (pickResult != null) {
                    pickResult.offer(node, boundsDistance, CustomPickResultChooser.computePoint(pickRay, boundsDistance));
                }
                return true;
            }
            return CustomPickRayTools.computeIntersects(node, pickRay, pickResult);
        }
        return false;
    }

    @Deprecated
    public static boolean computeIntersects(Node node, CustomPickRay pickRay, CustomPickResultChooser pickResult) {
        double y;
        MeshView meshView;
        if (node instanceof MeshView && (meshView = (MeshView)node).getMesh() instanceof TriangleMesh) {
            return CustomPickRayTools.computeIntersects((TriangleMesh)meshView.getMesh(), pickRay, pickResult, (Node)meshView, meshView.getCullFace(), true);
        }
        if (node instanceof Box) {
            return CustomPickRayTools.computeIntersects((Box)node, pickRay, pickResult);
        }
        if (node instanceof Sphere) {
            return CustomPickRayTools.computeIntersects((Sphere)node, pickRay, pickResult);
        }
        if (node instanceof Cylinder) {
            return CustomPickRayTools.computeIntersects((Cylinder)node, pickRay, pickResult);
        }
        double origZ = pickRay.origin.getZ();
        double dirZ = pickRay.direction.getZ();
        if (CustomPickRayTools.almostZero(dirZ)) {
            return false;
        }
        double t = -origZ / dirZ;
        if (t < pickRay.nearClip || t > pickRay.farClip) {
            return false;
        }
        double x = pickRay.origin.getX() + pickRay.direction.getX() * t;
        if (node.contains((double)((float)x), (double)((float)(y = pickRay.origin.getY() + pickRay.direction.getY() * t)))) {
            if (pickResult != null) {
                pickResult.offer(node, t, CustomPickResultChooser.computePoint(pickRay, t));
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean computeIntersects(Sphere node, CustomPickRay pickRay, CustomPickResultChooser pickResult) {
        double t1;
        double c;
        double a;
        double originZ;
        double originY;
        double r = node.getRadius();
        Vector3D dir = pickRay.direction;
        double dirX = dir.getX();
        double dirY = dir.getY();
        double dirZ = dir.getZ();
        us.ihmc.euclid.tuple3D.Point3D origin = pickRay.origin;
        double originX = origin.getX();
        double b = 2.0 * (dirX * originX + dirY * (originY = origin.getY()) + dirZ * (originZ = origin.getZ()));
        double discriminant = b * b - 4.0 * (a = dirX * dirX + dirY * dirY + dirZ * dirZ) * (c = originX * originX + originY * originY + originZ * originZ - r * r);
        if (discriminant < 0.0) {
            return false;
        }
        double distSqrt = Math.sqrt(discriminant);
        double q = b < 0.0 ? (-b - distSqrt) / 2.0 : (-b + distSqrt) / 2.0;
        double t0 = q / a;
        if (t0 > (t1 = c / q)) {
            double temp = t0;
            t0 = t1;
            t1 = temp;
        }
        double minDistance = pickRay.nearClip;
        double maxDistance = pickRay.farClip;
        if (t1 < minDistance || t0 > maxDistance) {
            return false;
        }
        double t = t0;
        CullFace cullFace = node.getCullFace();
        if (t0 < minDistance || cullFace == CullFace.FRONT) {
            if (t1 <= maxDistance && node.getCullFace() != CullFace.BACK) {
                t = t1;
            } else {
                return false;
            }
        }
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return false;
        }
        if (pickResult != null && pickResult.isCloser(t)) {
            Point3D point = CustomPickResultChooser.computePoint(pickRay, t);
            Point3D proj = new Point3D(point.getX(), 0.0, point.getZ());
            Point3D cross = proj.crossProduct(Rotate.Z_AXIS);
            double angle = proj.angle(Rotate.Z_AXIS);
            if (cross.getY() > 0.0) {
                angle = 360.0 - angle;
            }
            Point2D txtCoords = new Point2D(1.0 - angle / 360.0, 0.5 + point.getY() / (2.0 * r));
            pickResult.offer((Node)node, t, -1, point, txtCoords);
        }
        return true;
    }

    @Deprecated
    public static boolean computeIntersects(Cylinder node, CustomPickRay pickRay, CustomPickResultChooser pickResult) {
        double tZ;
        double tX;
        double t1;
        double t0;
        double r = node.getRadius();
        Vector3D dir = pickRay.direction;
        double dirX = dir.getX();
        double dirY = dir.getY();
        double dirZ = dir.getZ();
        us.ihmc.euclid.tuple3D.Point3D origin = pickRay.origin;
        double originX = origin.getX();
        double originY = origin.getY();
        double originZ = origin.getZ();
        double h = node.getHeight();
        double halfHeight = h / 2.0;
        CullFace cullFace = node.getCullFace();
        double a = dirX * dirX + dirZ * dirZ;
        double b = 2.0 * (dirX * originX + dirZ * originZ);
        double c = originX * originX + originZ * originZ - r * r;
        double discriminant = b * b - 4.0 * a * c;
        double t = Double.POSITIVE_INFINITY;
        double minDistance = pickRay.nearClip;
        double maxDistance = pickRay.farClip;
        if (discriminant >= 0.0 && (dirX != 0.0 || dirZ != 0.0)) {
            double distSqrt = Math.sqrt(discriminant);
            double q = b < 0.0 ? (-b - distSqrt) / 2.0 : (-b + distSqrt) / 2.0;
            t0 = q / a;
            if (t0 > (t1 = c / q)) {
                double temp = t0;
                t0 = t1;
                t1 = temp;
            }
            double y0 = originY + t0 * dirY;
            if (t0 < minDistance || y0 < -halfHeight || y0 > halfHeight || cullFace == CullFace.FRONT) {
                double y1 = originY + t1 * dirY;
                if (t1 >= minDistance && t1 <= maxDistance && y1 >= -halfHeight && y1 <= halfHeight && cullFace != CullFace.BACK) {
                    t = t1;
                }
            } else if (t0 <= maxDistance) {
                t = t0;
            }
        }
        boolean topCap = false;
        boolean bottomCap = false;
        double tBottom = (-halfHeight - originY) / dirY;
        double tTop = (halfHeight - originY) / dirY;
        boolean isT0Bottom = false;
        if (tBottom < tTop) {
            t0 = tBottom;
            t1 = tTop;
            isT0Bottom = true;
        } else {
            t0 = tTop;
            t1 = tBottom;
        }
        if (t0 >= minDistance && t0 <= maxDistance && t0 < t && cullFace != CullFace.FRONT && (tX = originX + dirX * t0) * tX + (tZ = originZ + dirZ * t0) * tZ <= r * r) {
            bottomCap = isT0Bottom;
            topCap = !isT0Bottom;
            t = t0;
        }
        if (t1 >= minDistance && t1 <= maxDistance && t1 < t && cullFace != CullFace.BACK && (tX = originX + dirX * t1) * tX + (tZ = originZ + dirZ * t1) * tZ <= r * r) {
            topCap = isT0Bottom;
            bottomCap = !isT0Bottom;
            t = t1;
        }
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return false;
        }
        if (pickResult != null && pickResult.isCloser(t)) {
            Point2D txCoords;
            Point3D point = CustomPickResultChooser.computePoint(pickRay, t);
            if (topCap) {
                txCoords = new Point2D(0.5 + point.getX() / (2.0 * r), 0.5 + point.getZ() / (2.0 * r));
            } else if (bottomCap) {
                txCoords = new Point2D(0.5 + point.getX() / (2.0 * r), 0.5 - point.getZ() / (2.0 * r));
            } else {
                Point3D proj = new Point3D(point.getX(), 0.0, point.getZ());
                Point3D cross = proj.crossProduct(Rotate.Z_AXIS);
                double angle = proj.angle(Rotate.Z_AXIS);
                if (cross.getY() > 0.0) {
                    angle = 360.0 - angle;
                }
                txCoords = new Point2D(1.0 - angle / 360.0, 0.5 + point.getY() / h);
            }
            pickResult.offer((Node)node, t, -1, point, txCoords);
        }
        return true;
    }

    @Deprecated
    public static boolean computeIntersects(Box node, CustomPickRay pickRay, CustomPickResultChooser pickResult) {
        double w = node.getWidth();
        double h = node.getHeight();
        double d = node.getDepth();
        double hWidth = w / 2.0;
        double hHeight = h / 2.0;
        double hDepth = d / 2.0;
        Vector3D dir = pickRay.direction;
        double invDirX = dir.getX() == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.getX();
        double invDirY = dir.getY() == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.getY();
        double invDirZ = dir.getZ() == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.getZ();
        us.ihmc.euclid.tuple3D.Point3D origin = pickRay.origin;
        double originX = origin.getX();
        double originY = origin.getY();
        double originZ = origin.getZ();
        boolean signX = invDirX < 0.0;
        boolean signY = invDirY < 0.0;
        boolean signZ = invDirZ < 0.0;
        double t0 = Double.NEGATIVE_INFINITY;
        double t1 = Double.POSITIVE_INFINITY;
        int side0 = 48;
        int side1 = 48;
        if (Double.isInfinite(invDirX)) {
            if (!(-hWidth <= originX) || !(hWidth >= originX)) {
                return false;
            }
        } else {
            t0 = ((signX ? hWidth : -hWidth) - originX) * invDirX;
            t1 = ((signX ? -hWidth : hWidth) - originX) * invDirX;
            side0 = signX ? 88 : 120;
            int n = side1 = signX ? 120 : 88;
        }
        if (Double.isInfinite(invDirY)) {
            if (!(-hHeight <= originY) || !(hHeight >= originY)) {
                return false;
            }
        } else {
            double ty0 = ((signY ? hHeight : -hHeight) - originY) * invDirY;
            double ty1 = ((signY ? -hHeight : hHeight) - originY) * invDirY;
            if (t0 > ty1 || ty0 > t1) {
                return false;
            }
            if (ty0 > t0) {
                side0 = signY ? 89 : 121;
                t0 = ty0;
            }
            if (ty1 < t1) {
                side1 = signY ? 121 : 89;
                t1 = ty1;
            }
        }
        if (Double.isInfinite(invDirZ)) {
            if (!(-hDepth <= originZ) || !(hDepth >= originZ)) {
                return false;
            }
        } else {
            double tz0 = ((signZ ? hDepth : -hDepth) - originZ) * invDirZ;
            double tz1 = ((signZ ? -hDepth : hDepth) - originZ) * invDirZ;
            if (t0 > tz1 || tz0 > t1) {
                return false;
            }
            if (tz0 > t0) {
                side0 = signZ ? 90 : 122;
                t0 = tz0;
            }
            if (tz1 < t1) {
                side1 = signZ ? 122 : 90;
                t1 = tz1;
            }
        }
        int side = side0;
        double t = t0;
        CullFace cullFace = node.getCullFace();
        double minDistance = pickRay.nearClip;
        double maxDistance = pickRay.farClip;
        if (t0 > maxDistance) {
            return false;
        }
        if (t0 < minDistance || cullFace == CullFace.FRONT) {
            if (t1 >= minDistance && t1 <= maxDistance && cullFace != CullFace.BACK) {
                side = side1;
                t = t1;
            } else {
                return false;
            }
        }
        if (Double.isInfinite(t) || Double.isNaN(t)) {
            return false;
        }
        if (pickResult != null && pickResult.isCloser(t)) {
            Point3D point = CustomPickResultChooser.computePoint(pickRay, t);
            Point2D txtCoords = null;
            switch (side) {
                case 120: {
                    txtCoords = new Point2D(0.5 - point.getZ() / d, 0.5 + point.getY() / h);
                    break;
                }
                case 88: {
                    txtCoords = new Point2D(0.5 + point.getZ() / d, 0.5 + point.getY() / h);
                    break;
                }
                case 121: {
                    txtCoords = new Point2D(0.5 + point.getX() / w, 0.5 - point.getZ() / d);
                    break;
                }
                case 89: {
                    txtCoords = new Point2D(0.5 + point.getX() / w, 0.5 + point.getZ() / d);
                    break;
                }
                case 122: {
                    txtCoords = new Point2D(0.5 + point.getX() / w, 0.5 + point.getY() / h);
                    break;
                }
                case 90: {
                    txtCoords = new Point2D(0.5 - point.getX() / w, 0.5 + point.getY() / h);
                    break;
                }
                default: {
                    return false;
                }
            }
            pickResult.offer((Node)node, t, -1, point, txtCoords);
        }
        return true;
    }

    @Deprecated
    public static boolean computeIntersects(TriangleMesh triangleMesh, CustomPickRay pickRay, CustomPickResultChooser pickResult, Node candidate, CullFace cullFace, boolean reportFace) {
        boolean found = false;
        int size = triangleMesh.getFaces().size();
        for (int i = 0; i < size; i += triangleMesh.getFaceElementSize()) {
            if (!CustomPickRayTools.computeIntersectsFace(triangleMesh, pickRay, i, cullFace, candidate, reportFace, pickResult)) continue;
            found = true;
        }
        return found;
    }

    public static boolean computeIntersectsFace(TriangleMesh triangleMesh, CustomPickRay pickRay, int faceIndex, CullFace cullFace, Node candidate, boolean reportFace, CustomPickResultChooser result) {
        double sz;
        double sy;
        double hz;
        double hy;
        us.ihmc.euclid.tuple3D.Point3D origin = pickRay.origin;
        Vector3D dir = pickRay.direction;
        int vertexIndexSize = triangleMesh.getVertexFormat().getVertexIndexSize();
        int pointElementSize = 3;
        ObservableFaceArray faces = triangleMesh.getFaces();
        int v0Idx = faces.get(faceIndex) * pointElementSize;
        int v1Idx = faces.get(faceIndex + vertexIndexSize) * pointElementSize;
        int v2Idx = faces.get(faceIndex + 2 * vertexIndexSize) * pointElementSize;
        ObservableFloatArray points = triangleMesh.getPoints();
        float v0x = points.get(v0Idx);
        float v0y = points.get(v0Idx + 1);
        float v0z = points.get(v0Idx + 2);
        float v1x = points.get(v1Idx);
        float v1y = points.get(v1Idx + 1);
        float v1z = points.get(v1Idx + 2);
        float v2x = points.get(v2Idx);
        float v2y = points.get(v2Idx + 1);
        float v2z = points.get(v2Idx + 2);
        float e1x = v1x - v0x;
        float e1y = v1y - v0y;
        float e1z = v1z - v0z;
        float e2x = v2x - v0x;
        float e2y = v2y - v0y;
        float e2z = v2z - v0z;
        double hx = dir.getY() * (double)e2z - dir.getZ() * (double)e2y;
        double a = (double)e1x * hx + (double)e1y * (hy = dir.getZ() * (double)e2x - dir.getX() * (double)e2z) + (double)e1z * (hz = dir.getX() * (double)e2y - dir.getY() * (double)e2x);
        if (a == 0.0) {
            return false;
        }
        double f = 1.0 / a;
        double sx = origin.getX() - (double)v0x;
        double u = f * (sx * hx + (sy = origin.getY() - (double)v0y) * hy + (sz = origin.getZ() - (double)v0z) * hz);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        double qx = sy * (double)e1z - sz * (double)e1y;
        double qy = sz * (double)e1x - sx * (double)e1z;
        double qz = sx * (double)e1y - sy * (double)e1x;
        double v = f * (dir.getX() * qx + dir.getY() * qy + dir.getZ() * qz);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = f * ((double)e2x * qx + (double)e2y * qy + (double)e2z * qz);
        if (t >= pickRay.nearClip && t <= pickRay.farClip) {
            Point3D ce2;
            Point3D normal;
            double nangle;
            if (cullFace != CullFace.NONE && ((nangle = (normal = new Point3D((double)(e1y * e2z - e1z * e2y), (double)(e1z * e2x - e1x * e2z), (double)(e1x * e2y - e1y * e2x))).angle(-dir.getX(), -dir.getY(), -dir.getZ())) >= 90.0 || cullFace != CullFace.BACK) && (nangle <= 90.0 || cullFace != CullFace.FRONT)) {
                return false;
            }
            if (Double.isInfinite(t) || Double.isNaN(t)) {
                return false;
            }
            if (result == null || !result.isCloser(t)) {
                return true;
            }
            Point3D point = CustomPickResultChooser.computePoint(pickRay, t);
            Point3D centroid = CustomPickRayTools.computeCentroid(v0x, v0y, v0z, v1x, v1y, v1z, v2x, v2y, v2z);
            Point3D cv0 = new Point3D((double)v0x - centroid.getX(), (double)v0y - centroid.getY(), (double)v0z - centroid.getZ());
            Point3D cv1 = new Point3D((double)v1x - centroid.getX(), (double)v1y - centroid.getY(), (double)v1z - centroid.getZ());
            Point3D cv2 = new Point3D((double)v2x - centroid.getX(), (double)v2y - centroid.getY(), (double)v2z - centroid.getZ());
            Point3D ce1 = cv1.subtract(cv0);
            Point3D n = ce1.crossProduct(ce2 = cv2.subtract(cv0));
            if (n.getZ() < 0.0) {
                n = new Point3D(-n.getX(), -n.getY(), -n.getZ());
            }
            Point3D ax = n.crossProduct(Rotate.Z_AXIS);
            double angle = Math.atan2(ax.magnitude(), n.dotProduct(Rotate.Z_AXIS));
            Rotate r = new Rotate(Math.toDegrees(angle), ax);
            Point3D crv0 = r.transform(cv0);
            Point3D crv1 = r.transform(cv1);
            Point3D crv2 = r.transform(cv2);
            Point3D rPoint = r.transform(point.subtract(centroid));
            Point2D flatV0 = new Point2D(crv0.getX(), crv0.getY());
            Point2D flatV1 = new Point2D(crv1.getX(), crv1.getY());
            Point2D flatV2 = new Point2D(crv2.getX(), crv2.getY());
            Point2D flatPoint = new Point2D(rPoint.getX(), rPoint.getY());
            int texCoordElementSize = 2;
            int texCoordOffset = triangleMesh.getVertexFormat().getTexCoordIndexOffset();
            int t0Idx = faces.get(faceIndex + texCoordOffset) * texCoordElementSize;
            int t1Idx = faces.get(faceIndex + vertexIndexSize + texCoordOffset) * texCoordElementSize;
            int t2Idx = faces.get(faceIndex + vertexIndexSize * 2 + texCoordOffset) * texCoordElementSize;
            ObservableFloatArray texCoords = triangleMesh.getTexCoords();
            Point2D u0 = new Point2D((double)texCoords.get(t0Idx), (double)texCoords.get(t0Idx + 1));
            Point2D u1 = new Point2D((double)texCoords.get(t1Idx), (double)texCoords.get(t1Idx + 1));
            Point2D u2 = new Point2D((double)texCoords.get(t2Idx), (double)texCoords.get(t2Idx + 1));
            Point2D txCentroid = CustomPickRayTools.computeCentroid(u0, u1, u2);
            Point2D cu0 = u0.subtract(txCentroid);
            Point2D cu1 = u1.subtract(txCentroid);
            Point2D cu2 = u2.subtract(txCentroid);
            Affine src = new Affine(flatV0.getX(), flatV1.getX(), flatV2.getX(), flatV0.getY(), flatV1.getY(), flatV2.getY());
            Affine trg = new Affine(cu0.getX(), cu1.getX(), cu2.getX(), cu0.getY(), cu1.getY(), cu2.getY());
            Point2D txCoords = null;
            try {
                src.invert();
                trg.append((Transform)src);
                txCoords = txCentroid.add(trg.transform(flatPoint));
            }
            catch (NonInvertibleTransformException nonInvertibleTransformException) {
                // empty catch block
            }
            result.offer(candidate, t, reportFace ? faceIndex / triangleMesh.getFaceElementSize() : -1, point, txCoords);
            return true;
        }
        return false;
    }

    private static Point3D computeCentroid(double v0x, double v0y, double v0z, double v1x, double v1y, double v1z, double v2x, double v2y, double v2z) {
        return new Point3D(v0x + 0.3333333333333333 * (0.5 * (v1x + v2x) - v0x), v0y + 0.3333333333333333 * (0.5 * (v1y + v2y) - v0y), v0z + 0.3333333333333333 * (0.5 * (v1z + v2z) - v0z));
    }

    private static Point2D computeCentroid(Point2D v0, Point2D v1, Point2D v2) {
        return new Point2D(v0.getX() + 0.3333333333333333 * (0.5 * (v1.getX() + v2.getX()) - v0.getX()), v0.getY() + 0.3333333333333333 * (0.5 * (v1.getY() + v2.getY()) - v0.getY()));
    }

    @Deprecated
    public static double intersectsBounds(Node node, CustomPickRay pickRay) {
        double tmax;
        double tmin;
        Vector3D dir = pickRay.direction;
        us.ihmc.euclid.tuple3D.Point3D origin = pickRay.origin;
        double originX = origin.getX();
        double originY = origin.getY();
        double originZ = origin.getZ();
        Bounds bounds = node.getBoundsInLocal();
        if (dir.getX() == 0.0 && dir.getY() == 0.0) {
            if (dir.getZ() == 0.0) {
                return Double.NaN;
            }
            if (originX < bounds.getMinX() || originX > bounds.getMaxX() || originY < bounds.getMinY() || originY > bounds.getMaxY()) {
                return Double.NaN;
            }
            double invDirZ = 1.0 / dir.getZ();
            boolean signZ = invDirZ < 0.0;
            double minZ = bounds.getMinZ();
            double maxZ = bounds.getMaxZ();
            tmin = ((signZ ? maxZ : minZ) - originZ) * invDirZ;
            tmax = ((signZ ? minZ : maxZ) - originZ) * invDirZ;
        } else if (bounds.getDepth() == 0.0) {
            if (CustomPickRayTools.almostZero(dir.getZ())) {
                return Double.NaN;
            }
            double t = (bounds.getMinZ() - originZ) / dir.getZ();
            double x = originX + dir.getX() * t;
            double y = originY + dir.getY() * t;
            if (x < bounds.getMinX() || x > bounds.getMaxX() || y < bounds.getMinY() || y > bounds.getMaxY()) {
                return Double.NaN;
            }
            tmin = tmax = t;
        } else {
            double invDirX = dir.getX() == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.getX();
            double invDirY = dir.getY() == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.getY();
            double invDirZ = dir.getZ() == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / dir.getZ();
            boolean signX = invDirX < 0.0;
            boolean signY = invDirY < 0.0;
            boolean signZ = invDirZ < 0.0;
            double minX = bounds.getMinX();
            double minY = bounds.getMinY();
            double maxX = bounds.getMaxX();
            double maxY = bounds.getMaxY();
            tmin = Double.NEGATIVE_INFINITY;
            tmax = Double.POSITIVE_INFINITY;
            if (Double.isInfinite(invDirX)) {
                if (!(minX <= originX) || !(maxX >= originX)) {
                    return Double.NaN;
                }
            } else {
                tmin = ((signX ? maxX : minX) - originX) * invDirX;
                tmax = ((signX ? minX : maxX) - originX) * invDirX;
            }
            if (Double.isInfinite(invDirY)) {
                if (!(minY <= originY) || !(maxY >= originY)) {
                    return Double.NaN;
                }
            } else {
                double tymin = ((signY ? maxY : minY) - originY) * invDirY;
                double tymax = ((signY ? minY : maxY) - originY) * invDirY;
                if (tmin > tymax || tymin > tmax) {
                    return Double.NaN;
                }
                if (tymin > tmin) {
                    tmin = tymin;
                }
                if (tymax < tmax) {
                    tmax = tymax;
                }
            }
            double minZ = bounds.getMinZ();
            double maxZ = bounds.getMaxZ();
            if (Double.isInfinite(invDirZ)) {
                if (!(minZ <= originZ) || !(maxZ >= originZ)) {
                    return Double.NaN;
                }
            } else {
                double tzmin = ((signZ ? maxZ : minZ) - originZ) * invDirZ;
                double tzmax = ((signZ ? minZ : maxZ) - originZ) * invDirZ;
                if (tmin > tzmax || tzmin > tmax) {
                    return Double.NaN;
                }
                if (tzmin > tmin) {
                    tmin = tzmin;
                }
                if (tzmax < tmax) {
                    tmax = tzmax;
                }
            }
        }
        Node clip = node.getClip();
        if (clip != null && !(node instanceof Shape3D) && !(clip instanceof Shape3D)) {
            double dirX = dir.getX();
            double dirY = dir.getY();
            double dirZ = dir.getZ();
            Transform clipLocalToParentTransform = clip.getLocalToParentTransform();
            boolean hitClip = true;
            try {
                CustomPickRayTools.inverseTransform(clipLocalToParentTransform, (Point3DBasics)origin);
                CustomPickRayTools.inverseTransform(clipLocalToParentTransform, (Vector3DBasics)dir);
            }
            catch (SingularMatrixException e) {
                hitClip = false;
            }
            hitClip = hitClip && CustomPickRayTools.intersects(clip, pickRay, null);
            origin.set(originX, originY, originZ);
            dir.set(dirX, dirY, dirZ);
            if (!hitClip) {
                return Double.NaN;
            }
        }
        if (Double.isInfinite(tmin) || Double.isNaN(tmin)) {
            return Double.NaN;
        }
        double minDistance = pickRay.nearClip;
        double maxDistance = pickRay.farClip;
        if (tmin < minDistance) {
            if (tmax >= minDistance) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (tmin > maxDistance) {
            return Double.NaN;
        }
        return tmin;
    }

    static boolean almostZero(double a) {
        return a < 1.0E-5 && a > -1.0E-5;
    }

    public static void transform(Transform transform, Point3DBasics pointToTransform) {
        CustomPickRayTools.transform(transform, (Point3DReadOnly)pointToTransform, (Tuple3DBasics)pointToTransform);
    }

    public static void transform(Transform transform, Point3DReadOnly pointOriginal, Tuple3DBasics pointTransformed) {
        CustomPickRayTools.transform(transform, (Tuple3DReadOnly)pointOriginal, pointTransformed, true);
    }

    public static void transform(Transform transform, Vector3DBasics vectorToTransform) {
        CustomPickRayTools.transform(transform, (Tuple3DReadOnly)vectorToTransform, (Tuple3DBasics)vectorToTransform, false);
    }

    public static void transform(Transform transform, Vector3DReadOnly vectorOriginal, Tuple3DBasics vectorTransformed) {
        CustomPickRayTools.transform(transform, (Tuple3DReadOnly)vectorOriginal, vectorTransformed, false);
    }

    public static void transform(Transform transform, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed, boolean applyTranslation) {
        if (transform.isIdentity()) {
            tupleTransformed.set(tupleOriginal);
        } else {
            double x_in = tupleOriginal.getX();
            double y_in = tupleOriginal.getY();
            double z_in = tupleOriginal.getZ();
            double x_out = transform.getMxx() * x_in + transform.getMxy() * y_in + transform.getMxz() * z_in;
            double y_out = transform.getMyx() * x_in + transform.getMyy() * y_in + transform.getMyz() * z_in;
            double z_out = transform.getMzx() * x_in + transform.getMzy() * y_in + transform.getMzz() * z_in;
            if (applyTranslation) {
                x_out += transform.getTx();
                y_out += transform.getTy();
                z_out += transform.getTz();
            }
            tupleTransformed.set(x_out, y_out, z_out);
        }
    }

    public static void inverseTransform(Transform transform, Point3DBasics pointToTransform) {
        CustomPickRayTools.inverseTransform(transform, (Point3DReadOnly)pointToTransform, (Tuple3DBasics)pointToTransform);
    }

    public static void inverseTransform(Transform transform, Point3DReadOnly pointOriginal, Tuple3DBasics pointTransformed) {
        CustomPickRayTools.inverseTransform(transform, (Tuple3DReadOnly)pointOriginal, pointTransformed, true);
    }

    public static void inverseTransform(Transform transform, Vector3DBasics vectorToTransform) {
        CustomPickRayTools.inverseTransform(transform, (Tuple3DReadOnly)vectorToTransform, (Tuple3DBasics)vectorToTransform, false);
    }

    public static void inverseTransform(Transform transform, Vector3DReadOnly vectorOriginal, Tuple3DBasics vectorTransformed) {
        CustomPickRayTools.inverseTransform(transform, (Tuple3DReadOnly)vectorOriginal, vectorTransformed, false);
    }

    public static void inverseTransform(Transform transform, Tuple3DReadOnly tupleOriginal, Tuple3DBasics tupleTransformed, boolean applyTranslation) {
        double z_out;
        double y_out;
        double x_out;
        double x_in = tupleOriginal.getX();
        double y_in = tupleOriginal.getY();
        double z_in = tupleOriginal.getZ();
        if (transform instanceof Rotate) {
            double m00 = transform.getMxx();
            double m11 = transform.getMyy();
            double m21 = transform.getMzy();
            double m20 = transform.getMzx();
            double m10 = transform.getMyx();
            double m01 = transform.getMxy();
            double m12 = transform.getMyz();
            double m22 = transform.getMzz();
            double m02 = transform.getMxz();
            x_out = m00 * x_in + m10 * y_in + m20 * z_in;
            y_out = m01 * x_in + m11 * y_in + m21 * z_in;
            z_out = m02 * x_in + m12 * y_in + m22 * z_in;
        } else if (transform instanceof Translate) {
            if (applyTranslation) {
                x_out = x_in - transform.getTx();
                y_out = y_in - transform.getTy();
                z_out = z_in - transform.getTz();
            } else {
                x_out = x_in;
                y_out = y_in;
                z_out = z_in;
            }
        } else if (transform instanceof Scale) {
            Scale scale = (Scale)transform;
            x_out = x_in / scale.getX();
            y_out = y_in / scale.getY();
            z_out = z_in / scale.getZ();
        } else if (transform.isIdentity()) {
            x_out = x_in;
            y_out = y_in;
            z_out = z_in;
        } else {
            double det = transform.determinant();
            if (det == 0.0) {
                throw new SingularMatrixException("Determinant is 0");
            }
            double m00 = transform.getMxx();
            double m11 = transform.getMyy();
            double m21 = transform.getMzy();
            double m20 = transform.getMzx();
            double m10 = transform.getMyx();
            double m01 = transform.getMxy();
            double m12 = transform.getMyz();
            double m22 = transform.getMzz();
            double m02 = transform.getMxz();
            det = 1.0 / det;
            double invM00 = (m11 * m22 - m21 * m12) * det;
            double invM01 = -(m01 * m22 - m21 * m02) * det;
            double invM02 = (m01 * m12 - m11 * m02) * det;
            double invM10 = -(m10 * m22 - m20 * m12) * det;
            double invM11 = (m00 * m22 - m20 * m02) * det;
            double invM12 = -(m00 * m12 - m10 * m02) * det;
            double invM20 = (m10 * m21 - m20 * m11) * det;
            double invM21 = -(m00 * m21 - m20 * m01) * det;
            double invM22 = (m00 * m11 - m10 * m01) * det;
            double x_tem = x_in;
            double y_tem = y_in;
            double z_tem = z_in;
            if (applyTranslation) {
                x_tem = x_in - transform.getTx();
                y_tem = y_in - transform.getTy();
                z_tem = z_in - transform.getTz();
            } else {
                x_tem = x_in;
                y_tem = y_in;
                z_tem = z_in;
            }
            x_out = invM00 * x_tem + invM01 * y_tem + invM02 * z_tem;
            y_out = invM10 * x_tem + invM11 * y_tem + invM12 * z_tem;
            z_out = invM20 * x_tem + invM21 * y_tem + invM22 * z_tem;
        }
        tupleTransformed.set(x_out, y_out, z_out);
    }

    public static class CustomPickResultChooser {
        private double distance = Double.POSITIVE_INFINITY;
        private Node node;
        private int face = -1;
        private Point3D point;
        private Point3D normal;
        private Point2D texCoord;
        private boolean empty = true;
        private boolean closed = false;
        private boolean hasDepthBuffer;

        public CustomPickResultChooser() {
            this(true);
        }

        public CustomPickResultChooser(boolean hasDepthBuffer) {
            this.hasDepthBuffer = Platform.isSupported((ConditionalFeature)ConditionalFeature.SCENE3D) && hasDepthBuffer;
        }

        public static Point3D computePoint(CustomPickRay ray, double distance) {
            us.ihmc.euclid.tuple3D.Point3D origin = ray.origin;
            Vector3D dir = ray.direction;
            return new Point3D(origin.getX() + dir.getX() * distance, origin.getY() + dir.getY() * distance, origin.getZ() + dir.getZ() * distance);
        }

        public PickResult toPickResult() {
            if (this.empty) {
                return null;
            }
            return new PickResult(this.node, this.point, this.distance, this.face, this.normal, this.texCoord);
        }

        public boolean isCloser(double distance) {
            return distance < this.distance || this.empty;
        }

        public boolean isEmpty() {
            return this.empty;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public boolean offer(Node node, double distance, int face, Point3D point, Point2D texCoord) {
            return this.processOffer(node, node, distance, point, face, this.normal, texCoord);
        }

        public boolean offer(Node node, double distance, Point3D point) {
            return this.processOffer(node, node, distance, point, -1, null, null);
        }

        private boolean processOffer(Node node, Node depthTestNode, double distance, Point3D point, int face, Point3D normal, Point2D texCoord) {
            boolean hasDepthTest = this.hasDepthBuffer && CustomPickResultChooser.isDerivedDepthTest(depthTestNode);
            boolean accepted = false;
            if ((this.empty || hasDepthTest && distance < this.distance) && !this.closed) {
                this.node = node;
                this.distance = distance;
                this.face = face;
                this.point = point;
                this.normal = normal;
                this.texCoord = texCoord;
                this.empty = false;
                accepted = true;
            }
            if (!hasDepthTest) {
                this.closed = true;
            }
            return accepted;
        }

        public static boolean isDerivedDepthTest(Node node) {
            DepthTest depthTest = node.getDepthTest();
            if (depthTest == DepthTest.INHERIT) {
                return node.getParent() != null ? CustomPickResultChooser.isDerivedDepthTest((Node)node.getParent()) : true;
            }
            return depthTest == DepthTest.ENABLE;
        }
    }

    public static class CustomPickRay {
        public final Vector3D direction = new Vector3D();
        public final us.ihmc.euclid.tuple3D.Point3D origin = new us.ihmc.euclid.tuple3D.Point3D();
        public double nearClip;
        public double farClip;

        void applyTransform(Transform transform) {
            CustomPickRayTools.transform(transform, (Point3DBasics)this.origin);
            CustomPickRayTools.transform(transform, (Vector3DBasics)this.direction);
        }
    }
}

