/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXExtensions.chart;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.InvisibleNumberAxis;
import javafx.scene.shape.Rectangle;
import us.ihmc.javaFXExtensions.chart.DynamicChart;

public abstract class DynamicXYChart
extends DynamicChart {
    private final InvisibleNumberAxis xAxis;
    private final InvisibleNumberAxis yAxis;
    protected final Group plotContent = new Group(){

        public void requestLayout() {
        }
    };
    private final Rectangle plotContentClip = new Rectangle();

    public DynamicXYChart(InvisibleNumberAxis xAxis, InvisibleNumberAxis yAxis) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.getChartChildren().addAll((Object[])new Node[]{this.plotContent, xAxis, yAxis});
        this.plotContent.setAutoSizeChildren(false);
        this.plotContentClip.setSmooth(false);
        this.plotContent.setClip((Node)this.plotContentClip);
        this.plotContent.getStyleClass().setAll((Object[])new String[]{"plot-content"});
        this.plotContent.setManaged(false);
    }

    @Override
    protected void layoutChartChildren(double top, double left, double width, double height) {
        double newXAxisHeight;
        this.updateAxisRange();
        top = this.snapPosition(top);
        left = this.snapPosition(left);
        double xAxisWidth = 0.0;
        double xAxisHeight = 30.0;
        double yAxisWidth = 0.0;
        double yAxisHeight = 0.0;
        for (int count = 0; count < 5 && (newXAxisHeight = this.xAxis.prefHeight(xAxisWidth = Math.max(0.0, this.snapSize(width - (yAxisWidth = this.yAxis.prefWidth(yAxisHeight = Math.max(0.0, this.snapSize(height - xAxisHeight)))))))) != xAxisHeight; ++count) {
            xAxisHeight = newXAxisHeight;
        }
        xAxisWidth = Math.ceil(xAxisWidth);
        xAxisHeight = Math.ceil(xAxisHeight);
        yAxisWidth = Math.ceil(yAxisWidth);
        yAxisHeight = Math.ceil(yAxisHeight);
        double xAxisY = top + yAxisHeight;
        double yAxisX = left + 1.0;
        this.xAxis.resizeRelocate(left += yAxisWidth, xAxisY, xAxisWidth, xAxisHeight);
        this.yAxis.resizeRelocate(yAxisX, top, yAxisWidth, yAxisHeight);
        this.xAxis.requestAxisLayout();
        this.xAxis.layout();
        this.yAxis.requestAxisLayout();
        this.yAxis.layout();
        this.layoutPlotChildren(top, left, xAxisWidth, yAxisHeight);
        this.plotContentClip.setX(left);
        this.plotContentClip.setY(top);
        this.plotContentClip.setWidth(xAxisWidth + 1.0);
        this.plotContentClip.setHeight(yAxisHeight + 1.0);
        this.plotContent.setLayoutX(left);
        this.plotContent.setLayoutY(top);
        this.plotContent.requestLayout();
    }

    protected abstract void layoutPlotChildren(double var1, double var3, double var5, double var7);

    protected abstract void updateAxisRange();
}

