/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.javaFXExtensions.chart;

import com.sun.javafx.util.Utils;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public abstract class DynamicChart
extends Region {
    private static final int MIN_WIDTH_TO_LEAVE_FOR_CHART_CONTENT = 100;
    private static final int MIN_HEIGHT_TO_LEAVE_FOR_CHART_CONTENT = 50;
    private final Pane chartContent = new Pane(){

        protected void layoutChildren() {
            double top = this.snappedTopInset();
            double left = this.snappedLeftInset();
            double bottom = this.snappedBottomInset();
            double right = this.snappedRightInset();
            double width = this.getWidth();
            double height = this.getHeight();
            double contentWidth = this.snapSize(width - (left + right));
            double contentHeight = this.snapSize(height - (top + bottom));
            DynamicChart.this.layoutChartChildren(this.snapPosition(top), this.snapPosition(left), contentWidth, contentHeight);
        }
    };
    private final ObjectProperty<Node> legend = new ObjectPropertyBase<Node>(){
        private Node old = null;

        protected void invalidated() {
            Node newLegend = (Node)this.get();
            if (this.old != null) {
                DynamicChart.this.getChildren().remove((Object)this.old);
            }
            if (newLegend != null) {
                DynamicChart.this.getChildren().add((Object)newLegend);
                DynamicChart.this.updateLegendSizeBinding(newLegend);
                newLegend.setVisible(true);
            }
            this.old = newLegend;
        }

        public Object getBean() {
            return DynamicChart.this;
        }

        public String getName() {
            return "legend";
        }
    };

    protected final Node getLegend() {
        return (Node)this.legend.getValue();
    }

    protected final void setLegend(Node value) {
        this.legend.setValue((Object)value);
    }

    protected final ObjectProperty<Node> legendProperty() {
        return this.legend;
    }

    protected void updateLegendSizeBinding(Node legend) {
        if (legend instanceof FlowPane) {
            FlowPane legendFlowPane = (FlowPane)legend;
            legendFlowPane.prefWrapLengthProperty().bind((ObservableValue)this.widthProperty());
        } else if (legend instanceof Region) {
            Region legendTilePane = (Region)legend;
            legendTilePane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        }
    }

    protected ObservableList<Node> getChartChildren() {
        return this.chartContent.getChildren();
    }

    public DynamicChart() {
        this.getChildren().addAll((Object[])new Node[]{this.chartContent});
        this.getStyleClass().add((Object)"chart");
        this.chartContent.getStyleClass().add((Object)"chart-content");
        this.chartContent.setManaged(false);
        this.chartContent.setPadding(Insets.EMPTY);
        this.setPadding(Insets.EMPTY);
    }

    protected void requestChartLayout() {
        this.chartContent.requestLayout();
    }

    protected abstract void layoutChartChildren(double var1, double var3, double var5, double var7);

    protected void layoutChildren() {
        double top = this.snappedTopInset();
        double left = this.snappedLeftInset();
        double bottom = this.snappedBottomInset();
        double right = this.snappedRightInset();
        double width = this.getWidth();
        double height = this.getHeight();
        Node legend = this.getLegend();
        if (legend != null) {
            boolean shouldShowLegend = true;
            double legendHeight = this.snapSize(legend.prefHeight(width - left - right));
            double legendWidth = Utils.clamp((double)this.snapSize(legend.prefWidth(legendHeight)), (double)0.0, (double)(width - left - right));
            double legendLeft = left + (width - left - right - legendWidth) / 2.0;
            double legendTop = height - bottom - legendHeight;
            legend.resizeRelocate(legendLeft, legendTop, legendWidth, legendHeight);
            if (height - bottom - top - legendHeight < 50.0) {
                shouldShowLegend = false;
            } else {
                bottom += legendHeight;
            }
            legend.setVisible(shouldShowLegend);
        }
        this.chartContent.resizeRelocate(left, top, width - left - right, height - top - bottom);
    }

    protected double computeMinHeight(double width) {
        return 50.0;
    }

    protected double computeMinWidth(double height) {
        return 100.0;
    }

    protected double computePrefWidth(double height) {
        return 500.0;
    }

    protected double computePrefHeight(double width) {
        return 400.0;
    }
}

