/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.tools.processManagement.ProcessSpawner;
import us.ihmc.tools.processManagement.ProcessTools;

public class JavaProcessManager {
    private static final String FORKED_PROCESS_INDEX = "forked.process.index";
    private static final String forkedProcessIndexProperty = System.getProperty("forked.process.index");
    private static final boolean isSpawnerProcess = forkedProcessIndexProperty == null;
    private static final int forkedProcessIndex = isSpawnerProcess ? -1 : Integer.parseInt(forkedProcessIndexProperty);
    private final ArrayList<String> processNames = new ArrayList();

    public static ArrayList<Process> teeToLogFile(Class<?> mainClass) {
        JavaProcessManager manager = new JavaProcessManager();
        manager.runOrRegister(mainClass);
        return manager.spawnProcesses(mainClass, null);
    }

    public ArrayList<Process> spawnProcesses(Class<?> mainClass, String[] args) {
        if (isSpawnerProcess) {
            ArrayList<Process> processList = new ArrayList<Process>();
            try {
                JavaProcessSpawner spawner = new JavaProcessSpawner(true);
                Object[] parentJVMProperties = ProcessTools.getCurrentJVMProperties();
                for (int i = 0; i < this.processNames.size(); ++i) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
                    Calendar calendar = Calendar.getInstance();
                    String timestampOfCreation = dateFormat.format(calendar.getTime());
                    Path logFilePath = Paths.get(System.getProperty("user.home"), ".ihmc", "logs", timestampOfCreation + "_" + this.processNames.get(i) + "Log.txt");
                    String[] jvmProperties = (String[])ArrayUtils.add((Object[])parentJVMProperties, (Object)("-Dforked.process.index=" + i));
                    TeeOutputStream outputTee = new TeeOutputStream((OutputStream)System.out, (OutputStream)ProcessTools.createJansiFilteredStream(logFilePath));
                    TeeOutputStream errorTee = new TeeOutputStream((OutputStream)System.err, (OutputStream)ProcessTools.createJansiFilteredStream(logFilePath));
                    PrintStream outputStream = new PrintStream((OutputStream)outputTee);
                    PrintStream errorStream = new PrintStream((OutputStream)errorTee);
                    LogTools.info((String)"Spawning process {} teed to {}", (Object)this.processNames.get(i), (Object)logFilePath);
                    String prefix = this.processNames.size() > 1 ? ProcessSpawner.defaultPrintingPrefix(this.processNames.get(i)) : null;
                    processList.add(spawner.spawn(mainClass, jvmProperties, args, null, null, outputStream, errorStream, prefix, null));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return processList;
        }
        return null;
    }

    public boolean isSpawnerProcess() {
        return isSpawnerProcess;
    }

    public void runOrRegister(Class<?> mainClass) {
        this.runOrRegister(mainClass.getSimpleName(), () -> ExceptionTools.handle(mainClass::newInstance, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE));
    }

    public void runOrRegister(String name, Runnable runnable) {
        if (!isSpawnerProcess && forkedProcessIndex == this.processNames.size()) {
            LogTools.info((String)("Starting " + name));
            runnable.run();
        }
        this.processNames.add(name);
    }
}

