/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import us.ihmc.tools.io.WorkspaceFile;
import us.ihmc.tools.io.WorkspaceResourceDirectory;
import us.ihmc.tools.io.resources.ResourceTools;

public class WorkspaceResourceFile
extends WorkspaceFile {
    private final Class<?> classForLoading;
    private final Path resourceFilePath;
    private final String pathAsStringForResourceLoading;

    public WorkspaceResourceFile(WorkspaceResourceDirectory resourceDirectory, String subsequentPathToFile) {
        super(resourceDirectory, subsequentPathToFile);
        this.classForLoading = resourceDirectory.getClassForLoading();
        this.resourceFilePath = Paths.get(resourceDirectory.getPathNecessaryForClasspathLoading(), new String[0]).resolve(subsequentPathToFile);
        this.pathAsStringForResourceLoading = ResourceTools.toResourceAccessStringWithCorrectSeparators(this.resourceFilePath);
    }

    public InputStream getClasspathResourceAsStream() {
        return this.classForLoading.getResourceAsStream(this.pathAsStringForResourceLoading);
    }

    public URL getClasspathResource() {
        return this.classForLoading.getResource(this.pathAsStringForResourceLoading);
    }

    public String getFileName() {
        return this.resourceFilePath.getFileName().toString();
    }

    public String getPathForResourceLoadingPathFiltered() {
        return this.pathAsStringForResourceLoading;
    }
}

