/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import us.ihmc.commons.nio.BasicPathVisitor;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.WorkspaceDirectory;
import us.ihmc.tools.io.WorkspaceResourceFile;
import us.ihmc.tools.io.resources.ResourceTools;

public class WorkspaceResourceDirectory
extends WorkspaceDirectory {
    protected Class<?> classForLoading;
    private final Path pathNecessaryForClasspathLoading;
    private String pathNecessaryForClasspathLoadingString;
    private String pathNecessaryForResourceExploring;

    public WorkspaceResourceDirectory(Class<?> classForFindingSourceSetDirectory) {
        this.classForLoading = classForFindingSourceSetDirectory;
        this.setFilesystemDirectoryToSourceSetDirectory(classForFindingSourceSetDirectory, "resources");
        this.pathNecessaryForClasspathLoading = ResourceTools.getResourcesPathForClass(classForFindingSourceSetDirectory);
        this.initialize();
    }

    public WorkspaceResourceDirectory(Class<?> classForFindingSourceSetDirectory, String subsequentOrAbsoluteResourcePackagePath) {
        this.classForLoading = classForFindingSourceSetDirectory;
        this.setFilesystemDirectoryToSourceSetDirectory(classForFindingSourceSetDirectory, "resources");
        this.pathNecessaryForClasspathLoading = ResourceTools.getResourcesPathForClass(classForFindingSourceSetDirectory).resolve(subsequentOrAbsoluteResourcePackagePath);
        this.initialize();
    }

    private void initialize() {
        this.pathNecessaryForClasspathLoadingString = ResourceTools.toResourceAccessStringWithCorrectSeparators(this.pathNecessaryForClasspathLoading);
        String classpathPathToResourceDirectoryString = this.pathNecessaryForClasspathLoadingString.substring(1);
        if (this.filesystemDirectory != null) {
            this.filesystemDirectory = this.filesystemDirectory.resolve(classpathPathToResourceDirectoryString);
        }
        this.pathNecessaryForResourceExploring = classpathPathToResourceDirectoryString.replaceAll("/", ".");
    }

    public void walkResourcesFlat(BiConsumer<String, BasicPathVisitor.PathType> pathVisitor) {
        ResourceTools.walkResourcesFlat(this.pathNecessaryForResourceExploring, pathVisitor);
    }

    public List<WorkspaceResourceFile> queryContainedFiles() {
        ArrayList<WorkspaceResourceFile> files = new ArrayList<WorkspaceResourceFile>();
        ResourceTools.walkResourcesFlat(this.pathNecessaryForResourceExploring, (fileName, pathType) -> {
            if (pathType == BasicPathVisitor.PathType.FILE) {
                files.add(new WorkspaceResourceFile(this, (String)fileName));
            }
        });
        return files;
    }

    public List<WorkspaceResourceDirectory> queryContainedDirectories() {
        ArrayList<WorkspaceResourceDirectory> directories = new ArrayList<WorkspaceResourceDirectory>();
        ResourceTools.walkResourcesFlat(this.pathNecessaryForResourceExploring, (fileName, pathType) -> {
            if (pathType == BasicPathVisitor.PathType.DIRECTORY) {
                directories.add(new WorkspaceResourceDirectory(this.classForLoading, this.pathNecessaryForClasspathLoadingString + "/" + fileName));
            }
        });
        return directories;
    }

    public Class<?> getClassForLoading() {
        return this.classForLoading;
    }

    public String getPathNecessaryForClasspathLoading() {
        return this.pathNecessaryForClasspathLoadingString;
    }

    public String getPathNecessaryForResourceExploring() {
        return this.pathNecessaryForResourceExploring;
    }

    @Override
    public WorkspaceResourceDirectory resolve(String subdirectory) {
        return new WorkspaceResourceDirectory(this.classForLoading, ResourceTools.toResourceAccessStringWithCorrectSeparators(this.pathNecessaryForClasspathLoading.resolve(subdirectory)));
    }

    public static void main(String[] args) {
        WorkspaceResourceDirectory workspaceDirectory = new WorkspaceResourceDirectory(WorkspaceResourceDirectory.class);
        WorkspaceResourceDirectory.printTestInfo(workspaceDirectory);
        workspaceDirectory = new WorkspaceResourceDirectory(WorkspaceResourceDirectory.class, "/stuff/moreStuff");
        WorkspaceResourceDirectory.printTestInfo(workspaceDirectory);
        workspaceDirectory = new WorkspaceResourceDirectory(WorkspaceResourceDirectory.class, "stuff/moreStuff");
        WorkspaceResourceDirectory.printTestInfo(workspaceDirectory);
    }

    private static void printTestInfo(WorkspaceResourceDirectory workspaceDirectory) {
        LogTools.info((String)"File access available: {}", (Object)(workspaceDirectory.isFileAccessAvailable() ? "Yes" : "No"));
        LogTools.info((String)"Path necessary for classpath loading: {}", (Object)workspaceDirectory.getPathNecessaryForClasspathLoading());
        LogTools.info((String)"Path necessary for resource exploring: {}", (Object)workspaceDirectory.getPathNecessaryForResourceExploring());
        if (workspaceDirectory.isFileAccessAvailable()) {
            Path directoryPath = workspaceDirectory.getFilesystemDirectory();
            LogTools.info((String)"Directory path: {}", (Object)directoryPath);
        }
    }
}

