/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.time;

import java.util.UUID;
import us.ihmc.commons.Conversions;
import us.ihmc.log.LogTools;
import us.ihmc.tools.thread.MissingThreadTools;

public class FrequencyCalculator {
    private double alpha = 0.3;
    private double lastEventTime = Double.NaN;
    private double smoothedPeriod = Double.NaN;
    private volatile boolean loggingThreadRunning;

    public FrequencyCalculator(boolean enableLoggingThread) {
        if (enableLoggingThread) {
            String threadID = UUID.randomUUID().toString().substring(0, 5);
            Thread loggingThread = new Thread(() -> {
                this.loggingThreadRunning = true;
                while (this.loggingThreadRunning) {
                    LogTools.info((String)("FrequencyCalculator[" + threadID + "] average rate: " + this.getFrequency()));
                    MissingThreadTools.sleep(1.0);
                }
            }, this.getClass().getSimpleName() + "-" + threadID);
            loggingThread.start();
        }
    }

    public FrequencyCalculator() {
        this(false);
    }

    private double calculateFrequency(boolean decay) {
        if (Double.isNaN(this.smoothedPeriod)) {
            return 0.0;
        }
        double currentTime = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        double ongoingPeriod = currentTime - this.lastEventTime;
        if (!decay || ongoingPeriod < this.smoothedPeriod) {
            return 1.0 / this.smoothedPeriod;
        }
        double psuedoSmoothedPeriod = (1.0 - this.alpha) * this.smoothedPeriod + this.alpha * ongoingPeriod;
        return 1.0 / psuedoSmoothedPeriod;
    }

    public void ping() {
        double currentTime = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        if (!Double.isNaN(this.lastEventTime)) {
            double period = currentTime - this.lastEventTime;
            this.smoothedPeriod = Double.isNaN(this.smoothedPeriod) ? period : (1.0 - this.alpha) * this.smoothedPeriod + this.alpha * period;
        }
        this.lastEventTime = currentTime;
    }

    public double getFrequency() {
        return this.calculateFrequency(false);
    }

    public double getFrequencyDecaying() {
        return this.calculateFrequency(true);
    }

    public void destroy() {
        this.loggingThreadRunning = false;
    }
}

