/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.time;

import java.util.ArrayDeque;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.tools.Timer;
import us.ihmc.tools.thread.PausablePeriodicThread;

public class DurationStatisticPrinter {
    boolean newEvents;
    private double averageDuration;
    private double minDuration;
    private double maxDuration;
    private double standardDeviation;
    private int window;
    private final ArrayDeque<Double> deltas = new ArrayDeque();
    private final Stopwatch stopwatch = new Stopwatch();
    private final String prefix;
    private final PausablePeriodicThread pausablePeriodicThread;
    private double expiration = 1.0;
    private final Timer expirationTimer = new Timer();
    private final int history;

    public DurationStatisticPrinter() {
        this(null, 10, 1.0, "");
    }

    public DurationStatisticPrinter(String prefix) {
        this(null, 10, 1.0, prefix);
    }

    public DurationStatisticPrinter(int history) {
        this(null, history, 1.0, "");
    }

    public DurationStatisticPrinter(Runnable onLogReport) {
        this(onLogReport, 10, 1.0, "");
    }

    public DurationStatisticPrinter(Runnable onLogReport, int history, double expirationTime, String prefix) {
        this(onLogReport, history, expirationTime, 1.0, prefix);
    }

    public DurationStatisticPrinter(Runnable onLogReport, int history, double expirationTime, double printFrequency, String prefix) {
        this.history = history;
        this.prefix = prefix.isEmpty() ? "" : prefix + ": ";
        this.expiration = expirationTime;
        this.reset();
        boolean runAsDaemon = true;
        this.pausablePeriodicThread = new PausablePeriodicThread(this.getClass().getSimpleName(), printFrequency, 0, runAsDaemon, () -> {
            this.logReport();
            if (onLogReport != null) {
                onLogReport.run();
            }
        });
        this.pausablePeriodicThread.start();
    }

    private void logReport() {
        if (!this.newEvents) {
            this.reset();
            LogTools.info((String)"%sno new events".formatted(this.prefix));
        } else if (!this.expirationTimer.isRunning(this.expiration)) {
            this.reset();
        } else {
            LogTools.info((int)2, (Object)"%saverage duration: %.3f (s)\n        min: %.3f (s) max: %.3f (s) std dev: %.3f (s) window: %d".formatted(this.prefix, this.averageDuration, this.minDuration, this.maxDuration, this.standardDeviation, this.window));
        }
    }

    public synchronized void before() {
        this.stopwatch.reset();
    }

    public synchronized double after() {
        this.newEvents = true;
        ++this.window;
        this.expirationTimer.reset();
        double elapsed = this.stopwatch.totalElapsed();
        if (Double.isNaN(this.minDuration) || elapsed < this.minDuration) {
            this.minDuration = elapsed;
        }
        if (Double.isNaN(this.maxDuration) || elapsed > this.maxDuration) {
            this.maxDuration = elapsed;
        }
        this.deltas.addLast(elapsed);
        while (this.deltas.size() > this.history) {
            this.deltas.removeFirst();
        }
        double totalElapsed = 0.0;
        for (Double delta : this.deltas) {
            totalElapsed += delta.doubleValue();
        }
        this.averageDuration = totalElapsed / (double)this.deltas.size();
        if (this.deltas.size() < 2) {
            this.standardDeviation = 0.0;
        } else {
            double sumOfSquares = 0.0;
            for (Double delta : this.deltas) {
                sumOfSquares += Math.pow(delta - this.averageDuration, 2.0);
            }
            this.standardDeviation = Math.sqrt(sumOfSquares / (double)this.deltas.size());
        }
        return elapsed;
    }

    public synchronized void reset() {
        this.newEvents = false;
        this.minDuration = Double.NaN;
        this.maxDuration = Double.NaN;
        this.standardDeviation = Double.NaN;
        this.window = -1;
        this.stopwatch.reset();
    }

    public void destroy() {
        this.pausablePeriodicThread.destroy();
    }
}

