/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.RunnableThatThrows;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.tools.thread.ExceptionHandlingThreadPoolExecutor;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.tools.thread.Throttler;

public class MissingThreadTools {
    public static double sleepAtLeast(double duration) {
        double startTime = Conversions.nanosecondsToSeconds((long)System.nanoTime());
        double amountSlept = 0.0;
        do {
            double nextDuration = duration - amountSlept;
            MissingThreadTools.sleep(nextDuration);
        } while ((amountSlept = Conversions.nanosecondsToSeconds((long)System.nanoTime()) - startTime) < duration);
        return amountSlept;
    }

    public static void sleep(double seconds) {
        double floatingNanos = seconds * 1.0E9;
        long nanoseconds = (long)floatingNanos;
        if (floatingNanos > (double)nanoseconds) {
            ++nanoseconds;
        }
        LockSupport.parkNanos(nanoseconds);
    }

    public static void sleepMillis(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static ThreadFactory createNamedThreadFactory(String prefix, boolean daemon) {
        boolean includePoolInName = true;
        boolean includeThreadNumberInName = true;
        return ThreadTools.createNamedThreadFactory((String)prefix, (boolean)includePoolInName, (boolean)includeThreadNumberInName, (boolean)daemon, (int)5);
    }

    public static ResettableExceptionHandlingExecutorService newSingleThreadExecutor(String prefix) {
        return MissingThreadTools.newSingleThreadExecutor(prefix, false);
    }

    public static ResettableExceptionHandlingExecutorService newSingleThreadExecutor(String prefix, boolean daemon) {
        return MissingThreadTools.newSingleThreadExecutor(prefix, daemon, -1);
    }

    public static ResettableExceptionHandlingExecutorService newSingleThreadExecutor(String prefix, boolean daemon, int queueSize) {
        int corePoolSize = 1;
        int maximumPoolSize = 1;
        long keepAliveTime = 0L;
        return new ResettableExceptionHandlingExecutorService(() -> new ExceptionHandlingThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)(queueSize < 0 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(queueSize))), MissingThreadTools.createNamedThreadFactory(prefix, daemon), new ThreadPoolExecutor.AbortPolicy()));
    }

    public static Thread startAsDaemon(String threadName, ExceptionHandler exceptionHandler, RunnableThatThrows runnable) {
        return ThreadTools.startAsDaemon(() -> ExceptionTools.handle((RunnableThatThrows)runnable, (ExceptionHandler)exceptionHandler), (String)threadName);
    }

    public static Thread startAsDaemon(String threadName, double period, RunnableThatThrows runnable) {
        Throttler throttler = new Throttler();
        return MissingThreadTools.startAsDaemon(threadName, DefaultExceptionHandler.MESSAGE_AND_STACKTRACE, () -> {
            while (true) {
                throttler.waitAndRun(period);
                runnable.run();
            }
        });
    }

    public static Thread startAThread(String threadName, ExceptionHandler exceptionHandler, RunnableThatThrows runnable) {
        return ThreadTools.startAThread(() -> ExceptionTools.handle((RunnableThatThrows)runnable, (ExceptionHandler)exceptionHandler), (String)threadName);
    }
}

