/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.nio.file.Path;
import us.ihmc.tools.io.HybridResourceMode;
import us.ihmc.tools.io.WorkspaceDirectory;

public class HybridDirectory {
    protected Path externalDirectory;
    protected WorkspaceDirectory workspaceDirectory;
    protected HybridResourceMode mode = HybridResourceMode.WORKSPACE;

    protected HybridDirectory() {
    }

    public HybridDirectory(Path externalDirectory, Path workspaceDirectory) {
        this.externalDirectory = externalDirectory;
        this.workspaceDirectory = new WorkspaceDirectory(workspaceDirectory);
    }

    public HybridDirectory(Path externalDirectory, WorkspaceDirectory workspaceDirectory) {
        this.externalDirectory = externalDirectory;
        this.workspaceDirectory = workspaceDirectory;
    }

    public boolean isWorkspaceFileAccessAvailable() {
        return this.workspaceDirectory.isFileAccessAvailable();
    }

    public void setMode(HybridResourceMode mode) {
        this.mode = mode;
    }

    public HybridResourceMode getMode() {
        return this.mode;
    }

    public Path getDirectoryForWriting() {
        return this.mode == HybridResourceMode.WORKSPACE ? this.workspaceDirectory.getFilesystemDirectory() : this.externalDirectory;
    }

    public Path getWorkspaceDirectory() {
        return this.workspaceDirectory.getFilesystemDirectory();
    }

    public Path getExternalDirectory() {
        return this.externalDirectory;
    }

    public HybridDirectory resolve(String subsequentPathInBothExternalAndWorkspace) {
        return new HybridDirectory(this.externalDirectory.resolve(subsequentPathInBothExternalAndWorkspace), this.workspaceDirectory.resolve(subsequentPathInBothExternalAndWorkspace));
    }

    WorkspaceDirectory getWorkspaceDirectoryInternal() {
        return this.workspaceDirectory;
    }
}

