/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.time;

import java.util.ArrayDeque;
import us.ihmc.commons.time.Stopwatch;

public class MovingAverageDurationCalculator {
    private volatile double duration = Double.NaN;
    private final ArrayDeque<Double> deltas = new ArrayDeque();
    private final Stopwatch stopwatch = new Stopwatch().start();
    private final int windowSize;

    public MovingAverageDurationCalculator(int windowSize) {
        this.windowSize = windowSize;
    }

    public synchronized void pause() {
        this.stopwatch.suspend();
    }

    public void reset() {
        this.stopwatch.reset();
    }

    public synchronized void ping() {
        this.stopwatch.resume();
        double elapsed = this.stopwatch.lap();
        this.deltas.addLast(elapsed);
        while (this.deltas.size() > this.windowSize) {
            this.deltas.removeFirst();
        }
        double totalElapsed = 0.0;
        for (Double delta : this.deltas) {
            totalElapsed += delta.doubleValue();
        }
        this.duration = totalElapsed / (double)this.deltas.size();
    }

    public synchronized double getDuration() {
        return this.duration;
    }
}

