/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.property;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.commons.thread.Notification;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.io.WorkspacePathTools;
import us.ihmc.tools.io.WorkspaceResourceDirectory;
import us.ihmc.tools.io.WorkspaceResourceFile;
import us.ihmc.tools.property.BooleanStoredPropertyKey;
import us.ihmc.tools.property.DoubleStoredPropertyKey;
import us.ihmc.tools.property.IntegerStoredPropertyKey;
import us.ihmc.tools.property.StoredProperty;
import us.ihmc.tools.property.StoredPropertyKey;
import us.ihmc.tools.property.StoredPropertyKeyList;
import us.ihmc.tools.property.StoredPropertyKeyListReadOnly;
import us.ihmc.tools.property.StoredPropertySetBasics;
import us.ihmc.tools.property.StoredPropertySetJavaGenerator;
import us.ihmc.tools.property.StoredPropertySetReadOnly;
import us.ihmc.tools.string.StringTools;

public class StoredPropertySet
implements StoredPropertySetBasics {
    private final StoredPropertyKeyList keys;
    private final Object[] values;
    private String title;
    private String legacyFileNameINI;
    private String saveFileNameJSON;
    private String currentVersionSuffix;
    private final Class<?> classForLoading;
    private final Class<?> basePropertySetClass;
    private final WorkspaceResourceDirectory workspaceDirectory;
    private final String uncapitalizedClassName;
    private final String capitalizedClassName;
    private WorkspaceResourceFile workspaceLegacyINIFile;
    private WorkspaceResourceFile workspaceJSONFile;
    private final Map<StoredPropertyKey, List<Runnable>> propertyChangedListeners = new HashMap<StoredPropertyKey, List<Runnable>>();
    private final List<Notification> anyPropertyChangedListeners = new ArrayList<Notification>();

    public StoredPropertySet(StoredPropertyKeyList keys, Class<?> classForLoading) {
        this(keys, classForLoading, "");
    }

    public StoredPropertySet(StoredPropertyKeyList keys, Class<?> classForLoading, String versionSuffix) {
        this(keys, classForLoading, classForLoading, versionSuffix);
    }

    public StoredPropertySet(StoredPropertyKeyList keys, Class<?> classForLoading, Class<?> basePropertySetClass, String versionSuffix) {
        this.keys = keys;
        this.uncapitalizedClassName = StringUtils.uncapitalize((String)basePropertySetClass.getSimpleName());
        this.capitalizedClassName = basePropertySetClass.getSimpleName();
        this.classForLoading = classForLoading;
        this.title = classForLoading.getSimpleName();
        this.basePropertySetClass = basePropertySetClass;
        this.workspaceDirectory = new WorkspaceResourceDirectory(classForLoading);
        this.updateBackingSaveFile(versionSuffix);
        this.values = new Object[keys.keys().size()];
        for (StoredPropertyKey<?> key : keys.keys()) {
            if (!key.hasDefaultValue()) continue;
            this.setInternal(key, key.getDefaultValue());
        }
    }

    public void generateJavaFiles() {
        StoredPropertySetJavaGenerator generator = new StoredPropertySetJavaGenerator(this.basePropertySetClass, this.classForLoading, WorkspacePathTools.removePathPartsBeforeProjectFolder(this.findFileForSaving()));
        if (this.jsonResourceExists()) {
            generator.loadFromJSON();
        } else {
            generator.loadFromStoredPropertySet(this);
        }
        generator.generate();
        if (!this.jsonResourceExists()) {
            this.load();
            this.save();
        }
    }

    @Override
    public double get(DoubleStoredPropertyKey key) {
        boolean isNull;
        Object value = this.values[key.getIndex()];
        boolean bl = isNull = value == null;
        if (isNull) {
            LogTools.warn((String)"Value for key {} is null. Returning Double.NaN.", (Object)key.getTitleCasedName());
        }
        return isNull ? Double.NaN : (Double)value;
    }

    @Override
    public int get(IntegerStoredPropertyKey key) {
        boolean isNull;
        Object value = this.values[key.getIndex()];
        boolean bl = isNull = value == null;
        if (isNull) {
            LogTools.warn((String)"Value for key {} is null. Returning -1.", (Object)key.getTitleCasedName());
        }
        return isNull ? -1 : (Integer)value;
    }

    @Override
    public boolean get(BooleanStoredPropertyKey key) {
        boolean isNull;
        Object value = this.values[key.getIndex()];
        boolean bl = isNull = value == null;
        if (isNull) {
            LogTools.warn((String)"Value for key {} is null. Returning false.", (Object)key.getTitleCasedName());
        }
        return isNull ? false : (Boolean)value;
    }

    @Override
    public <T> T get(StoredPropertyKey<T> key) {
        boolean isNull;
        Object value = this.values[key.getIndex()];
        boolean bl = isNull = value == null;
        if (isNull) {
            LogTools.warn((String)"Value for key {} is null. Returning null.", (Object)key.getTitleCasedName());
        }
        return (T)(isNull ? null : value);
    }

    @Override
    public void set(DoubleStoredPropertyKey key, double value) {
        this.setInternal(key, value);
    }

    @Override
    public void set(IntegerStoredPropertyKey key, int value) {
        this.setInternal(key, value);
    }

    @Override
    public void set(BooleanStoredPropertyKey key, boolean value) {
        this.setInternal(key, value);
    }

    @Override
    public <T> void set(StoredPropertyKey<T> key, T value) {
        this.setInternal(key, value);
    }

    public <T> StoredProperty<T> getProperty(StoredPropertyKey<T> key) {
        return new StoredProperty<T>(key, this);
    }

    @Override
    public List<Object> getAll() {
        return Arrays.asList(this.values);
    }

    @Override
    public List<String> getAllAsStrings() {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (StoredPropertyKey<?> key : this.keys.keys()) {
            stringValues.add(this.serializeValue(this.get(key)));
        }
        return stringValues;
    }

    @Override
    public void setAll(List<Object> newValues) {
        for (int i = 0; i < this.keys.keys().size(); ++i) {
            this.setInternal(this.keys.keys().get(i), newValues.get(i));
        }
    }

    @Override
    public void setAllFromStrings(List<String> stringValues) {
        for (int i = 0; i < this.keys.keys().size(); ++i) {
            this.setInternal(this.keys.keys().get(i), this.deserializeString(this.keys.keys().get(i), stringValues.get(i)));
        }
    }

    @Override
    public void set(StoredPropertySetReadOnly other) {
        this.setAll(other.getAll());
    }

    private void setInternal(StoredPropertyKey key, Object newValue) {
        boolean valueChanged;
        if (this.values[key.getIndex()] == null) {
            valueChanged = newValue != null;
        } else {
            boolean bl = valueChanged = !this.values[key.getIndex()].equals(newValue);
        }
        if (valueChanged) {
            if (!key.getType().equals(newValue.getClass())) {
                if (key.getType().equals(Boolean.class) && newValue.getClass().equals(Integer.class)) {
                    newValue = (Integer)newValue != 0;
                } else {
                    throw new RuntimeException("Value of type " + newValue.getClass() + " cannot be set to key type " + key.getType());
                }
            }
            this.values[key.getIndex()] = newValue;
            if (this.propertyChangedListeners.get(key) != null) {
                for (Runnable propertyChangedListener : this.propertyChangedListeners.get(key)) {
                    propertyChangedListener.run();
                }
            }
            for (Notification anyPropertyChangedListener : this.anyPropertyChangedListeners) {
                anyPropertyChangedListener.set();
            }
        }
    }

    @Override
    public void addPropertyChangedListener(StoredPropertyKey key, Runnable onPropertyChanged) {
        if (this.propertyChangedListeners.get(key) == null) {
            this.propertyChangedListeners.put(key, new ArrayList());
        }
        this.propertyChangedListeners.get(key).add(onPropertyChanged);
    }

    @Override
    public void removePropertyChangedListener(StoredPropertyKey key, Runnable onPropertyChanged) {
        if (this.propertyChangedListeners.get(key) != null) {
            this.propertyChangedListeners.get(key).remove(onPropertyChanged);
        }
    }

    @Override
    public void addAnyPropertyChangedListener(Notification anyPropertyChangedNotification) {
        this.anyPropertyChangedListeners.add(anyPropertyChangedNotification);
    }

    @Override
    public void removeAnyPropertyChangedListener(Notification anyPropertyChangedNotification) {
        this.anyPropertyChangedListeners.remove(anyPropertyChangedNotification);
    }

    @Override
    public void updateBackingSaveFile(String versionSuffix) {
        this.updateBackingSaveFileSilently(versionSuffix);
        LogTools.info((String)"Updated backing save file: {}", (Object)this.saveFileNameJSON);
    }

    private void updateBackingSaveFileSilently(String versionSuffix) {
        this.currentVersionSuffix = versionSuffix;
        this.legacyFileNameINI = this.uncapitalizedClassName + this.currentVersionSuffix + ".ini";
        this.workspaceLegacyINIFile = new WorkspaceResourceFile(this.workspaceDirectory, this.legacyFileNameINI);
        this.saveFileNameJSON = this.basePropertySetClass.getSimpleName() + this.currentVersionSuffix + ".json";
        this.workspaceJSONFile = new WorkspaceResourceFile(this.workspaceDirectory, this.saveFileNameJSON);
    }

    @Override
    public void load() {
        if (!this.currentVersionSuffix.isEmpty()) {
            String backupVersionSuffix = this.currentVersionSuffix;
            this.updateBackingSaveFileSilently("");
            if (this.jsonResourceExists()) {
                this.load(true);
            }
            this.updateBackingSaveFileSilently(backupVersionSuffix);
        }
        this.load(true);
    }

    @Override
    public void load(String fileName) {
        this.load(fileName, true);
    }

    @Override
    public void load(String fileName, boolean crashIfMissingKeys) {
        if (!fileName.startsWith(StringUtils.uncapitalize((String)this.workspaceDirectory.getClassForLoading().getSimpleName()))) {
            throw new RuntimeException("This filename " + fileName + " breaks the contract of the StoredPropertySet API. The filename should be the class name + suffix.");
        }
        fileName = fileName.replace(".ini", "");
        this.updateBackingSaveFile(fileName.substring(StringUtils.uncapitalize((String)this.workspaceDirectory.getClassForLoading().getSimpleName()).length()));
        this.load(crashIfMissingKeys);
    }

    public void loadUnsafe() {
        this.load(false);
    }

    private void load(boolean crashIfMissingKeys) {
        if (this.jsonResourceExists()) {
            LogTools.info((String)"Loading parameters from resource: {}", (Object)this.workspaceJSONFile.getPathForResourceLoadingPathFiltered());
            JSONFileTools.loadFromClasspath(this.classForLoading, this.workspaceJSONFile.getPathForResourceLoadingPathFiltered(), node -> {
                if (node instanceof ObjectNode) {
                    ObjectNode objectNode = (ObjectNode)node;
                    JsonNode patt13447$temp = objectNode.get("title");
                    if (patt13447$temp instanceof TextNode) {
                        TextNode textNode = (TextNode)patt13447$temp;
                        this.title = textNode.asText();
                    }
                    for (StoredPropertyKey<?> key : this.keys.keys()) {
                        String stringValue;
                        JsonNode propertyNode = objectNode.get(key.getTitleCasedName());
                        if (propertyNode == null) {
                            if (!crashIfMissingKeys && key.hasDefaultValue()) {
                                this.setInternal(key, key.getDefaultValue());
                                continue;
                            }
                            throw new RuntimeException(this.workspaceJSONFile.getClasspathResource() + " does not contain key: " + key.getTitleCasedName());
                        }
                        if (propertyNode instanceof ArrayNode) {
                            ArrayNode arrayNode = (ArrayNode)propertyNode;
                            stringValue = arrayNode.get(0).asText();
                            if (stringValue.equals("null")) {
                                LogTools.warn((String)"{} is being loaded as null. Please set it in {}", (Object)key.getCamelCasedName(), (Object)this.saveFileNameJSON);
                            } else {
                                this.setInternal(key, this.deserializeString(key, stringValue));
                            }
                            key.setDescription(arrayNode.get(1).textValue());
                            continue;
                        }
                        if (propertyNode instanceof ObjectNode) {
                            JsonNode upperBound;
                            JsonNode lowerBound;
                            ObjectNode keyObjectNode = (ObjectNode)propertyNode;
                            JsonNode valueNode = keyObjectNode.get("value");
                            JsonNode descriptionNode = keyObjectNode.get("description");
                            if (descriptionNode != null) {
                                key.setDescription(descriptionNode.textValue());
                            }
                            if (key instanceof DoubleStoredPropertyKey) {
                                DoubleStoredPropertyKey doubleKey = (DoubleStoredPropertyKey)key;
                                if (valueNode != null) {
                                    this.setInternal(key, valueNode.doubleValue());
                                }
                                if ((lowerBound = keyObjectNode.get("lowerBound")) != null) {
                                    doubleKey.setLowerBound(lowerBound.doubleValue());
                                }
                                if ((upperBound = keyObjectNode.get("upperBound")) == null) continue;
                                doubleKey.setUpperBound(upperBound.doubleValue());
                                continue;
                            }
                            if (key instanceof IntegerStoredPropertyKey) {
                                JsonNode validValues;
                                IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                                if (valueNode != null) {
                                    this.setInternal(key, valueNode.intValue());
                                }
                                if ((lowerBound = keyObjectNode.get("lowerBound")) != null) {
                                    integerKey.setLowerBound(lowerBound.intValue());
                                }
                                if ((upperBound = keyObjectNode.get("upperBound")) != null) {
                                    integerKey.setUpperBound(upperBound.intValue());
                                }
                                if (!((validValues = keyObjectNode.get("validValues")) instanceof ArrayNode)) continue;
                                ArrayNode validValuesArray = (ArrayNode)validValues;
                                int[] validValuesPrimitiveArray = new int[validValuesArray.size()];
                                for (int i = 0; i < validValuesArray.size(); ++i) {
                                    validValuesPrimitiveArray[i] = validValuesArray.get(i).intValue();
                                }
                                integerKey.setValidValues(validValuesPrimitiveArray);
                                continue;
                            }
                            if (!(key instanceof BooleanStoredPropertyKey)) continue;
                            BooleanStoredPropertyKey booleanKey = (BooleanStoredPropertyKey)key;
                            if (valueNode == null) continue;
                            this.setInternal(key, valueNode.booleanValue());
                            continue;
                        }
                        stringValue = propertyNode.asText();
                        if (stringValue.equals("null")) {
                            LogTools.warn((String)"{} is being loaded as null. Please set it in {}", (Object)key.getCamelCasedName(), (Object)this.saveFileNameJSON);
                            continue;
                        }
                        this.setInternal(key, this.deserializeString(key, stringValue));
                    }
                }
            });
        } else if (this.iniResourceExists()) {
            ExceptionTools.handle(() -> {
                Properties properties = new Properties();
                InputStream streamForLoading = this.workspaceLegacyINIFile.getClasspathResourceAsStream();
                LogTools.info((String)"Loading parameters from resource: {}/{}", (Object)this.classForLoading.getPackageName().replaceAll("\\.", "/"), (Object)this.legacyFileNameINI);
                properties.load(streamForLoading);
                for (StoredPropertyKey<?> key : this.keys.keys()) {
                    if (!properties.containsKey(key.getCamelCasedName())) {
                        if (!crashIfMissingKeys && key.hasDefaultValue()) {
                            this.setInternal(key, key.getDefaultValue());
                            continue;
                        }
                        throw new RuntimeException(this.workspaceLegacyINIFile.getClasspathResource() + " does not contain key: " + key.getCamelCasedName());
                    }
                    String stringValue = (String)properties.get(key.getCamelCasedName());
                    if (stringValue.equals("null")) {
                        LogTools.warn((String)"{} is being loaded as null. Please set it in {}", (Object)key.getCamelCasedName(), (Object)this.legacyFileNameINI);
                        continue;
                    }
                    this.setInternal(key, this.deserializeString(key, stringValue));
                }
            }, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        } else {
            LogTools.warn((String)"Parameter file {} could not be found. Values will be null.", (Object)this.workspaceJSONFile.getPathForResourceLoadingPathFiltered());
        }
    }

    private boolean iniResourceExists() {
        return this.workspaceLegacyINIFile.getClasspathResource() != null;
    }

    private boolean jsonResourceExists() {
        return this.workspaceJSONFile.getClasspathResource() != null;
    }

    @Override
    public void save() {
        Path fileForSaving = this.findFileForSaving();
        if (this.workspaceDirectory.isFileAccessAvailable()) {
            LogTools.info(StringTools.format("Saving parameters to workspace: {}", WorkspacePathTools.removePathPartsBeforeProjectFolder(fileForSaving)));
            FileTools.ensureDirectoryExists((Path)this.workspaceDirectory.getFilesystemDirectory(), (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
        } else {
            LogTools.info((String)"Saving parameters to working directory: {}", (Object)fileForSaving);
        }
        JSONFileTools.save(fileForSaving, jsonRootObjectNode -> {
            jsonRootObjectNode.put("title", this.title);
            for (StoredPropertyKey<?> key : this.keys.keys()) {
                boolean defaultValueIsNull;
                DoubleStoredPropertyKey doubleKey;
                boolean valueIsNull;
                boolean isDoubleKeyAndHasExtras = false;
                if (key instanceof DoubleStoredPropertyKey) {
                    DoubleStoredPropertyKey doubleKey2 = (DoubleStoredPropertyKey)key;
                    isDoubleKeyAndHasExtras |= doubleKey2.hasLowerBound();
                    isDoubleKeyAndHasExtras |= doubleKey2.hasUpperBound();
                }
                boolean isIntegerKeyAndHasExtras = false;
                if (key instanceof IntegerStoredPropertyKey) {
                    IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                    isIntegerKeyAndHasExtras |= integerKey.hasLowerBound();
                    isIntegerKeyAndHasExtras |= integerKey.hasUpperBound();
                    isIntegerKeyAndHasExtras |= integerKey.hasSpecifiedValidValues();
                }
                if (isDoubleKeyAndHasExtras || isIntegerKeyAndHasExtras) {
                    boolean defaultValueIsNull2;
                    ObjectNode keyObjectNode = jsonRootObjectNode.putObject(key.getTitleCasedName());
                    valueIsNull = this.get(key) == null;
                    boolean bl = defaultValueIsNull2 = key.getDefaultValue() == null;
                    if (isDoubleKeyAndHasExtras) {
                        doubleKey = (DoubleStoredPropertyKey)key;
                        keyObjectNode.put("value", valueIsNull ? (defaultValueIsNull2 ? 0.0 : (Double)key.getDefaultValue()) : this.get(doubleKey));
                        if (doubleKey.hasLowerBound()) {
                            keyObjectNode.put("lowerBound", doubleKey.getLowerBound());
                        }
                        if (doubleKey.hasUpperBound()) {
                            keyObjectNode.put("upperBound", doubleKey.getUpperBound());
                        }
                    } else if (isIntegerKeyAndHasExtras) {
                        IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                        keyObjectNode.put("value", valueIsNull ? (defaultValueIsNull2 ? 0 : (Integer)key.getDefaultValue()) : this.get(integerKey));
                        if (integerKey.hasLowerBound()) {
                            keyObjectNode.put("lowerBound", integerKey.getLowerBound());
                        }
                        if (integerKey.hasUpperBound()) {
                            keyObjectNode.put("upperBound", integerKey.getUpperBound());
                        }
                        if (integerKey.hasSpecifiedValidValues()) {
                            ArrayNode validValuesJSONArray = keyObjectNode.putArray("validValues");
                            for (int validValue : integerKey.getValidValues()) {
                                validValuesJSONArray.add(validValue);
                            }
                        }
                    }
                    if (!key.hasDescription()) continue;
                    keyObjectNode.put("description", key.getDescription());
                    continue;
                }
                if (key.hasDescription()) {
                    boolean defaultValueIsNull3;
                    ArrayNode arrayNode = jsonRootObjectNode.putArray(key.getTitleCasedName());
                    valueIsNull = this.get(key) == null;
                    boolean bl = defaultValueIsNull3 = key.getDefaultValue() == null;
                    if (key instanceof BooleanStoredPropertyKey) {
                        BooleanStoredPropertyKey booleanKey = (BooleanStoredPropertyKey)key;
                        arrayNode.add(valueIsNull ? (defaultValueIsNull3 ? false : (Boolean)key.getDefaultValue()) : this.get(booleanKey));
                    } else if (key instanceof DoubleStoredPropertyKey) {
                        DoubleStoredPropertyKey doubleKey3 = (DoubleStoredPropertyKey)key;
                        arrayNode.add(valueIsNull ? (defaultValueIsNull3 ? 0.0 : (Double)key.getDefaultValue()) : this.get(doubleKey3));
                    } else if (key instanceof IntegerStoredPropertyKey) {
                        IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                        arrayNode.add(valueIsNull ? (defaultValueIsNull3 ? 0 : (Integer)key.getDefaultValue()) : this.get(integerKey));
                    }
                    arrayNode.add(key.getDescription());
                    continue;
                }
                boolean valueIsNull2 = this.get(key) == null;
                boolean bl = defaultValueIsNull = key.getDefaultValue() == null;
                if (key instanceof BooleanStoredPropertyKey) {
                    BooleanStoredPropertyKey booleanKey = (BooleanStoredPropertyKey)key;
                    jsonRootObjectNode.put(key.getTitleCasedName(), valueIsNull2 ? (defaultValueIsNull ? false : (Boolean)key.getDefaultValue()) : this.get(booleanKey));
                    continue;
                }
                if (key instanceof DoubleStoredPropertyKey) {
                    doubleKey = (DoubleStoredPropertyKey)key;
                    jsonRootObjectNode.put(key.getTitleCasedName(), valueIsNull2 ? (defaultValueIsNull ? 0.0 : (Double)key.getDefaultValue()) : this.get(doubleKey));
                    continue;
                }
                if (!(key instanceof IntegerStoredPropertyKey)) continue;
                IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                jsonRootObjectNode.put(key.getTitleCasedName(), valueIsNull2 ? (defaultValueIsNull ? 0 : (Integer)key.getDefaultValue()) : this.get(integerKey));
            }
        });
        this.convertLineEndingsToUnix(fileForSaving);
        if (this.iniResourceExists() && this.workspaceLegacyINIFile.isFileAccessAvailable()) {
            FileTools.deleteQuietly((Path)this.workspaceLegacyINIFile.getFilesystemFile());
        }
    }

    private String serializeValue(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    private <T> T deserializeString(StoredPropertyKey<T> key, String serializedValue) {
        if (key.getType().equals(Double.class)) {
            return (T)Double.valueOf(serializedValue);
        }
        if (key.getType().equals(Integer.class)) {
            return (T)Integer.valueOf(serializedValue);
        }
        if (key.getType().equals(Boolean.class)) {
            return (T)Boolean.valueOf(serializedValue);
        }
        throw new RuntimeException("Please implement String deserialization for type: " + key.getType());
    }

    private int indexOfCamelCaseName(Object camelCaseName) {
        for (StoredPropertyKey<?> key : this.keys.keys()) {
            if (!key.getCamelCasedName().equals(camelCaseName)) continue;
            LogTools.info((String)"Index of camel case name {}: {}", (Object)camelCaseName, (Object)key.getIndex());
            return key.getIndex();
        }
        return 0;
    }

    private void convertLineEndingsToUnix(Path fileForSaving) {
        List lines = FileTools.readAllLines((Path)fileForSaving, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        PrintWriter printer = FileTools.newPrintWriter((Path)fileForSaving, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        lines.forEach(line -> printer.print(line + "\n"));
        printer.close();
    }

    public static void printInitialSaveFileContents(List<StoredPropertyKey<?>> keys) {
        for (StoredPropertyKey<?> parameterKey : keys) {
            System.out.println(parameterKey.getCamelCasedName() + "=");
        }
    }

    private Path findFileForSaving() {
        return this.findSaveFileDirectory().resolve(this.saveFileNameJSON);
    }

    @Override
    public Path findSaveFileDirectory() {
        if (this.workspaceDirectory.isFileAccessAvailable()) {
            return this.workspaceDirectory.getFilesystemDirectory();
        }
        return Paths.get("", new String[0]);
    }

    @Override
    public StoredPropertyKeyListReadOnly getKeyList() {
        return this.keys;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StoredPropertySet)) {
            return false;
        }
        StoredPropertySet other = (StoredPropertySet)object;
        return Objects.deepEquals(this.values, other.values);
    }

    @Override
    public void setFromColonCommaString(String colonCommaString) {
        colonCommaString = colonCommaString.replace(",", "");
        Scanner scanner = new Scanner(colonCommaString);
        for (StoredPropertyKey<?> key : this.keys.keys()) {
            if (key instanceof DoubleStoredPropertyKey) {
                DoubleStoredPropertyKey doubleKey = (DoubleStoredPropertyKey)key;
                while (!scanner.hasNextDouble()) {
                    scanner.next();
                }
                this.set(doubleKey, scanner.nextDouble());
                continue;
            }
            if (key instanceof IntegerStoredPropertyKey) {
                IntegerStoredPropertyKey integerKey = (IntegerStoredPropertyKey)key;
                while (!scanner.hasNextInt()) {
                    scanner.next();
                }
                this.set(integerKey, scanner.nextInt());
                continue;
            }
            if (!(key instanceof BooleanStoredPropertyKey)) continue;
            BooleanStoredPropertyKey booleanKey = (BooleanStoredPropertyKey)key;
            while (!scanner.hasNextBoolean()) {
                scanner.next();
            }
            this.set(booleanKey, scanner.nextBoolean());
        }
        scanner.close();
    }

    public String toString() {
        List<StoredPropertyKey<?>> storedPropertyKeys = this.keys.keys();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < storedPropertyKeys.size(); ++i) {
            StoredPropertyKey<?> key = storedPropertyKeys.get(i);
            result.append(key.getCamelCasedName());
            result.append(": ");
            result.append(this.serializeValue(this.get(key)));
            if (i >= storedPropertyKeys.size() - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }

    @Override
    public String getCurrentVersionSuffix() {
        return this.currentVersionSuffix;
    }

    @Override
    public String getCapitalizedClassName() {
        return this.capitalizedClassName;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }
}

