/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import java.io.File;
import java.io.PrintStream;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.tools.processManagement.ExitListener;
import us.ihmc.tools.processManagement.ProcessSpawner;
import us.ihmc.tools.processManagement.ProcessTools;

public class JavaProcessSpawner
extends ProcessSpawner {
    private final String javaHome = System.getProperty("java.home");
    private final String currentClassPath = System.getProperty("java.class.path");
    private final String currentNativeLibraryPath = System.getProperty("java.library.path");
    private final String ldLibraryPath = System.getenv("LD_LIBRARY_PATH");
    private final boolean useEnvironmentForClasspath;

    public JavaProcessSpawner(boolean killChildProcessesOnShutdown, boolean useEnvironmentForClasspath) {
        super(killChildProcessesOnShutdown);
        this.useEnvironmentForClasspath = useEnvironmentForClasspath;
    }

    public JavaProcessSpawner(boolean killChildProcessesOnShutdown) {
        this(killChildProcessesOnShutdown, false);
    }

    public Process spawn(Class<?> mainClass) {
        return this.spawn(mainClass, null, null, null, null, null, null, null);
    }

    public Process spawn(Class<?> mainClass, String[] progArgs) {
        return this.spawn(mainClass, null, progArgs, null, null, null, null, null);
    }

    public Process spawn(Class<?> mainClass, String[] javaArgs, String[] programArgs) {
        return this.spawn(mainClass, javaArgs, programArgs, null, null, null, null, null);
    }

    public Process spawn(Class<?> mainClass, String[] javaArgs, String[] programArgs, File outputLog, File errorLog) {
        return this.spawn(mainClass, javaArgs, programArgs, outputLog, errorLog, null, null, null);
    }

    public Process spawn(Class<?> mainClass, String[] javaArgs, String[] programArgs, File outputLog, File errorLog, ExitListener exitListener) {
        return this.spawn(mainClass, javaArgs, programArgs, outputLog, errorLog, null, null, exitListener);
    }

    public Process spawn(Class<?> mainClass, String[] javaArgs, String[] programArgs, PrintStream outputStream, PrintStream errorStream) {
        return this.spawn(mainClass, javaArgs, programArgs, null, null, outputStream, errorStream, null);
    }

    public Process spawn(Class<?> mainClass, String[] javaArgs, String[] programArgs, ExitListener exitListener) {
        return this.spawn(mainClass, javaArgs, programArgs, null, null, null, null, exitListener);
    }

    public Process spawn(Class<?> mainClass, ExitListener exitListener) {
        return this.spawn(mainClass, null, null, null, null, null, null, exitListener);
    }

    public Process spawn(Class<?> mainClass, String[] javaArgs, String[] programArgs, File outputFile, File errorFile, PrintStream outputStream, PrintStream errorStream, ExitListener exitListener) {
        return this.spawn(mainClass, javaArgs, programArgs, outputFile, errorFile, outputStream, errorStream, ProcessSpawner.defaultPrintingPrefix(mainClass.getSimpleName()), exitListener);
    }

    public Process spawn(Class<?> mainClass, String[] javaArgs, String[] programArgs, File outputFile, File errorFile, PrintStream outputStream, PrintStream errorStream, String processPrintingPrefix, ExitListener exitListener) {
        String[] spawnString = ProcessTools.constructJavaProcessCommand(this.javaHome, this.currentNativeLibraryPath, this.useEnvironmentForClasspath ? null : this.currentClassPath, mainClass, javaArgs, programArgs);
        ProcessBuilder builder = new ProcessBuilder(spawnString);
        if (SystemUtils.IS_OS_UNIX && this.ldLibraryPath != null) {
            builder.environment().put("LD_LIBRARY_PATH", this.ldLibraryPath);
        }
        if (this.useEnvironmentForClasspath) {
            builder.environment().put("CLASSPATH", this.currentClassPath);
        }
        return this.spawn(mainClass.getSimpleName(), spawnString, builder, outputFile, errorFile, outputStream, errorStream, processPrintingPrefix, exitListener);
    }

    public void prettyPrintClassPath() {
        String[] paths;
        for (String path : paths = this.currentClassPath.split(File.pathSeparator)) {
            System.out.println(path);
        }
    }

    public void prettyPrintNativeLibraryPath() {
        String[] paths;
        for (String path : paths = this.currentNativeLibraryPath.split(File.pathSeparator)) {
            System.out.println(path);
        }
    }

    @Override
    public void kill(Process process) {
        process.destroy();
    }
}

