/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Pattern;

public abstract class CallbackPrintStream
extends PrintStream {
    private static final Pattern newlinePattern = Pattern.compile("\\r?\\n");

    public CallbackPrintStream() {
        super(new FlushingOutputStream(), true);
        ((FlushingOutputStream)this.out).setCallback(this);
    }

    public abstract void outputLine(String var1);

    private static class FlushingOutputStream
    extends ByteArrayOutputStream {
        private CallbackPrintStream callbackPrintStream;

        private FlushingOutputStream() {
        }

        @Override
        public synchronized void flush() {
            if (this.count > 0 && this.buf[this.count - 1] == 10) {
                String[] messages;
                for (String message : messages = newlinePattern.split(this.toString())) {
                    this.callbackPrintStream.outputLine(message);
                }
                this.reset();
            }
        }

        public void setCallback(CallbackPrintStream callbackPrintStream) {
            this.callbackPrintStream = callbackPrintStream;
        }
    }
}

