/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick.virtualJoystick;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.Rumbler;
import us.ihmc.tools.inputDevices.joystick.virtualJoystick.VirtualComponent;

public class VirtualJoystickController
extends AbstractController {
    private static final Component.Identifier[] identifiers = new Component.Identifier[10];
    private static final Component[] components = new Component[identifiers.length];
    private static final HashMap<Component.Identifier, Component> identifierToComponentMap = new HashMap();
    private final ConcurrentLinkedQueue<Event> eventQueue = new ConcurrentLinkedQueue();

    protected VirtualJoystickController(String name) {
        super(name, components, new Controller[0], new Rumbler[0]);
    }

    public void queueEvent(Component.Identifier identifier, double value) {
        Event event = new Event();
        event.set(identifierToComponentMap.get(identifier), (float)value, System.nanoTime());
        this.eventQueue.add(event);
    }

    protected boolean getNextDeviceEvent(Event event) throws IOException {
        if (!this.eventQueue.isEmpty()) {
            event.set(this.eventQueue.poll());
            return true;
        }
        return false;
    }

    public Controller.Type getType() {
        return Controller.Type.STICK;
    }

    static {
        VirtualJoystickController.identifiers[0] = Component.Identifier.Axis.X;
        VirtualJoystickController.identifiers[1] = Component.Identifier.Axis.Y;
        VirtualJoystickController.identifiers[2] = Component.Identifier.Axis.Z;
        VirtualJoystickController.identifiers[3] = Component.Identifier.Axis.RX;
        VirtualJoystickController.identifiers[4] = Component.Identifier.Axis.RY;
        VirtualJoystickController.identifiers[5] = Component.Identifier.Axis.RZ;
        VirtualJoystickController.identifiers[6] = Component.Identifier.Axis.SLIDER;
        VirtualJoystickController.identifiers[7] = Component.Identifier.Axis.POV;
        VirtualJoystickController.identifiers[8] = Component.Identifier.Button._0;
        VirtualJoystickController.identifiers[9] = Component.Identifier.Button._1;
        for (int i = 0; i < identifiers.length; ++i) {
            VirtualJoystickController.components[i] = new VirtualComponent(identifiers[i].getName(), identifiers[i]);
            identifierToComponentMap.put(identifiers[i], components[i]);
        }
    }
}

