/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.inputDevices.joystick;

import net.java.games.input.Component;
import us.ihmc.tools.inputDevices.joystick.JoystickComponentFilter;
import us.ihmc.tools.inputDevices.joystick.mapping.JoystickMapping;

public class JoystickCustomizationFilter
implements JoystickComponentFilter {
    private final JoystickMapping mapping;
    private final boolean invert;
    private final int exponent;
    private final double restToZeroCorrection;
    private final double deadzone;

    public JoystickCustomizationFilter(JoystickMapping channel, boolean invert) {
        this(channel, invert, 0.0);
    }

    public JoystickCustomizationFilter(JoystickMapping channel, boolean invert, double deadzone) {
        this(channel, invert, deadzone, 1);
    }

    public JoystickCustomizationFilter(JoystickMapping channel, boolean invert, double deadzone, int exponent) {
        this(channel, invert, deadzone, exponent, 0.0);
    }

    public JoystickCustomizationFilter(JoystickMapping channel, boolean invert, double deadzone, int exponent, double restToZeroCorrection) {
        if (exponent % 2 == 0) {
            throw new IllegalArgumentException("Only odd functions are allowed");
        }
        this.mapping = channel;
        this.invert = invert;
        this.deadzone = deadzone;
        this.exponent = exponent;
        this.restToZeroCorrection = restToZeroCorrection;
    }

    @Override
    public double apply(double value) {
        value = Math.abs(value += this.restToZeroCorrection) < this.deadzone ? 0.0 : (value - Math.signum(value) * this.deadzone) / (1.0 - this.deadzone);
        return Math.pow((double)(this.invert ? -1 : 1) * value, this.exponent);
    }

    @Override
    public Component.Identifier getIdentifier() {
        return this.mapping.getIdentifier();
    }
}

