/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.gui;

import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TextAreaOutputStream
extends OutputStream {
    private final JTextArea textArea;
    private final StringBuilder sb = new StringBuilder();

    public TextAreaOutputStream(JTextArea textArea) {
        this.textArea = textArea;
    }

    @Override
    public void flush() {
        final String text = this.sb.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextAreaOutputStream.this.textArea.append(text);
            }
        });
        this.sb.setLength(0);
    }

    @Override
    public void close() {
    }

    @Override
    public void write(int b) throws IOException {
        this.sb.append((char)b);
    }
}

