/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class GuidedSwapReference<T> {
    private final T a;
    private final T b;
    private T forLowPriorityThread;
    private T forHighPriorityThread;
    private final Consumer<T> accessOnLowPriorityThread;
    private final Consumer<T> accessOnHighPriorityThread;

    public GuidedSwapReference(Supplier<T> supplier, Consumer<T> accessOnLowPriorityThread, Consumer<T> accessOnHighPriorityThread) {
        this.a = supplier.get();
        this.b = supplier.get();
        this.forLowPriorityThread = this.a;
        this.forHighPriorityThread = this.b;
        this.accessOnLowPriorityThread = accessOnLowPriorityThread;
        this.accessOnHighPriorityThread = accessOnHighPriorityThread;
    }

    public void initializeBoth(Consumer<T> consumer) {
        consumer.accept(this.a);
        consumer.accept(this.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessOnLowPriorityThread() {
        this.accessOnLowPriorityThread.accept(this.forLowPriorityThread);
        GuidedSwapReference guidedSwapReference = this;
        synchronized (guidedSwapReference) {
            T wasHighPriorityThread = this.forHighPriorityThread;
            this.forHighPriorityThread = this.forLowPriorityThread;
            this.forLowPriorityThread = wasHighPriorityThread;
        }
    }

    public synchronized void accessOnHighPriorityThread() {
        this.accessOnHighPriorityThread.accept(this.forHighPriorityThread);
    }
}

