/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.processManagement;

import us.ihmc.commons.PrintTools;
import us.ihmc.tools.processManagement.ProcessSpawner;
import us.ihmc.tools.processManagement.UnixProcessKiller;

public abstract class UnixProcessSpawner
extends ProcessSpawner {
    public UnixProcessSpawner(boolean killChildProcessesOnShutdown) {
        super(killChildProcessesOnShutdown);
    }

    @Override
    public void kill(Process process) {
        if (UnixProcessKiller.isUnixProcess(process)) {
            PrintTools.info((String)"Attempting to SigInt process");
            this.attemptSigInt(process);
            if (this.hasProcessExited(process)) {
                return;
            }
        }
        PrintTools.info((String)"SigInt failed, escalting to SigTerm");
        this.attemptDestroy(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptSigInt(Process process) {
        Object o;
        Object object = o = this.waitForUnixProcessSigInt(process);
        synchronized (object) {
            try {
                o.wait(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDestroy(Process process) {
        Object o;
        Object object = o = this.waitForProcessDestroy(process);
        synchronized (object) {
            try {
                o.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private Object waitForUnixProcessSigInt(final Process process) {
        final Object monitorObject = new Object();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UnixProcessKiller.killSigIntUnixProcess(process);
                try {
                    process.waitFor();
                    Object object = monitorObject;
                    synchronized (object) {
                        monitorObject.notifyAll();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, "IHMC-UnixProcessSpawnerWait").start();
        return monitorObject;
    }

    private Object waitForProcessDestroy(final Process process) {
        final Object monitorObject = new Object();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                process.destroy();
                try {
                    process.waitFor();
                    Object object = monitorObject;
                    synchronized (object) {
                        monitorObject.notifyAll();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, "IHMC-UnixProcessSpawnerWait").start();
        return monitorObject;
    }

    private boolean hasProcessExited(Process process) {
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
        return true;
    }
}

