/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import us.ihmc.log.LogTools;

public class JSONLogger<T> {
    private ObjectMapper objectMapper = new ObjectMapper();
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final String logDirectory = System.getProperty("user.home") + File.separator + ".ihmc" + File.separator + "logs" + File.separator;
    String fileName = null;
    private PrintStream printStream = null;
    private boolean isClosed = false;

    public boolean put(T o) {
        if (this.fileName == null) {
            LogTools.info((String)("Starting JSONLogger instance for " + o.getClass().getSimpleName() + "..."));
            this.fileName = logDirectory + dateFormat.format(new Date()) + "_" + o.getClass().getSimpleName() + "_Log.json";
            try {
                FileOutputStream outputStream = new FileOutputStream(this.fileName);
                this.printStream = new PrintStream(outputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            this.printStream.println("{");
            this.printStream.println("\"type\": \"" + o.getClass().getSimpleName() + "\",");
            this.printStream.println("\"data\": [");
        } else {
            this.printStream.println(",");
        }
        try {
            this.printStream.write(this.objectMapper.writeValueAsBytes(o));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public void close() {
        LogTools.info((String)("Closing " + this.fileName));
        this.printStream.println("]\n}");
        this.printStream.flush();
        this.printStream.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void finalize() {
        if (!this.isClosed) {
            this.close();
        }
    }
}

