/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.HybridResourceFile;
import us.ihmc.tools.io.WorkspaceFile;
import us.ihmc.tools.io.WorkspacePathTools;
import us.ihmc.tools.io.WorkspaceResourceFile;

public class JSONFileTools {
    public static void loadWithClasspathDefault(Path settingsPath, Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String resourcePackage, Consumer<JsonNode> jsonNodeConsumer) {
        InputStream settingsStream;
        if (!Files.exists(settingsPath, new LinkOption[0])) {
            String resourcePathString = Paths.get(resourcePackage, new String[0]).resolve(settingsPath.getFileName()).toString();
            settingsStream = classForLoading.getResourceAsStream(resourcePathString);
            if (settingsStream == null) {
                String fullResourcePathString = WorkspacePathTools.findPathToResource(directoryNameToAssumePresent, subsequentPathToResourceFolder, resourcePathString).resolve(settingsPath.getFileName()).toString();
                LogTools.warn((String)"{} not found. Please save defaults to {}. Not loading anything.", (Object)settingsPath.toString(), (Object)fullResourcePathString);
                return;
            }
            LogTools.info((String)"{} not found. Loading defaults from {}", (Object)settingsPath.toString(), (Object)resourcePathString);
        } else {
            LogTools.info((String)"Loading {}", (Object)settingsPath.toString());
            settingsStream = FileTools.newFileDataInputStream((Path)settingsPath, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        }
        try (DataInputStream closableStream = settingsStream;){
            JSONFileTools.loadInternal(closableStream, jsonNodeConsumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadUserWithClasspathDefaultFallback(HybridResourceFile hybridFile, Consumer<JsonNode> jsonNodeConsumer) {
        InputStream settingsStream;
        if (!Files.exists(hybridFile.getExternalFile(), new LinkOption[0])) {
            settingsStream = hybridFile.getClasspathResourceAsStream();
            if (settingsStream == null) {
                LogTools.warn((String)"Defaults not found. Please save to {}. Not loading anything.", (Object)hybridFile.getPathForResourceLoadingPathFiltered());
                return;
            }
            LogTools.info((String)"{} not found. Loading defaults from {}", (Object)hybridFile.getExternalFile().toString(), (Object)hybridFile.getPathForResourceLoadingPathFiltered());
        } else {
            LogTools.info((String)"Loading {}", (Object)hybridFile.getExternalFile().toString());
            settingsStream = FileTools.newFileDataInputStream((Path)hybridFile.getExternalFile(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        }
        try (InputStream closableStream = settingsStream;){
            JSONFileTools.loadInternal(closableStream, jsonNodeConsumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void load(WorkspaceResourceFile file, Consumer<JsonNode> jsonNodeConsumer) {
        JSONFileTools.load(file.getClasspathResourceAsStream(), jsonNodeConsumer);
    }

    public static void loadFromWorkspace(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String resourcePathString, Consumer<JsonNode> jsonNodeConsumer) {
        JSONFileTools.load(WorkspacePathTools.findPathToResource(directoryNameToAssumePresent, subsequentPathToResourceFolder, resourcePathString), jsonNodeConsumer);
    }

    public static boolean loadFromClasspath(Class<?> classForLoading, String resourcePathString, Consumer<JsonNode> jsonNodeConsumer) {
        boolean bl;
        block8: {
            InputStream resourceStream = classForLoading.getResourceAsStream(resourcePathString);
            try {
                JSONFileTools.loadInternal(resourceStream, jsonNodeConsumer);
                bl = true;
                if (resourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            resourceStream.close();
        }
        return bl;
    }

    public static boolean load(Path filePath, Consumer<JsonNode> jsonNodeConsumer) {
        boolean bl;
        block8: {
            DataInputStream fileStream = FileTools.newFileDataInputStream((Path)filePath, (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
            try {
                JSONFileTools.loadInternal(fileStream, jsonNodeConsumer);
                bl = true;
                if (fileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileStream != null) {
                        try {
                            ((InputStream)fileStream).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ((InputStream)fileStream).close();
        }
        return bl;
    }

    private static void loadInternal(InputStream fileStream, Consumer<JsonNode> jsonNodeConsumer) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
        JsonNode jsonNode = objectMapper.readTree(fileStream);
        jsonNodeConsumer.accept(jsonNode);
    }

    public static void load(InputStream fileStream, Consumer<JsonNode> jsonNodeConsumer) {
        try {
            JSONFileTools.loadInternal(fileStream, jsonNodeConsumer);
        }
        catch (IOException e) {
            LogTools.error((String)"Could not load JSON.");
            e.printStackTrace();
        }
    }

    public static boolean saveToClasspath(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String resourcePathString, Consumer<ObjectNode> rootConsumer) {
        return JSONFileTools.save(WorkspacePathTools.findPathToResource(directoryNameToAssumePresent, subsequentPathToResourceFolder, resourcePathString), rootConsumer);
    }

    public static boolean save(WorkspaceFile workspaceFile, Consumer<ObjectNode> rootConsumer) {
        return JSONFileTools.save(workspaceFile.getFilesystemFile(), rootConsumer);
    }

    public static boolean save(Path settingsPath, Consumer<ObjectNode> rootConsumer) {
        if (settingsPath.getParent() != null) {
            FileTools.ensureDirectoryExists((Path)settingsPath.getParent(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        }
        PrintStream printStream = new PrintStream(settingsPath.toFile());
        try {
            JsonFactory jsonFactory = new JsonFactory();
            ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
            ObjectNode root = objectMapper.createObjectNode();
            rootConsumer.accept(root);
            objectMapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)printStream, (Object)root);
            boolean bl = true;
            printStream.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    printStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

