/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.dataSampling;

import java.util.ArrayList;
import java.util.HashMap;

public class DataSampler<T> {
    private int requestedNumberOfSamples;
    private int numberOfVariables;
    private int counter;
    private double timeInterval;
    private double deltaTime;
    private double initialTime;
    private double acquisitionTime;
    private String[] variableNames;
    private HashMap<String, ArrayList<T>> allData = new HashMap();

    public void initialize(String[] variableNames, double initialTime, double timeInterval, int requestedNumberOfSamples) {
        this.requestedNumberOfSamples = requestedNumberOfSamples;
        this.variableNames = variableNames;
        this.numberOfVariables = variableNames.length;
        this.initialTime = initialTime;
        this.setTimeInterval(timeInterval);
        this.generateAllDataMap();
    }

    public void reInitialize(double initialTime, double timeInterval, int requestedNumberOfSamples) {
        this.initialTime = initialTime;
        this.requestedNumberOfSamples = requestedNumberOfSamples;
        this.setTimeInterval(timeInterval);
    }

    public void acquire(double time, HashMap<String, T> values) {
        this.acquisitionTime = time - this.initialTime;
        if (this.acquisitionTime > this.deltaTime * (double)this.counter) {
            this.addSample(values);
            ++this.counter;
        }
    }

    public void setTimeInterval(double time) {
        this.timeInterval = time;
        this.computeDeltaTimeAndResetCounter();
    }

    public synchronized void emptyAllSamplesButKeepVariables() {
        for (int i = 0; i < this.numberOfVariables; ++i) {
            this.allData.get(this.variableNames[i]).clear();
        }
    }

    public synchronized void removeAllVariables() {
        this.allData.clear();
    }

    public synchronized ArrayList<T> getSingleVariableSamples(String variableName) {
        return this.allData.get(variableName);
    }

    public synchronized HashMap<String, ArrayList<T>> getAllData() {
        return this.allData;
    }

    public synchronized HashMap<String, ArrayList<T>> getAllDataCopy() {
        HashMap<String, ArrayList<T>> ret = new HashMap<String, ArrayList<T>>();
        for (int i = 0; i < this.numberOfVariables; ++i) {
            ret.put(this.variableNames[i], new ArrayList(this.allData.get(this.variableNames[i])));
        }
        return ret;
    }

    public double getDeltaTime() {
        return this.deltaTime;
    }

    private synchronized void generateAllDataMap() {
        this.removeAllVariables();
        for (int i = 0; i < this.numberOfVariables; ++i) {
            this.allData.put(this.variableNames[i], new ArrayList());
        }
        this.emptyAllSamplesButKeepVariables();
    }

    private synchronized void addSample(HashMap<String, T> values) {
        for (int i = 0; i < this.numberOfVariables; ++i) {
            this.allData.get(this.variableNames[i]).add(values.get(this.variableNames[i]));
        }
    }

    private void computeDeltaTimeAndResetCounter() {
        this.deltaTime = this.timeInterval / (double)this.requestedNumberOfSamples;
        this.counter = 0;
    }
}

