/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class UnsafeTools {
    private static Unsafe unsafe;

    public static void printAddresses(String label, Object ... objects) {
        boolean is64bit = true;
        long last = 0L;
        int offset = unsafe.arrayBaseOffset(objects.getClass());
        int scale = unsafe.arrayIndexScale(objects.getClass());
        switch (scale) {
            case 4: {
                long factor = is64bit ? 8L : 1L;
                long i1 = ((long)unsafe.getInt(objects, offset) & 0xFFFFFFFFL) * factor;
                System.out.print(Long.toHexString(i1));
                last = i1;
                for (int i = 1; i < objects.length; ++i) {
                    long i2 = ((long)unsafe.getInt(objects, offset + i * 4) & 0xFFFFFFFFL) * factor;
                    if (i2 > last) {
                        System.out.print(", +" + Long.toHexString(i2 - last));
                    } else {
                        System.out.print(", -" + Long.toHexString(last - i2));
                    }
                    last = i2;
                }
                break;
            }
            case 8: {
                throw new AssertionError((Object)"Not supported");
            }
        }
        System.out.println();
    }

    public static long addressOf(Object o) throws Exception {
        Object[] array = new Object[]{o};
        long baseOffset = unsafe.arrayBaseOffset(Object[].class);
        int addressSize = unsafe.addressSize();
        return switch (addressSize) {
            case 4 -> unsafe.getInt(array, baseOffset);
            case 8 -> unsafe.getLong(array, baseOffset);
            default -> throw new Error("unsupported address size: " + addressSize);
        };
    }

    public static void main(String ... args) throws Exception {
        char[] mine = "Hi there".toCharArray();
        long address = UnsafeTools.addressOf(mine);
        System.out.println("Address: " + address);
        UnsafeTools.printBytes(address, 27);
    }

    public static void printBytes(long objectAddress, int num) {
        for (long i = 0L; i < (long)num; ++i) {
            byte cur = unsafe.getByte(objectAddress + i);
            System.out.print((char)cur);
        }
        System.out.println();
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

