/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.io;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.TreeSet;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.nio.PathTools;
import us.ihmc.log.LogTools;

public class WorkspacePathTools {
    private static final ThreadLocal<TreeSet<String>> printedInferredSourceSetDirectory = ThreadLocal.withInitial(TreeSet::new);

    public static Path findPathToResource(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String resourcePathString) {
        Path directoryInline = PathTools.findDirectoryInline((String)directoryNameToAssumePresent);
        if (directoryInline != null) {
            return directoryInline.resolve(subsequentPathToResourceFolder).resolve(resourcePathString).toAbsolutePath().normalize();
        }
        return null;
    }

    public static Path findPath(String directoryNameToAssumePresent, String subsequentPath) {
        Path directoryInline = PathTools.findDirectoryInline((String)directoryNameToAssumePresent);
        if (directoryInline != null) {
            return directoryInline.resolve(subsequentPath).toAbsolutePath().normalize();
        }
        return null;
    }

    public static Path handleWorkingDirectoryFuzziness(String directoryNameToFind) {
        Path absoluteWorkingDirectory = WorkspacePathTools.getWorkingDirectory();
        Path pathBuiltFromSystemRoot = Paths.get("/", new String[0]).toAbsolutePath().normalize();
        boolean directoryFound = false;
        for (Path path : absoluteWorkingDirectory) {
            pathBuiltFromSystemRoot = pathBuiltFromSystemRoot.resolve(path);
            if (!path.toString().equals(directoryNameToFind)) continue;
            directoryFound = true;
            break;
        }
        if (!directoryFound && Files.exists(pathBuiltFromSystemRoot.resolve(directoryNameToFind), new LinkOption[0])) {
            pathBuiltFromSystemRoot = pathBuiltFromSystemRoot.resolve(directoryNameToFind);
            directoryFound = true;
        }
        if (!directoryFound) {
            LogTools.warn((String)"{} directory could not be found. Working directory: {} Search stopped at: {}", (Object)directoryNameToFind, (Object)absoluteWorkingDirectory, (Object)pathBuiltFromSystemRoot);
            return null;
        }
        return pathBuiltFromSystemRoot;
    }

    public static Path getWorkingDirectory() {
        return Paths.get(".", new String[0]).toAbsolutePath().normalize();
    }

    public static Path inferFilesystemSourceSetDirectory(Class<?> classForFindingSourceSetDirectory) {
        Path inferredSourceSetDirectory = null;
        try {
            URI locationURI;
            ProtectionDomain protectionDomain = classForFindingSourceSetDirectory.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            URL location = codeSource == null ? null : codeSource.getLocation();
            URI uRI = locationURI = location == null ? null : (URI)ExceptionTools.handle(location::toURI, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            if (locationURI != null && !location.getPath().isEmpty()) {
                Path codeSourceDirectory = Paths.get(locationURI);
                LogTools.debug((String)"Code source directory: {}", (Object)codeSourceDirectory);
                int lastIndexOfOut = WorkspacePathTools.findLastIndexOfPart(codeSourceDirectory, "out");
                int lastIndexOfBin = WorkspacePathTools.findLastIndexOfPart(codeSourceDirectory, "bin");
                int indexOfBuildFolder = Math.max(lastIndexOfOut, lastIndexOfBin);
                if (indexOfBuildFolder >= 0) {
                    TreeSet<String> classesPrinted;
                    boolean printed;
                    inferredSourceSetDirectory = Paths.get("/", new String[0]).resolve(codeSourceDirectory.subpath(0, indexOfBuildFolder));
                    int lastIndexOfSrc = WorkspacePathTools.findLastIndexOfPart(codeSourceDirectory, "src");
                    if (lastIndexOfSrc < 0) {
                        inferredSourceSetDirectory = inferredSourceSetDirectory.resolve("src/main");
                    }
                    if (!(printed = (classesPrinted = printedInferredSourceSetDirectory.get()).contains(classForFindingSourceSetDirectory.getName()))) {
                        classesPrinted.add(classForFindingSourceSetDirectory.getName());
                        LogTools.info((String)"Inferred source set directory:\n {}", (Object)WorkspacePathTools.removePathPartsBeforeProjectFolder(inferredSourceSetDirectory));
                    }
                } else {
                    LogTools.warn((String)"No out or bin folder found and we don't know how to deal with that.");
                }
            } else {
                LogTools.warn((String)"This class is not normally compiled or JAR not normally built.");
            }
        }
        catch (SecurityException securityException) {
            LogTools.error((String)securityException.getMessage());
        }
        return inferredSourceSetDirectory;
    }

    public static Path removePathPartsBeforeProjectFolder(Path absolutePathInSourceDirectory) {
        int lastIndexOfSrc = WorkspacePathTools.findLastIndexOfPart(absolutePathInSourceDirectory, "src");
        if (lastIndexOfSrc > 0) {
            return absolutePathInSourceDirectory.subpath(lastIndexOfSrc - 1, absolutePathInSourceDirectory.getNameCount());
        }
        return absolutePathInSourceDirectory;
    }

    private static int findLastIndexOfPart(Path pathToSearch, String partName) {
        int lastIndexOfPart = -1;
        for (int nameElementIndex = 0; nameElementIndex < pathToSearch.getNameCount(); ++nameElementIndex) {
            if (!pathToSearch.getName(nameElementIndex).toString().equals(partName)) continue;
            lastIndexOfPart = nameElementIndex;
        }
        return lastIndexOfPart;
    }
}

