/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.tools.thread;

import java.util.Random;
import us.ihmc.tools.thread.InterruptableWorker;

public class DebugInterruptableWorker
extends InterruptableWorker {
    private int result;
    private int endNumber;
    private int countBy;

    public void reset(int startNumber, int endNumber, int countBy) {
        super.reset();
        this.endNumber = endNumber;
        this.countBy = countBy;
        this.result = startNumber;
    }

    @Override
    public InterruptableWorker.STATE doWork() {
        while (!this.isInterrupted()) {
            this.result += this.countBy;
            if (this.result == this.endNumber) {
                return InterruptableWorker.STATE.SUCCESSFULLY_COMPLETED;
            }
            if (this.result > this.endNumber) {
                return InterruptableWorker.STATE.UNSUCCESSFULLY_COMPLETED;
            }
            this.busyWork();
            this.result += this.countBy;
            if (this.result == this.endNumber) {
                return InterruptableWorker.STATE.SUCCESSFULLY_COMPLETED;
            }
            if (this.result > this.endNumber) {
                return InterruptableWorker.STATE.UNSUCCESSFULLY_COMPLETED;
            }
            this.busyWork();
            this.result += this.countBy;
            if (this.result == this.endNumber) {
                return InterruptableWorker.STATE.SUCCESSFULLY_COMPLETED;
            }
            if (this.result > this.endNumber) {
                return InterruptableWorker.STATE.UNSUCCESSFULLY_COMPLETED;
            }
            this.busyWork();
        }
        return InterruptableWorker.STATE.INTERRUPTED;
    }

    private void busyWork() {
        Random random = new Random(this.result);
        int n = random.nextInt(10000000);
        for (int i = 0; i < 5000000 + n; ++i) {
            int n2 = n * n;
        }
    }

    @Override
    public Object getCurrentResult() {
        return this.result;
    }

    public static void main(String[] args) {
        System.out.println("----------------------------------------------");
        System.out.println("creating worker");
        DebugInterruptableWorker worker = new DebugInterruptableWorker();
        System.out.println("resetting worker");
        worker.reset(0, 100, 1);
        System.out.println("starting worker");
        worker.startWorkOnANewThread();
        System.out.println("letting worker finish");
        worker.waitForResult(100000L);
        System.out.println("result");
        System.out.println("Worker finished with a state = " + worker.getCurrentState());
        System.out.println("Worker final result = " + worker.getCurrentResult());
        System.out.println("----------------------------------------------");
        System.out.println("resetting worker to a non-solution");
        worker.reset(1, 200, 2);
        System.out.println("starting worker");
        worker.startWorkOnANewThread();
        System.out.println("letting worker finish");
        worker.waitForResult(100000L);
        System.out.println("result");
        System.out.println("Worker finished with a state = " + worker.getCurrentState());
        System.out.println("Worker final result = " + worker.getCurrentResult());
        System.out.println("----------------------------------------------");
        System.out.println("creating worker");
        worker = new DebugInterruptableWorker();
        System.out.println("resetting worker");
        worker.reset(0, 555, 5);
        System.out.println("starting worker");
        worker.startWorkOnANewThread();
        System.out.println("letting worker finish");
        worker.waitForResult(1000L);
        System.out.println("result");
        System.out.println("Worker finished with a state = " + worker.getCurrentState());
        System.out.println("Worker final result = " + worker.getCurrentResult());
        System.out.println("----------------------------------------------");
        System.out.println("resetting worker");
        worker.reset(0, 100, 1);
        System.out.println("starting worker");
        worker.startWorkOnANewThread();
        System.out.println("wait a bit");
        while ((Integer)worker.getCurrentResult() < 40) {
            System.out.println("result=" + worker.getCurrentResult());
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("interrupt");
        long t = System.currentTimeMillis();
        worker.stopWork();
        System.out.println("interrupt took " + (System.currentTimeMillis() - t));
        System.out.println("result");
        System.out.println("Worker finished with a state = " + worker.getCurrentState());
        System.out.println("Worker final result = " + worker.getCurrentResult());
        System.out.println("----------------------------------------------");
        System.out.println("resetting worker");
        worker.reset(0, 1, 1);
        System.out.println("starting worker");
        worker.startWorkOnANewThread();
        Thread thread = new Thread((Runnable)new SetState(worker), "IHMC-InterruptableWorker");
        thread.setDaemon(true);
        thread.start();
        System.out.println("interrupt");
        t = System.currentTimeMillis();
        worker.stopWork();
        System.out.println("interrupt took " + (System.currentTimeMillis() - t));
        System.out.println("result");
        System.out.println("Worker finished with a state = " + worker.getCurrentState());
        System.out.println("Worker final result = " + worker.getCurrentResult());
    }

    static class SetState
    implements Runnable {
        private InterruptableWorker worker;

        public SetState(InterruptableWorker worker) {
            this.worker = worker;
        }

        @Override
        public void run() {
            this.worker.setCurrentState(InterruptableWorker.STATE.INTERRUPTED);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

